/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.GUILayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListenerList;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.CameraTelemetry;

class GUIDirectLayer
implements GUILayer {
    private final OCSBridge bridge;
    private final EventListenerList<CameraEvent> cell = new EventListenerList();
    private final EventListenerList<CameraStateChangeEvent> cscel = new EventListenerList();

    GUIDirectLayer(OCSBridge bridge) {
        this.bridge = bridge;
        bridge.setOCSCommandExecutor(new OCSCommandExecutor(bridge){

            @Override
            void sendTelemetry(CameraTelemetry telemetry) {
                super.sendTelemetry(telemetry);
            }

            @Override
            void sendEvent(CameraEvent event) {
                super.sendEvent(event);
                if (event instanceof CameraStateChangeEvent) {
                    GUIDirectLayer.this.cscel.fireEvent((CameraStateChangeEvent)event);
                } else {
                    GUIDirectLayer.this.cell.fireEvent(event);
                }
            }
        });
    }

    @Override
    public void execute(CameraCommand cmd) {
        this.bridge.execute(cmd);
    }

    @Override
    public void execute(CCSCommand command) {
        this.bridge.execute(command);
    }

    @Override
    public boolean supportsCCSCommands() {
        return true;
    }

    @Override
    public void addEventListener(EventListener<CameraEvent> cel) {
        this.cell.addEventListener(cel);
    }

    @Override
    public void removeEventListener(EventListener<CameraEvent> cel) {
        this.cell.removeEventListener(cel);
    }

    @Override
    public void addStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
        this.cscel.addEventListener(cscl);
    }

    @Override
    public void removeStateChangeListener(EventListener<CameraStateChangeEvent> cscl) {
        this.cscel.removeEventListener(cscl);
    }
}

