/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndShutterCloseEvent;
import org.lsst.sal.camera.event.EndShutterOpenEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartShutterCloseEvent;
import org.lsst.sal.camera.event.StartShutterOpenEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class InitAndTakeImageTest
extends BridgeTest {
    @Test
    public void initAndTake() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(AppliedSettingsMatchStartEvent.class, AvailableFiltersEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        TimeUnit.SECONDS.sleep(2L);
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, true, true, true, "mockturtle001", "group"));
        TimeUnit.SECONDS.sleep(10L);
        tl.printFinalStates("InitAndTakeImageTest:initAndTake()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitAndTakeImageTest:initAndTake()");
        Assert.assertEquals((Object)CCSCommandStateEvent.CCSCommandState.BUSY, (Object)states.get(0));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.GETTING_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        this.executor.printEventList("InitAndTakeImageTest:initAndTake()");
        Assert.assertEquals((long)20L, (long)this.executor.getEventCount());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class, StartShutterOpenEvent.class, EndShutterOpenEvent.class, StartShutterCloseEvent.class, EndShutterCloseEvent.class, ShutterMotionProfileEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartIntegrationEvent.class, StartIntegrationEvent.class, ImageReadoutParametersEvent.class));
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartReadoutEvent.class, EndReadoutEvent.class, EndOfImageTelemetryEvent.class, StartReadoutEvent.class, EndReadoutEvent.class, EndOfImageTelemetryEvent.class));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        ImageName imageName1 = new ImageName(event1.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName1.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName1.getSource());
        Assert.assertEquals((Object)"mockturtle001", (Object)event1.getImageType());
        Assert.assertEquals((Object)"group", (Object)event1.getGroupId());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName2.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName2.getSource());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        Assert.assertEquals((Object)"mockturtle001", (Object)event2.getImageType());
        Assert.assertEquals((Object)"group", (Object)event2.getGroupId());
    }

    @Test
    public void initAndTakeEarly() throws InterruptedException {
        this.enabler.goToEnable(this.ocsBridge);
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new InitImageCommand(2.0));
        TimeUnit.MILLISECONDS.sleep(500L);
        this.ocsBridge.execute(new TakeImagesCommand(2, 15.0, true, true, true, true, "mockturtle002", "group2"));
        TimeUnit.SECONDS.sleep(10L);
        tl.printFinalStates("InitAndTakeImageTest:initAndTakeEarly()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{Rafts.RaftsState.NEEDS_CLEAR}));
        assert (tl.getFinalStates().hasState(new Enum[]{Shutter.ShutterState.CLOSED}));
        assert (tl.getFinalStates().hasState(new Enum[]{MCM.TakeImageReadinessState.NOT_READY}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("InitAndTakeImageTest:initAndTakeEarly()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        this.executor.printEventList("InitAndTakeImageTest:initAndTakeEarly()");
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterReadinessState.GETTING_READY, Shutter.ShutterReadinessState.READY, Shutter.ShutterReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{MCM.TakeImageReadinessState.GETTING_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY, MCM.TakeImageReadinessState.READY, MCM.TakeImageReadinessState.NOT_READY}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Rafts.RaftsState.CLEARING, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.INTEGRATING, Rafts.RaftsState.READING_OUT, Rafts.RaftsState.QUIESCENT, Rafts.RaftsState.NEEDS_CLEAR}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE, CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        Assert.assertTrue((boolean)fsh.containsInOrder(new Enum[]{Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED, Shutter.ShutterState.OPENING, Shutter.ShutterState.OPEN, Shutter.ShutterState.CLOSING, Shutter.ShutterState.CLOSED}));
        StartIntegrationEvent event1 = this.executor.getEventOfClass(StartIntegrationEvent.class, 0);
        ImageName imageName1 = new ImageName(event1.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName1.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName1.getSource());
        StartIntegrationEvent event2 = this.executor.getEventOfClass(StartIntegrationEvent.class, 1);
        ImageName imageName2 = new ImageName(event2.getImageName());
        Assert.assertEquals((Object)Controller.OCS, (Object)imageName2.getController());
        Assert.assertEquals((Object)Source.MainCamera, (Object)imageName2.getSource());
        Assert.assertEquals((Object)imageName1.getDate(), (Object)imageName2.getDate());
        Assert.assertEquals((long)(imageName1.getNumber() + 1), (long)imageName2.getNumber());
        Assert.assertEquals((long)20L, (long)this.executor.getEventCount());
    }
}

