/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSEventSender;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.event.HeartbeatEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class OCSCommandExecutor
implements OCSTelemetrySender,
OCSEventSender {
    private static final Logger LOG = Logger.getLogger(OCSCommandExecutor.class.getName());
    private static final String UNKNOWN_VERSION = "Unknown";
    private final OCSBridge bridge;

    OCSCommandExecutor(OCSBridge bridge) {
        this.bridge = bridge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void executeCommand(OCSExecutor command) {
        LOG.log(Level.INFO, "Received command: {0}", command);
        State<CCSCommandStateEvent.CCSCommandState> commandState = this.bridge.getCommandState();
        if (!commandState.isInState(CCSCommandStateEvent.CCSCommandState.IDLE)) {
            this.rejectCommand(command, "Command state not idle");
        } else {
            try {
                Duration timeout = command.testPreconditions();
                commandState.setState(CCSCommandStateEvent.CCSCommandState.BUSY);
                if (!timeout.isZero()) {
                    this.acknowledgeCommand(command, timeout);
                }
                command.execute();
                this.reportComplete(command);
            }
            catch (PreconditionsNotMet ex) {
                this.rejectCommand(command, ex.getMessage());
            }
            catch (Exception ex) {
                this.reportError(command, ex);
            }
            finally {
                commandState.setState(CCSCommandStateEvent.CCSCommandState.IDLE);
            }
        }
    }

    protected void rejectCommand(OCSExecutor command, String reason) {
        long rejectTime = System.nanoTime();
        LOG.log(Level.INFO, "Reject command: {0} because {1} in {2}ns", new Object[]{command, reason, rejectTime - command.startTime});
    }

    protected void acknowledgeCommand(OCSExecutor command, Duration timeout) {
        long ackTime = System.nanoTime();
        LOG.log(Level.INFO, "Acknowledge command: {0} timeout {1} in {2}ns", new Object[]{command, timeout, ackTime - command.startTime});
    }

    protected void reportError(OCSExecutor command, Exception ex) {
        LOG.log(Level.WARNING, "Command failed: " + command, ex);
    }

    protected void reportComplete(OCSExecutor command) {
        long completeTime = System.nanoTime();
        LOG.log(Level.INFO, "Command complete: {0} in {1}ns", new Object[]{command, completeTime - command.startTime});
    }

    @Override
    public void sendEvent(CameraEvent event) {
        Level level = event instanceof HeartbeatEvent ? Level.FINE : Level.INFO;
        LOG.log(level, "OCS Event -> {0}", event);
    }

    @Override
    public void sendTelemetry(CameraTelemetry telemetry) {
        LOG.log(Level.FINE, "OCS Telemetry -> {0}", telemetry);
    }

    String getSALVersion() {
        return UNKNOWN_VERSION;
    }

    String getXMLVersion() {
        return UNKNOWN_VERSION;
    }

    String getOSPLVersion() {
        return UNKNOWN_VERSION;
    }

    static class PreconditionsNotMet
    extends Exception {
        private static final long serialVersionUID = 2388630285363617708L;

        public PreconditionsNotMet(String reason) {
            super(reason);
        }
    }

    public static abstract class OCSExecutor {
        private final CameraCommand cmd;
        private final long startTime;

        OCSExecutor(CameraCommand command) {
            this.cmd = command;
            this.startTime = System.nanoTime();
        }

        abstract Duration testPreconditions() throws PreconditionsNotMet;

        abstract void execute() throws Exception;

        public CameraCommand getCommand() {
            return this.cmd;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public String toString() {
            return this.cmd.toString();
        }
    }
}

