/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.ConfigurationSender;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSEventSender;
import org.lsst.ccs.subsystem.ocsbridge.sim.ConfigConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

public class ConfigurationSenderTest {
    @Test
    public void auxTelConfigurationTest() throws IOException, ClassNotFoundException, InterruptedException {
        int level = 1;
        ArrayList<String> found = new ArrayList<String>();
        OCSEventSender ocs = t -> found.add(t.getClass().getSimpleName());
        ConfigurationSender sender = ConfigurationSender.create((OCSBridgeConfig.Device)OCSBridgeConfig.Device.AUXTEL, (OCSEventSender)ocs);
        Set<String> expectedEvents = Arrays.stream(sender.getConfigurationEvents().split(",")).collect(Collectors.toSet());
        Mapping mapping = Mapping.defaultMapping();
        HashMap<String, SALClassDescription> salClassDescriptions = new HashMap<String, SALClassDescription>();
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "ats-fp-status-dictionary.ser", "ats-fp");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "ats-daq-monitor-status-dictionary.ser", "ats-daq-monitor");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "ats-ih-status-dictionary.ser", "ats-ih");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "bonn-shutter-status-dictionary.ser", "bonn-shutter");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "ats-power-status-dictionary.ser", "ats-power");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "ATCamera", "ats-status-dictionary.ser", "ats");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "focal_plane", "ats-fp-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "daq_monitor", "ats-daq-monitor-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "image_handling", "ats-ih-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "bonn_shutter", "bonn-shutter-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "ats_power", "ats-power-config-info.ser");
    }

    @Test
    public void comCamConfigurationTest() throws IOException, ClassNotFoundException, InterruptedException {
        int level = 1;
        ArrayList<String> found = new ArrayList<String>();
        OCSEventSender ocs = t -> found.add(t.getClass().getSimpleName());
        ConfigurationSender sender = ConfigurationSender.create((OCSBridgeConfig.Device)OCSBridgeConfig.Device.COMCAM, (OCSEventSender)ocs);
        Set<String> expectedEvents = Arrays.stream(sender.getConfigurationEvents().split(",")).collect(Collectors.toSet());
        Mapping mapping = Mapping.defaultMapping();
        HashMap<String, SALClassDescription> salClassDescriptions = new HashMap<String, SALClassDescription>();
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-fp-status-dictionary.ser", "comcam-fp");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-daq-monitor-status-dictionary.ser", "comcam-daq-monitor");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-ih-status-dictionary.ser", "comcam-ih");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-bonn-shutter-status-dictionary.ser", "bonn-shutter");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-quadbox-status-dictionary.ser", "comcam-quadbox");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-vacuum-status-dictionary.ser", "comcam-vacuum");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-fcs-status-dictionary.ser", "comcam-fcs");
        this.addStatusDictionary(level, mapping, salClassDescriptions, "CCCamera", "comcam-rebpower-status-dictionary.ser", "comcam-rebpower");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "focal_plane", "comcam-fp-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "daq_monitor", "comcam-daq-monitor-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "image_handling", "comcam-ih-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "bonn_shutter", "comcam-bonn-shutter-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "quadbox", "comcam-quadbox-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "vacuum", "comcam-vacuum-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "rebpower", "comcam-rebpower-config-info.ser");
        this.checkResults(expectedEvents, sender, salClassDescriptions, found, "fcs", "comcam-fcs-config-info.ser");
    }

    private void checkResults(Set<String> expectedEvents, ConfigurationSender sender, Map<String, SALClassDescription> salClassDescriptions, ArrayList<String> found, String filter, String file) throws ClassNotFoundException, IOException {
        Set expected = expectedEvents.stream().filter(s -> s.startsWith(filter)).collect(Collectors.toSet());
        Set expectedClassNames = expected.stream().map(s -> SALClassDescriptionMaker.capitalize((String)s) + "Event").collect(Collectors.toSet());
        found.clear();
        sender.send(salClassDescriptions, ConfigConverterTest.readConfigData(file));
        for (String foundClass : found) {
            boolean removed = expectedClassNames.remove(foundClass);
            Assert.assertTrue((String)(foundClass + " not expected"), (boolean)removed);
        }
        Assert.assertTrue((String)("Not found " + expectedClassNames), (boolean)expectedClassNames.isEmpty());
        expectedEvents.removeAll(expected);
    }

    private void addStatusDictionary(int level, Mapping mapping, Map<String, SALClassDescription> salClassDescriptions, String camera, String file, String subsystem) throws ClassNotFoundException, IOException {
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary(file);
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), camera, subsystem, level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        salClassDescriptions.putAll(maker.getSALClassDescriptions());
    }

    @Test
    public void auxTelConfigurationClassListTest() {
        ConfigurationSender sender = ConfigurationSender.create((OCSBridgeConfig.Device)OCSBridgeConfig.Device.AUXTEL, null);
        String eventList = sender.getConfigurationEvents();
        System.out.println(eventList);
        String[] names = eventList.split(",");
        Assert.assertTrue((boolean)Arrays.asList(names).contains("daq_monitor_Store_StoreConfiguration"));
    }
}

