package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.location.LocationSet;

/**
 * Interface to be implemented by subsystems which can take images
 * @author tonyj
 */
public interface FocalPlaneInterface {

    void clear(int nClears) throws ExecutionException;

    void endIntegration(boolean readout, Duration exposure) throws ExecutionException;

    /**
     * Called when the MCM receives a start command.
     * @param configName
     * @throws java.util.concurrent.ExecutionException
     */
    void start(String configName) throws ExecutionException;

    void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) throws ExecutionException;

    void play(String playlist, boolean repeat) throws ExecutionException;

    void definePlaylist(String playlist, String folder, String... images) throws ExecutionException;

    void discardRows(int nRows) throws ExecutionException;
}
