package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

/**
 *
 * @author tonyj
 */
public class ComCamConfigurationSender extends ConfigurationSender {

    private final GenericConverter converter;
    private final Map<String, Class> classMap;

    ComCamConfigurationSender(OCSEventSender sender) {
        super(sender);

        Map<String, String> nameChange = new HashMap<>();

        List<String> subSystems = new ArrayList<>();
        subSystems.add("comcam-vacuum");
        subSystems.add("comcam-rebpower");
        subSystems.add("comcam-quadbox");
        subSystems.add("comcam-daq-monitor");
        subSystems.add("comcam-fp");
        subSystems.add("comcam-ih");
        subSystems.add("comcam-fcs");
        subSystems.add("bonn-shutter");

        classMap = new HashMap<>();

        classMap.put("CCCamera_logevent_comcam-fp_Ccd_HardwareId", org.lsst.sal.cccamera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Ccd_Limits", org.lsst.sal.cccamera.event.Focal_plane_Ccd_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Ccd_Rafts", org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-fp_ImageDatabaseService", org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-fp_ImageNameService", org.lsst.sal.camera.event.Focal_plane_ImageNameServiceConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_InstrumentConfig_Instrument", org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_PeriodicTasks_timers", org.lsst.sal.cccamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_HardwareId", org.lsst.sal.cccamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControl", org.lsst.sal.cccamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Raft_RaftTempControlStatus", org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_RebTotalPower_Limits", org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_HardwareId", org.lsst.sal.cccamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Limits", org.lsst.sal.cccamera.event.Focal_plane_Reb_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_Rafts", org.lsst.sal.camera.event.Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_RaftsLimits", org.lsst.sal.camera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_RaftsPower", org.lsst.sal.camera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Reb_timers", org.lsst.sal.cccamera.event.Focal_plane_Reb_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_Segment_Limits", org.lsst.sal.camera.event.Focal_plane_Segment_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_DAQ", org.lsst.sal.cccamera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_SequencerConfig_Sequencer", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fp_WebHooksConfig_Visualization", org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent.class);

        classMap.put("CCCamera_logevent_comcam-ih_ImageHandler_DAQ", org.lsst.sal.cccamera.event.Image_handling_ImageHandler_DAQConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_ImageHandler_FitsHandling", org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_PeriodicTasks_timers", org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-ih_Reb", org.lsst.sal.cccamera.event.Image_handling_RebConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-ih_Reb_FitsHandling", org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent.class);

        classMap.put("CCCamera_logevent_comcam-daq-monitor_PeriodicTasks_timers", org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Stats_Statistics", org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Store_Limits", org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-daq-monitor_Store_Store", org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent.class);

        classMap.put("CCCamera_logevent_bonn-shutter_Device_General", org.lsst.sal.cccamera.event.Bonn_shutter_Device_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_bonn-shutter_Device_Limits", org.lsst.sal.cccamera.event.Bonn_shutter_Device_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_bonn-shutter_General", org.lsst.sal.cccamera.event.Bonn_shutter_GeneralConfigurationEvent.class);
        classMap.put("CCCamera_logevent_bonn-shutter_PeriodicTasks_timers", org.lsst.sal.cccamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent.class);

        //classMap.put("CCCamera_logevent_comcam-rebpower_EmergencyResponseManager", org.lsst.sal.camera.event.Rebpower_EmergencyResponseManagerConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_PeriodicTasks_timers", org.lsst.sal.cccamera.event.Rebpower_PeriodicTasks_timersConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-rebpower_Reb", org.lsst.sal.cccamera.event.Rebpower_RebConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Reb_Limits", org.lsst.sal.cccamera.event.Rebpower_Reb_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_Limits", org.lsst.sal.camera.event.Rebpower_Rebps_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-rebpower_Rebps_Power", org.lsst.sal.cccamera.event.Rebpower_Rebps_PowerConfigurationEvent.class);

        classMap.put("CCCamera_logevent_comcam-vacuum_Cold1_Cryocon", org.lsst.sal.cccamera.event.Vacuum_Cold1_CryoconConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Cold1_Limits", org.lsst.sal.cccamera.event.Vacuum_Cold1_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Cold2_Cryocon", org.lsst.sal.cccamera.event.Vacuum_Cold2_CryoconConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Cold2_Limits", org.lsst.sal.cccamera.event.Vacuum_Cold2_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Cryo_Cryocon", org.lsst.sal.cccamera.event.Vacuum_Cryo_CryoconConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Cryo_Limits", org.lsst.sal.cccamera.event.Vacuum_Cryo_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_IonPumps_Cryo", org.lsst.sal.cccamera.event.Vacuum_IonPumps_CryoConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_IonPumps_Limits", org.lsst.sal.cccamera.event.Vacuum_IonPumps_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_PeriodicTasks_timers", org.lsst.sal.cccamera.event.Vacuum_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Rtds_Device", org.lsst.sal.cccamera.event.Vacuum_Rtds_DeviceConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Rtds_Limits", org.lsst.sal.cccamera.event.Vacuum_Rtds_LimitsConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-vacuum_Turbo", org.lsst.sal.cccamera.event.Vacuum_TurboConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_Turbo_Limits", org.lsst.sal.cccamera.event.Vacuum_Turbo_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_VQMonitor_Cryo", org.lsst.sal.cccamera.event.Vacuum_VQMonitor_CryoConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_VQMonitor_Limits", org.lsst.sal.cccamera.event.Vacuum_VQMonitor_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-vacuum_VacPluto_Device", org.lsst.sal.cccamera.event.Vacuum_VacPluto_DeviceConfigurationEvent.class);

        classMap.put("CCCamera_logevent_comcam-quadbox_BFR_Limits", org.lsst.sal.cccamera.event.Quadbox_BFR_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_BFR_Quadbox", org.lsst.sal.camera.event.Quadbox_BFR_QuadboxConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_24VC_Limits", org.lsst.sal.cccamera.event.Quadbox_PDU_24VC_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_24VC_Quadbox", org.lsst.sal.camera.event.Quadbox_PDU_24VC_QuadboxConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_24VD_Limits", org.lsst.sal.cccamera.event.Quadbox_PDU_24VD_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_24VD_Quadbox", org.lsst.sal.camera.event.Quadbox_PDU_24VD_QuadboxConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_48V_Limits", org.lsst.sal.cccamera.event.Quadbox_PDU_48V_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_48V_Quadbox", org.lsst.sal.camera.event.Quadbox_PDU_48V_QuadboxConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_5V_Limits", org.lsst.sal.cccamera.event.Quadbox_PDU_5V_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PDU_5V_Quadbox", org.lsst.sal.camera.event.Quadbox_PDU_5V_QuadboxConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_PeriodicTasks_timers", org.lsst.sal.camera.event.Quadbox_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-quadbox_REB_Bulk_PS_Quadbox", org.lsst.sal.camera.event.Quadbox_REB_Bulk_PS_QuadboxConfigurationEvent.class);

        //classMap.put("CCCamera_logevent_comcam-fcs_LinearEncoder", org.lsst.sal.cccamera.event.Fcs_LinearEncoderConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fcs_LinearEncoder_Limits", org.lsst.sal.cccamera.event.Fcs_LinearEncoder_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fcs_PeriodicTasks_timers", org.lsst.sal.cccamera.event.Fcs_PeriodicTasks_timersConfigurationEvent.class);
        //classMap.put("CCCamera_logevent_comcam-fcs_StepperMotor", org.lsst.sal.cccamera.event.Fcs_StepperMotorConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fcs_StepperMotor_Limits", org.lsst.sal.cccamera.event.Fcs_StepperMotor_LimitsConfigurationEvent.class);
        classMap.put("CCCamera_logevent_comcam-fcs_StepperMotor_Motor", org.lsst.sal.cccamera.event.Fcs_StepperMotor_MotorConfigurationEvent.class);

        Mapping mapping = Mapping.defaultMapping();
        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

    @Override
    String getConfigurationEvents() {
        return classMap.values().stream().map(c -> c.getSimpleName()).map(name -> name.replaceAll("Event$", "")).map(name -> SALClassDescriptionMaker.uncapitalize(name)).collect(Collectors.joining(","));
    }

}
