/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.subsystem.imagehandling.data.HeaderServiceEnabled;
import org.lsst.ccs.subsystem.imagehandling.data.ImageHeaderData;
import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.sal.SALEvent;
import org.lsst.sal.atheader.event.LargeFileObjectAvailableEvent;
import org.lsst.sal.atheader.states.SummaryStateEvent;
import org.lsst.sal.ccheader.states.SummaryStateEvent;

public class HeaderServiceEventHandler
implements EventListener<SALEvent> {
    private static final Logger LOG = Logger.getLogger(HeaderServiceEventHandler.class.getName());
    private final ObjectMapper mapper;
    private final TypeReference<Map<String, List<ImageHeaderData.Header>>> yamlType = new TypeReference<Map<String, List<ImageHeaderData.Header>>>(){};
    private final Subsystem subsystem;

    public HeaderServiceEventHandler(Subsystem subsystem) {
        this.subsystem = subsystem;
        this.mapper = new ObjectMapper((JsonFactory)new YAMLFactory());
        this.mapper.findAndRegisterModules();
        this.mapper.addMixIn(ImageHeaderData.Header.class, HeaderMixIn.class);
    }

    @Override
    public void eventFired(SALEvent event) {
        if (event instanceof LargeFileObjectAvailableEvent) {
            LargeFileObjectAvailableEvent lfoe = (LargeFileObjectAvailableEvent)event;
            String url = lfoe.getUrl();
            this.handleEvent(url);
        } else if (event instanceof org.lsst.sal.ccheader.event.LargeFileObjectAvailableEvent) {
            org.lsst.sal.ccheader.event.LargeFileObjectAvailableEvent lfoe = (org.lsst.sal.ccheader.event.LargeFileObjectAvailableEvent)event;
            String url = lfoe.getUrl();
            this.handleEvent(url);
        } else if (event instanceof SummaryStateEvent) {
            SummaryStateEvent sse = (SummaryStateEvent)event;
            LOG.log(Level.INFO, "Header service state changed {0}", sse);
            HeaderServiceEnabled hse = new HeaderServiceEnabled(sse.getSubstate() == SummaryStateEvent.SummaryState.ENABLED);
            KeyValueData kvd = new KeyValueData("headerServiceEnabled", (Serializable)hse);
            this.subsystem.publishSubsystemDataOnStatusBus(kvd);
        } else if (event instanceof org.lsst.sal.ccheader.states.SummaryStateEvent) {
            org.lsst.sal.ccheader.states.SummaryStateEvent sse = (org.lsst.sal.ccheader.states.SummaryStateEvent)event;
            LOG.log(Level.INFO, "Header service state changed {0}", sse);
            HeaderServiceEnabled hse = new HeaderServiceEnabled(sse.getSubstate() == SummaryStateEvent.SummaryState.ENABLED);
            KeyValueData kvd = new KeyValueData("headerServiceEnabled", (Serializable)hse);
            this.subsystem.publishSubsystemDataOnStatusBus(kvd);
        }
    }

    void handleEvent(String url) {
        try {
            LOG.log(Level.INFO, "Header service got {0}", url);
            Map header = (Map)this.mapper.readValue(new URL(url), this.yamlType);
            this.sendPrimaryHeaderViaCCS((List)header.get("PRIMARY"));
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, "Unexpected exception handling header service URL", ex);
        }
    }

    void sendPrimaryHeaderViaCCS(List<ImageHeaderData.Header> data) {
        KeyValueData kvd = new KeyValueData("imageHeaderData", (Serializable)new ImageHeaderData(data));
        this.subsystem.publishSubsystemDataOnStatusBus(kvd);
        LOG.log(Level.FINE, "Sent {0}", kvd);
    }

    public static abstract class HeaderMixIn {
        @JsonCreator
        public HeaderMixIn(@JsonProperty(value="keyword") String keyword, @JsonProperty(value="value") String value, @JsonProperty(value="comment") String comment) {
        }
    }
}

