/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.sal.atcamera.telemetry.Bonn_shutter_DeviceTelemetry;
import org.lsst.sal.atcamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;

public class AuxTelTelemetrySender
extends TelemetrySender {
    private final GenericConverter converter;

    public AuxTelTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        HashMap<String, String> nameChange = new HashMap<String, String>();
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        subSystems.add("ats-daq-monitor");
        subSystems.add("ats");
        subSystems.add("ats-power");
        subSystems.add("bonn-shutter");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("ATCamera_ats-fp_Ccd", Focal_plane_CcdTelemetry.class);
        classMap.put("ATCamera_ats-fp_Reb", Focal_plane_RebTelemetry.class);
        classMap.put("ATCamera_ats-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("ATCamera_ats-fp_Segment", Focal_plane_SegmentTelemetry.class);
        classMap.put("ATCamera_ats-daq-monitor_Store", Daq_monitor_StoreTelemetry.class);
        classMap.put("ATCamera_ats", VacuumTelemetry.class);
        classMap.put("ATCamera_ats-power", PowerTelemetry.class);
        classMap.put("ATCamera_bonn-shutter_Device", Bonn_shutter_DeviceTelemetry.class);
        Mapping mapping = Mapping.defaultMapping();
        this.converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    protected CameraTelemetry applyAfterBurner(CameraTelemetry t) {
        Focal_plane_CcdTelemetry fct;
        String location;
        if (t instanceof Focal_plane_CcdTelemetry && "R00SW".equals(location = (fct = (Focal_plane_CcdTelemetry)t).getLocation())) {
            return new Focal_plane_CcdTelemetry(fct.getGDV(), "R00S00", fct.getODI(), fct.getODV(), fct.getOGV(), fct.getRDV(), fct.getTemp());
        }
        return t;
    }

    @Override
    GenericConverter getConverter() {
        return this.converter;
    }
}

