/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.GUILayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.sal.SALEnum;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.PlayCommand;
import org.lsst.sal.camera.command.PlaylistCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AvailableFiltersEvent;

public final class ToyOCSGUI
extends JFrame {
    private static final long serialVersionUID = -7536384356408611374L;
    private GUILayer guiInterface;
    private Map<String, JComboBox> statusMap = new HashMap<String, JComboBox>();
    private JButton clearButton;
    private JButton clearFaultButton;
    private JPanel commandPanel1;
    private JPanel commandPanel2;
    private JTextField daqFolderTextField;
    private JSpinner deltaTSpinner;
    private JButton disableButton;
    private JButton disableCalibrationButton;
    private JButton discardRowsButton;
    private JSpinner discardRowsSpinner;
    private JButton enableButton;
    private JButton enableCalibrationButton;
    private JButton endImageButton;
    private JButton enterControlButton;
    private JButton exitButton;
    private JSpinner exposureSpinner;
    private JComboBox filterComboBox;
    private JTextField imagesTextField;
    private JButton initGuidersButton;
    private JButton initImageButton;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JTextField keyValueTextField;
    private JTextField keyValueTextField1;
    private JTextArea logTextArea;
    private JSpinner nClearSpinner;
    private JSpinner nImagesSpinner;
    private JTextField obsNoteTextField;
    private JTextField obsNoteTextField1;
    private JCheckBox openShutterCheckBox;
    private JCheckBox openShutterCheckBox1;
    private JButton playButton;
    private JButton playlistButton;
    private JTextField playlistTextField1;
    private JTextField playlistTextField2;
    private JCheckBox repeatCheckBox;
    private JButton revokeAvailableButton;
    private JLabel roiLabel;
    private JTextField roiSpecTextField;
    private JTextField sensorTextField1;
    private JTextField sensorsTextField;
    private JButton setAvailableButton;
    private JButton setFilterButton;
    private JButton simulateFault;
    private JButton standbyButton;
    private JButton startButton;
    private JButton startImageButton;
    private JTextField startTextField;
    private JPanel statusPanel;
    private JButton takeImagesButton;
    private JSpinner timeoutSpinner;

    ToyOCSGUI(GUILayer guiLayer, OCSBridgeConfig.Device device) {
        this.guiInterface = guiLayer;
        this.initializeFontSize();
        this.initComponents();
        if (!guiLayer.supportsCCSCommands()) {
            this.remove(this.commandPanel2);
        }
        if (device == OCSBridgeConfig.Device.AUXTEL) {
            this.commandPanel1.remove(this.setFilterButton);
            this.commandPanel1.remove(this.filterComboBox);
            this.commandPanel1.remove(this.initGuidersButton);
            this.commandPanel1.remove(this.roiSpecTextField);
            this.commandPanel1.remove(this.roiLabel);
        }
        this.setTitle("OCS GUI for " + (Object)((Object)device));
        guiLayer.addStateChangeListener(csce -> {
            SALEnum substate = csce.getSubstate();
            Enum aEnum = substate.getEnum();
            SwingUtilities.invokeLater(() -> {
                JComboBox combo = this.statusMap.get(aEnum.getClass().getSimpleName());
                if (combo == null) {
                    combo = this.createStateComboBox(aEnum);
                    this.statusPanel.revalidate();
                }
                combo.setSelectedItem(aEnum);
            });
        });
        DefaultComboBoxModel<String> availableFilters = new DefaultComboBoxModel<String>(new String[]{"NONE"});
        this.filterComboBox.setModel(availableFilters);
        guiLayer.addEventListener(event -> {
            if (event instanceof AvailableFiltersEvent) {
                String filters = ((AvailableFiltersEvent)event).getFilterNames();
                SwingUtilities.invokeLater(() -> {
                    availableFilters.removeAllElements();
                    for (String filter : filters.split(":")) {
                        availableFilters.addElement(filter);
                    }
                });
            }
        });
        Logger logger = Logger.getLogger(OCSBridge.class.getName()).getParent();
        TextAreaHandler handler = new TextAreaHandler();
        handler.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                return String.format("[%tc] %s\n", record.getMillis(), this.formatMessage(record));
            }
        });
        logger.addHandler(handler);
    }

    private void initializeFontSize() {
        String fontSizeParam = System.getProperty("ocs-gui.fontSize");
        if (fontSizeParam != null) {
            float multiplier = (float)Integer.parseInt(fontSizeParam) / 100.0f;
            UIDefaults defaults = UIManager.getDefaults();
            int i = 0;
            Enumeration e = defaults.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object value = defaults.get(key);
                if (value instanceof Font) {
                    Font font = (Font)value;
                    int newSize = Math.round((float)font.getSize() * multiplier);
                    if (value instanceof FontUIResource) {
                        defaults.put(key, new FontUIResource(font.getName(), font.getStyle(), newSize));
                    } else {
                        defaults.put(key, new Font(font.getName(), font.getStyle(), newSize));
                    }
                }
                ++i;
            }
        }
    }

    private JComboBox createStateComboBox(Enum state) {
        String name = state.getClass().getSimpleName();
        Box box = Box.createHorizontalBox();
        box.add(new JLabel(name));
        box.add(Box.createHorizontalStrut(10));
        JComboBox combo = new JComboBox(state.getClass().getEnumConstants());
        combo.setEditable(false);
        combo.setSelectedItem(state);
        this.setReadonly(combo);
        box.add(combo);
        box.add(Box.createHorizontalGlue());
        this.statusPanel.add(box);
        this.statusMap.put(name, combo);
        return combo;
    }

    private void setReadonly(JComboBox combo) {
        KeyListener[] keyListeners;
        MouseListener[] mouseListeners;
        Component editorComponent = combo.getEditor().getEditorComponent();
        if (editorComponent instanceof JTextField) {
            ((JTextField)editorComponent).setEditable(false);
        }
        for (Component childComponent : combo.getComponents()) {
            MouseListener[] listeners;
            if (!(childComponent instanceof AbstractButton)) continue;
            childComponent.setEnabled(false);
            for (MouseListener listener : listeners = (MouseListener[])childComponent.getListeners(MouseListener.class)) {
                childComponent.removeMouseListener(listener);
            }
        }
        for (MouseListener listener : mouseListeners = (MouseListener[])combo.getListeners(MouseListener.class)) {
            combo.removeMouseListener(listener);
        }
        for (KeyListener keyListener : keyListeners = (KeyListener[])combo.getListeners(KeyListener.class)) {
            combo.removeKeyListener(keyListener);
        }
        combo.setFocusable(false);
    }

    private void initComponents() {
        this.statusPanel = new JPanel();
        this.commandPanel2 = new JPanel();
        this.setAvailableButton = new JButton();
        this.revokeAvailableButton = new JButton();
        this.simulateFault = new JButton();
        this.clearFaultButton = new JButton();
        JPanel commandPanel = new JPanel();
        this.enterControlButton = new JButton();
        this.exitButton = new JButton();
        this.startButton = new JButton();
        this.standbyButton = new JButton();
        this.enableButton = new JButton();
        this.disableButton = new JButton();
        this.startTextField = new JTextField();
        this.commandPanel1 = new JPanel();
        this.initImageButton = new JButton();
        JLabel jLabel4 = new JLabel();
        this.deltaTSpinner = new JSpinner();
        this.takeImagesButton = new JButton();
        JLabel jLabel5 = new JLabel();
        this.nImagesSpinner = new JSpinner();
        JLabel jLabel6 = new JLabel();
        this.exposureSpinner = new JSpinner();
        this.openShutterCheckBox = new JCheckBox();
        this.setFilterButton = new JButton();
        this.filterComboBox = new JComboBox();
        this.sensorsTextField = new JTextField();
        this.initGuidersButton = new JButton();
        this.roiSpecTextField = new JTextField();
        this.roiLabel = new JLabel();
        this.enableCalibrationButton = new JButton();
        this.disableCalibrationButton = new JButton();
        this.keyValueTextField = new JTextField();
        JLabel jLabel1 = new JLabel();
        JLabel jLabel8 = new JLabel();
        this.obsNoteTextField = new JTextField();
        this.jPanel1 = new JPanel();
        this.clearButton = new JButton();
        this.nClearSpinner = new JSpinner();
        this.jLabel2 = new JLabel();
        this.startImageButton = new JButton();
        this.openShutterCheckBox1 = new JCheckBox();
        this.jLabel7 = new JLabel();
        this.timeoutSpinner = new JSpinner();
        this.endImageButton = new JButton();
        this.discardRowsButton = new JButton();
        this.jLabel3 = new JLabel();
        this.discardRowsSpinner = new JSpinner();
        this.sensorTextField1 = new JTextField();
        this.keyValueTextField1 = new JTextField();
        JLabel jLabel9 = new JLabel();
        JLabel jLabel10 = new JLabel();
        this.obsNoteTextField1 = new JTextField();
        this.jPanel2 = new JPanel();
        this.playButton = new JButton();
        this.jLabel11 = new JLabel();
        this.playlistButton = new JButton();
        this.playlistTextField2 = new JTextField();
        this.daqFolderTextField = new JTextField();
        JLabel jLabel14 = new JLabel();
        JLabel jLabel15 = new JLabel();
        this.imagesTextField = new JTextField();
        this.playlistTextField1 = new JTextField();
        this.repeatCheckBox = new JCheckBox();
        JLabel jLabel13 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.logTextArea = new JTextArea();
        this.setDefaultCloseOperation(3);
        this.statusPanel.setBorder(BorderFactory.createTitledBorder("Status"));
        this.statusPanel.setLayout(new BoxLayout(this.statusPanel, 3));
        this.commandPanel2.setBorder(BorderFactory.createTitledBorder("CCS Commands"));
        this.setAvailableButton.setText("setAvailable");
        this.setAvailableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.setAvailableButtonActionPerformed(evt);
            }
        });
        this.revokeAvailableButton.setText("revokeAvailable");
        this.revokeAvailableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.revokeAvailableButtonActionPerformed(evt);
            }
        });
        this.simulateFault.setText("simulateFault");
        this.simulateFault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.simulateFaultActionPerformed(evt);
            }
        });
        this.clearFaultButton.setText("clearFault");
        this.clearFaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.clearFaultButtonActionPerformed(evt);
            }
        });
        GroupLayout commandPanel2Layout = new GroupLayout(this.commandPanel2);
        this.commandPanel2.setLayout(commandPanel2Layout);
        commandPanel2Layout.setHorizontalGroup(commandPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanel2Layout.createSequentialGroup().addComponent(this.setAvailableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.revokeAvailableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.simulateFault).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearFaultButton).addGap(0, 0, Short.MAX_VALUE)));
        commandPanel2Layout.setVerticalGroup(commandPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanel2Layout.createSequentialGroup().addGroup(commandPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setAvailableButton).addComponent(this.revokeAvailableButton).addComponent(this.simulateFault).addComponent(this.clearFaultButton)).addContainerGap(-1, Short.MAX_VALUE)));
        commandPanel.setBorder(BorderFactory.createTitledBorder("OCS Lifecycle Commands"));
        this.enterControlButton.setText("enterControl");
        this.enterControlButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.enterControlButtonActionPerformed(evt);
            }
        });
        this.exitButton.setText("exitControl");
        this.exitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.exitButtonActionPerformed(evt);
            }
        });
        this.startButton.setText("start");
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.startButtonActionPerformed(evt);
            }
        });
        this.standbyButton.setText("standby");
        this.standbyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.standbyButtonActionPerformed(evt);
            }
        });
        this.enableButton.setText("enable");
        this.enableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.enableButtonActionPerformed(evt);
            }
        });
        this.disableButton.setText("disable");
        this.disableButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.disableButtonActionPerformed(evt);
            }
        });
        this.startTextField.setColumns(20);
        this.startTextField.setText("Normal");
        this.startTextField.setToolTipText("Configuration name");
        GroupLayout commandPanelLayout = new GroupLayout(commandPanel);
        commandPanel.setLayout(commandPanelLayout);
        commandPanelLayout.setHorizontalGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanelLayout.createSequentialGroup().addGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanelLayout.createSequentialGroup().addComponent(this.enterControlButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exitButton)).addGroup(commandPanelLayout.createSequentialGroup().addComponent(this.startButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.standbyButton)).addGroup(commandPanelLayout.createSequentialGroup().addComponent(this.enableButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableButton))).addGap(0, 0, Short.MAX_VALUE)));
        commandPanelLayout.setVerticalGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanelLayout.createSequentialGroup().addGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enterControlButton).addComponent(this.exitButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startButton).addComponent(this.startTextField, -2, -1, -2).addComponent(this.standbyButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableButton).addComponent(this.disableButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.commandPanel1.setBorder(BorderFactory.createTitledBorder("OCS Camera Commands"));
        this.initImageButton.setText("initImage");
        this.initImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.initImageButtonActionPerformed(evt);
            }
        });
        jLabel4.setLabelFor(this.deltaTSpinner);
        jLabel4.setText("deltaT");
        this.deltaTSpinner.setModel(new SpinnerNumberModel(Float.valueOf(1.0f), Float.valueOf(0.0f), Float.valueOf(15.0f), Float.valueOf(0.1f)));
        this.takeImagesButton.setText("takeImages");
        this.takeImagesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.takeImagesButtonActionPerformed(evt);
            }
        });
        jLabel5.setLabelFor(this.nImagesSpinner);
        jLabel5.setText("nImages");
        this.nImagesSpinner.setModel(new SpinnerNumberModel(2, 0, 20, 1));
        jLabel6.setLabelFor(this.exposureSpinner);
        jLabel6.setText("exposure");
        this.exposureSpinner.setModel(new SpinnerNumberModel(Float.valueOf(15.0f), Float.valueOf(0.0f), Float.valueOf(30.0f), Float.valueOf(1.0f)));
        this.openShutterCheckBox.setSelected(true);
        this.openShutterCheckBox.setText("openShutter");
        this.openShutterCheckBox.setHorizontalTextPosition(10);
        this.setFilterButton.setText("setFilter");
        this.setFilterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.setFilterButtonActionPerformed(evt);
            }
        });
        this.filterComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.sensorsTextField.setColumns(15);
        this.sensorsTextField.setToolTipText("Sensors");
        this.initGuidersButton.setText("initGuiders");
        this.initGuidersButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.initGuidersButtonActionPerformed(evt);
            }
        });
        this.roiSpecTextField.setColumns(20);
        this.roiSpecTextField.setToolTipText("ROI Specification");
        this.roiLabel.setText("roiSpec");
        this.enableCalibrationButton.setText("enableCalibration");
        this.enableCalibrationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.enableCalibrationButtonActionPerformed(evt);
            }
        });
        this.disableCalibrationButton.setText("disableCalibration");
        this.disableCalibrationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.disableCalibrationButtonActionPerformed(evt);
            }
        });
        this.keyValueTextField.setColumns(15);
        this.keyValueTextField.setText("imageType: bias, groupId: g");
        this.keyValueTextField.setToolTipText("KeyValueMap");
        jLabel1.setText("Sensors");
        jLabel8.setText("keyValues");
        this.obsNoteTextField.setColumns(15);
        this.obsNoteTextField.setText("Annotation");
        this.obsNoteTextField.setToolTipText("Obs Note");
        GroupLayout commandPanel1Layout = new GroupLayout(this.commandPanel1);
        this.commandPanel1.setLayout(commandPanel1Layout);
        commandPanel1Layout.setHorizontalGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanel1Layout.createSequentialGroup().addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanel1Layout.createSequentialGroup().addComponent(this.initImageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deltaTSpinner, -2, -1, -2)).addGroup(commandPanel1Layout.createSequentialGroup().addComponent(this.takeImagesButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nImagesSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exposureSpinner, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openShutterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sensorsTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel8).addGap(3, 3, 3).addComponent(this.keyValueTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.obsNoteTextField, -2, -1, -2)).addGroup(commandPanel1Layout.createSequentialGroup().addComponent(this.setFilterButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterComboBox, -2, -1, -2)).addGroup(commandPanel1Layout.createSequentialGroup().addComponent(this.initGuidersButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.roiLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.roiSpecTextField, -2, -1, -2)).addGroup(commandPanel1Layout.createSequentialGroup().addComponent(this.enableCalibrationButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.disableCalibrationButton))).addGap(0, 0, Short.MAX_VALUE)));
        commandPanel1Layout.setVerticalGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(commandPanel1Layout.createSequentialGroup().addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initImageButton).addComponent(jLabel4).addComponent(this.deltaTSpinner, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.takeImagesButton).addComponent(jLabel5).addComponent(this.nImagesSpinner, -2, -1, -2).addComponent(jLabel6).addComponent(this.exposureSpinner, -2, -1, -2).addComponent(this.openShutterCheckBox).addComponent(this.sensorsTextField, -2, -1, -2).addComponent(this.keyValueTextField, -2, -1, -2).addComponent(jLabel1).addComponent(jLabel8).addComponent(this.obsNoteTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.setFilterButton).addComponent(this.filterComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.initGuidersButton).addComponent(this.roiSpecTextField, -2, -1, -2).addComponent(this.roiLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(commandPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.enableCalibrationButton).addComponent(this.disableCalibrationButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("OCS Camera Calibration Commands"));
        this.clearButton.setText("clear");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.clearButtonActionPerformed(evt);
            }
        });
        this.nClearSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.jLabel2.setText("n");
        this.startImageButton.setText("startImage");
        this.startImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.startImageButtonActionPerformed(evt);
            }
        });
        this.openShutterCheckBox1.setSelected(true);
        this.openShutterCheckBox1.setText("openShutter");
        this.openShutterCheckBox1.setHorizontalTextPosition(10);
        this.jLabel7.setText("timeout");
        this.timeoutSpinner.setModel(new SpinnerNumberModel(Float.valueOf(15.0f), Float.valueOf(0.0f), Float.valueOf(30.0f), Float.valueOf(1.0f)));
        this.endImageButton.setText("endImage");
        this.endImageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.endImageButtonActionPerformed(evt);
            }
        });
        this.discardRowsButton.setText("discardRows");
        this.discardRowsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.discardRowsButtonActionPerformed(evt);
            }
        });
        this.jLabel3.setText("rows");
        this.discardRowsSpinner.setModel(new SpinnerNumberModel(1, 1, 1000, 1));
        this.sensorTextField1.setColumns(15);
        this.sensorTextField1.setToolTipText("Sensor locations");
        this.keyValueTextField1.setColumns(15);
        this.keyValueTextField1.setText("imageType: bias, groupId: g");
        this.keyValueTextField1.setToolTipText("GroupdId");
        jLabel9.setText("Sensors");
        jLabel10.setText("keyValues");
        this.obsNoteTextField1.setColumns(15);
        this.obsNoteTextField1.setText("Annotation");
        this.obsNoteTextField1.setToolTipText("Obs Note");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nClearSpinner, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.startImageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.openShutterCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sensorTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keyValueTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.obsNoteTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timeoutSpinner, -2, -1, -2)).addComponent(this.endImageButton).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.discardRowsButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.discardRowsSpinner, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.clearButton).addComponent(this.nClearSpinner, -2, -1, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.startImageButton).addComponent(this.openShutterCheckBox1).addComponent(this.timeoutSpinner, -2, -1, -2).addComponent(this.jLabel7).addComponent(jLabel9).addComponent(this.sensorTextField1, -2, -1, -2).addComponent(jLabel10).addComponent(this.keyValueTextField1, -2, -1, -2).addComponent(this.obsNoteTextField1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.endImageButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.discardRowsButton).addComponent(this.jLabel3).addComponent(this.discardRowsSpinner, -2, -1, -2)).addGap(0, 0, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Playlist Commands"));
        this.playButton.setText("play");
        this.playButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.playButtonActionPerformed(evt);
            }
        });
        this.jLabel11.setText("playlist");
        this.playlistButton.setText("playList");
        this.playlistButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ToyOCSGUI.this.playlistButtonActionPerformed(evt);
            }
        });
        this.playlistTextField2.setColumns(15);
        this.playlistTextField2.setToolTipText("Sensor locations");
        this.daqFolderTextField.setColumns(8);
        this.daqFolderTextField.setText("emu");
        this.daqFolderTextField.setToolTipText("DAQ Folder");
        jLabel14.setText("playlist");
        jLabel15.setText("folder");
        this.imagesTextField.setColumns(15);
        this.imagesTextField.setToolTipText("Image List");
        this.playlistTextField1.setColumns(15);
        this.repeatCheckBox.setSelected(true);
        this.repeatCheckBox.setText("repeat");
        this.repeatCheckBox.setHorizontalTextPosition(10);
        jLabel13.setText("images");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.playButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playlistTextField1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.repeatCheckBox).addGap(0, 0, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.playlistButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.playlistTextField2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.daqFolderTextField, -2, -1, -2).addGap(6, 6, 6).addComponent(jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.imagesTextField))).addGap(12, 12, 12)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playButton).addComponent(this.jLabel11)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playlistTextField1, -2, -1, -2).addComponent(this.repeatCheckBox))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.playlistButton).addComponent(jLabel14).addComponent(this.playlistTextField2, -2, -1, -2).addComponent(jLabel15).addComponent(this.daqFolderTextField, -2, -1, -2).addComponent(this.imagesTextField, -2, -1, -2).addComponent(jLabel13)).addContainerGap(-1, Short.MAX_VALUE)));
        this.logTextArea.setEditable(false);
        this.logTextArea.setColumns(80);
        this.logTextArea.setRows(20);
        this.jScrollPane2.setViewportView(this.logTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusPanel, -1, -1, Short.MAX_VALUE).addComponent(commandPanel, -1, -1, Short.MAX_VALUE).addComponent(this.commandPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.commandPanel1, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel1, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 1064, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.statusPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(commandPanel, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.commandPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 391, Short.MAX_VALUE)));
        this.jPanel2.getAccessibleContext().setAccessibleName("Playlist commands");
        this.pack();
    }

    private void enterControlButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new EnterControlCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void exitButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new ExitControlCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        final String configuration = this.startTextField.getText();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new StartCommand(configuration));
                return null;
            }
        };
        sw.execute();
    }

    private void standbyButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new StandbyCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void enableButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new EnableCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void disableButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new DisableCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void setAvailableButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute(new CCSCommand.CCSSetAvailableCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void revokeAvailableButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute(new CCSCommand.CCSRevokeAvailableCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void simulateFaultActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute(new CCSCommand.CCSSimulateFaultCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void clearFaultButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute(new CCSCommand.CCSClearFaultCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        final int nClears = ((Number)this.nClearSpinner.getModel().getValue()).intValue();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new ClearCommand(nClears));
                return null;
            }
        };
        sw.execute();
    }

    private void startImageButtonActionPerformed(ActionEvent evt) {
        final boolean openShutter = this.openShutterCheckBox1.isSelected();
        final float timeout = ((Number)this.timeoutSpinner.getModel().getValue()).floatValue();
        final String sensors = this.sensorTextField1.getText();
        final String keyValueData = this.keyValueTextField1.getText();
        final String annotation = this.obsNoteTextField1.getText();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new StartImageCommand(openShutter, sensors, keyValueData, annotation, (double)timeout));
                return null;
            }
        };
        sw.execute();
    }

    private void endImageButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new EndImageCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void discardRowsButtonActionPerformed(ActionEvent evt) {
        final int nRows = ((Number)this.discardRowsSpinner.getModel().getValue()).intValue();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new DiscardRowsCommand(nRows));
                return null;
            }
        };
        sw.execute();
    }

    private void disableCalibrationButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new DisableCalibrationCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void enableCalibrationButtonActionPerformed(ActionEvent evt) {
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new EnableCalibrationCommand());
                return null;
            }
        };
        sw.execute();
    }

    private void initGuidersButtonActionPerformed(ActionEvent evt) {
        final String roiSpec = this.roiSpecTextField.getText();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new InitGuidersCommand(roiSpec));
                return null;
            }
        };
        sw.execute();
    }

    private void setFilterButtonActionPerformed(ActionEvent evt) {
        final String filter = this.filterComboBox.getSelectedItem().toString();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new SetFilterCommand(filter));
                return null;
            }
        };
        sw.execute();
    }

    private void takeImagesButtonActionPerformed(ActionEvent evt) {
        final int nImages = ((Number)this.nImagesSpinner.getModel().getValue()).intValue();
        final float exposure = ((Number)this.exposureSpinner.getModel().getValue()).floatValue();
        final boolean openShutter = this.openShutterCheckBox.isSelected();
        final String sensors = this.sensorsTextField.getText();
        final String keyValueData = this.keyValueTextField.getText();
        final String annotation = this.obsNoteTextField.getText();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new TakeImagesCommand(nImages, (double)exposure, openShutter, sensors, keyValueData, annotation));
                return null;
            }
        };
        sw.execute();
    }

    private void initImageButtonActionPerformed(ActionEvent evt) {
        final float deltaT = ((Number)this.deltaTSpinner.getModel().getValue()).floatValue();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new InitImageCommand((double)deltaT));
                return null;
            }
        };
        sw.execute();
    }

    private void playlistButtonActionPerformed(ActionEvent evt) {
        final String playlist = this.playlistTextField2.getText();
        final String folder = this.daqFolderTextField.getText();
        final String images = this.imagesTextField.getText();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new PlaylistCommand(playlist, folder, images));
                return null;
            }
        };
        sw.execute();
    }

    private void playButtonActionPerformed(ActionEvent evt) {
        final String playlist = this.playlistTextField1.getText();
        final boolean repeat = this.repeatCheckBox.isSelected();
        SwingWorker sw = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                ToyOCSGUI.this.guiInterface.execute((CameraCommand)new PlayCommand(playlist, repeat));
                return null;
            }
        };
        sw.execute();
    }

    private class TextAreaHandler
    extends StreamHandler {
        private TextAreaHandler() {
        }

        @Override
        public void publish(LogRecord record) {
            super.publish(record);
            this.flush();
            ToyOCSGUI.this.logTextArea.append(this.getFormatter().format(record));
        }
    }
}

