/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.ccs.subsystem.ocsbridge.xml.XMLMaker;

public class SALClassDescriptionMakerTest {
    @Test
    public void makeSALClassDescriptionFromAuxTelRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("ats-power-status-dictionary.ser", 0, "ATCamera", "ats-power");
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("ATCamera_ats-power"));
    }

    @Test
    public void makeSALClassDescriptionFromMainCameraRebPowerLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("rebpower-status-dictionary.ser", 0, "MTCamera", "rebpower");
        Assert.assertEquals((long)1L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("MTCamera_rebpower"));
        SALClassDescription classDescription = info.values().iterator().next();
        Assert.assertEquals((long)2L, (long)classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        List locationVariableNames = classDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).map(v -> v.getVariableName()).collect(Collectors.toList());
        Assert.assertTrue((boolean)locationVariableNames.contains("rebLocation"));
        Assert.assertTrue((boolean)locationVariableNames.contains("rebpsLocation"));
        List variables = classDescription.getVariables();
        Collections.sort(variables, (v1, v2) -> v1.getVariableName().compareTo(v2.getVariableName()));
        Assert.assertEquals((Object)classDescription.getVariables(), (Object)variables);
    }

    @Test
    public void makeSALClassDescriptionFromComCamFocalPlaneLevel1() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("comcam-fp-status-dictionary.ser", 1, "CCCamera", "comcam-fp");
        Assert.assertEquals((long)4L, (long)info.size());
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Reb"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Ccd"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_Segment"));
        Assert.assertTrue((boolean)info.keySet().contains("CCCamera_comcam-fp_RebTotalPower"));
        SALClassDescription ccdDescription = info.get("CCCamera_comcam-fp_Ccd");
        Assert.assertEquals((long)1L, (long)ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).count());
        SALClassDescription.SALVariable locationVariable = ccdDescription.getVariables().stream().filter(v -> v instanceof SALClassDescription.LocationVariable).findAny().get();
        Assert.assertEquals((Object)"location", (Object)locationVariable.getVariableName());
    }

    @Test
    public void makeSALClassDescriptionFromComcamDaqMonitorSettingsAppliedLevel0() throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Map<String, SALClassDescription> info = SALClassDescriptionMakerTest.makeSALClassDescription("comcam-daq-monitor-status-dictionary.ser", 0, "CCCamera", "daq-monitor", DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        System.out.println(info);
        Assert.assertEquals((long)6L, (long)info.size());
        Set categories = info.values().stream().map(desc -> desc.getCategory()).collect(Collectors.toSet());
        Assert.assertEquals((long)6L, (long)categories.size());
        Assert.assertTrue((boolean)categories.contains("Store"));
    }

    public static Map<String, SALClassDescription> makeSALClassDescription(String file, int level, String cscName, String componentName) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        return SALClassDescriptionMakerTest.makeSALClassDescription(file, level, cscName, componentName, "MONITORING", "trending");
    }

    public static Map<String, SALClassDescription> makeSALClassDescription(String file, int level, String cscName, String componentName, String attributeType, String resultType) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        Mapping mapping;
        Object readObject;
        Throwable throwable;
        try (InputStream in = GenericConverterTest.class.getResourceAsStream(file);){
            throwable = null;
            try (ObjectInputStream ois = new ObjectInputStream(in);){
                readObject = ois.readObject();
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        Assert.assertTrue((boolean)(readObject instanceof StatusDataProviderDictionary));
        StatusDataProviderDictionary info = (StatusDataProviderDictionary)readObject;
        throwable = null;
        try (InputStream in = XMLMaker.class.getResourceAsStream("pattern.map");){
            mapping = new Mapping(in);
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), cscName, componentName, level, mapping, attributeType, resultType);
        return maker.getSALClassDescriptions();
    }
}

