package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

/**
 *
 * @author tonyj
 */
public class AuxTelConfigurationSender extends ConfigurationSender {

    private final GenericConverter converter;
    private final HashMap<String, Class> classMap;

    AuxTelConfigurationSender(OCSEventSender sender) {
        super(sender);

        Map<String, String> nameChange = new HashMap<>();

        List<String> subSystems = new ArrayList<>();
        subSystems.add("ats-fp");
        subSystems.add("ats-ih");
        subSystems.add("ats-daq-monitor");
        subSystems.add("ats");
        subSystems.add("ats-power");
        subSystems.add("bonn-shutter");

        classMap = new HashMap<>();

        classMap.put("ATCamera_logevent_ats-fp_Ccd_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Ccd_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Ccd_Limits", org.lsst.sal.camera.event.Focal_plane_Ccd_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Ccd_Rafts", org.lsst.sal.camera.event.Focal_plane_Ccd_RaftsConfigurationEvent.class);
        //classMap.put("ATCamera_logevent_ats-fp_ImageDatabaseService", org.lsst.sal.camera.event.Focal_plane_ImageDatabaseServiceConfigurationEvent.class);
        //classMap.put("ATCamera_logevent_ats-fp_ImageNameService", org.lsst.sal.camera.event.Focal_plane_ImageNameServiceConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_InstrumentConfig_Instrument", org.lsst.sal.camera.event.Focal_plane_InstrumentConfig_InstrumentConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Focal_plane_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Raft_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControl", org.lsst.sal.atcamera.event.Focal_plane_Raft_RaftTempControlConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Raft_RaftTempControlStatus", org.lsst.sal.camera.event.Focal_plane_Raft_RaftTempControlStatusConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_RebTotalPower_Limits", org.lsst.sal.camera.event.Focal_plane_RebTotalPower_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_HardwareId", org.lsst.sal.atcamera.event.Focal_plane_Reb_HardwareIdConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Limits", org.lsst.sal.atcamera.event.Focal_plane_Reb_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_Rafts", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_RaftsLimits", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsLimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_RaftsPower", org.lsst.sal.atcamera.event.Focal_plane_Reb_RaftsPowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_Reb_timers", org.lsst.sal.atcamera.event.Focal_plane_Reb_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_DAQ", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_SequencerConfig_Sequencer", org.lsst.sal.camera.event.Focal_plane_SequencerConfig_SequencerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-fp_WebHooksConfig_Visualization", org.lsst.sal.camera.event.Focal_plane_WebHooksConfig_VisualizationConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-daq-monitor_PeriodicTasks_timers", org.lsst.sal.camera.event.Daq_monitor_PeriodicTasks_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Stats_Statistics", org.lsst.sal.camera.event.Daq_monitor_Stats_StatisticsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Limits", org.lsst.sal.camera.event.Daq_monitor_Store_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-daq-monitor_Store_Store", org.lsst.sal.camera.event.Daq_monitor_Store_StoreConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_DAQ", org.lsst.sal.atcamera.event.Image_handling_ImageHandler_DAQConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_ImageHandler_FitsHandling", org.lsst.sal.camera.event.Image_handling_ImageHandler_FitsHandlingConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_PeriodicTasks_timers", org.lsst.sal.camera.event.Image_handling_PeriodicTasks_timersConfigurationEvent.class);
        //classMap.put("ATCamera_logevent_ats-ih_Reb", org.lsst.sal.atcamera.event.Image_handling_RebConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-ih_Reb_FitsHandling", org.lsst.sal.camera.event.Image_handling_Reb_FitsHandlingConfigurationEvent.class);

        classMap.put("ATCamera_logevent_bonn-shutter_PeriodicTasks_timers", org.lsst.sal.atcamera.event.Bonn_shutter_PeriodicTasks_timersConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats-power_Analog_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Analog_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Analog_Power", org.lsst.sal.atcamera.event.Ats_power_Analog_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Analog_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Analog_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Aux_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_Power", org.lsst.sal.atcamera.event.Ats_power_Aux_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Aux_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Aux_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_I_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkHigh_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkHigh_V_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkHigh_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_I_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkLow_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClkLow_V_Limits", org.lsst.sal.atcamera.event.Ats_power_ClkLow_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClockHigh_Power", org.lsst.sal.atcamera.event.Ats_power_ClockHigh_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_ClockLow_Power", org.lsst.sal.atcamera.event.Ats_power_ClockLow_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_I_Limits", org.lsst.sal.atcamera.event.Ats_power_DPHI_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_Power", org.lsst.sal.atcamera.event.Ats_power_DPHI_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_DPHI_V_Limits", org.lsst.sal.atcamera.event.Ats_power_DPHI_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Digital_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_Power", org.lsst.sal.atcamera.event.Ats_power_Digital_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Digital_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Digital_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_I_Limits", org.lsst.sal.atcamera.event.Ats_power_Fan_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_Power", org.lsst.sal.atcamera.event.Ats_power_Fan_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Fan_V_Limits", org.lsst.sal.atcamera.event.Ats_power_Fan_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_I_Limits", org.lsst.sal.atcamera.event.Ats_power_HVBias_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_Power", org.lsst.sal.atcamera.event.Ats_power_HVBias_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_HVBias_V_Limits", org.lsst.sal.atcamera.event.Ats_power_HVBias_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg1_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg1_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg2_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg2_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Hameg3_Power", org.lsst.sal.atcamera.event.Ats_power_Hameg3_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Heartbeat_timers", org.lsst.sal.atcamera.event.Ats_power_Heartbeat_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Keithley_Power", org.lsst.sal.atcamera.event.Ats_power_Keithley_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Monitor-check_timers", org.lsst.sal.atcamera.event.Ats_power_Monitor_check_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Monitor-publish_timers", org.lsst.sal.atcamera.event.Ats_power_Monitor_publish_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Monitor-update_timers", org.lsst.sal.atcamera.event.Ats_power_Monitor_update_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_I_Limits", org.lsst.sal.atcamera.event.Ats_power_OD_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_Power", org.lsst.sal.atcamera.event.Ats_power_OD_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OD_V_Limits", org.lsst.sal.atcamera.event.Ats_power_OD_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_I_Limits", org.lsst.sal.atcamera.event.Ats_power_OTM_I_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_Power", org.lsst.sal.atcamera.event.Ats_power_OTM_PowerConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_OTM_V_Limits", org.lsst.sal.atcamera.event.Ats_power_OTM_V_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_Power-state_timers", org.lsst.sal.atcamera.event.Ats_power_Power_state_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats-power_RuntimeInfo_timers", org.lsst.sal.atcamera.event.Ats_power_RuntimeInfo_timersConfigurationEvent.class);
        //classMap.put("ATCamera_logevent_ats-power_Schedulers", org.lsst.sal.atcamera.event.Ats_power_SchedulersConfigurationEvent.class);

        classMap.put("ATCamera_logevent_ats_CryoCon_Device", org.lsst.sal.atcamera.event.Ats_CryoCon_DeviceConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Heartbeat_timers", org.lsst.sal.atcamera.event.Ats_Heartbeat_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Monitor-check_timers", org.lsst.sal.atcamera.event.Ats_Monitor_check_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Monitor-publish_timers", org.lsst.sal.atcamera.event.Ats_Monitor_publish_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Monitor-update_timers", org.lsst.sal.atcamera.event.Ats_Monitor_update_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_RuntimeInfo_timers", org.lsst.sal.atcamera.event.Ats_RuntimeInfo_timersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Schedulers", org.lsst.sal.atcamera.event.Ats_SchedulersConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCCDSetPoint_Limits", org.lsst.sal.atcamera.event.Ats_TempCCDSetPoint_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCCD_Limits", org.lsst.sal.atcamera.event.Ats_TempCCD_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempColdPlate_Limits", org.lsst.sal.atcamera.event.Ats_TempColdPlate_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_TempCryoHead_Limits", org.lsst.sal.atcamera.event.Ats_TempCryoHead_LimitsConfigurationEvent.class);
        classMap.put("ATCamera_logevent_ats_Vacuum_Limits", org.lsst.sal.atcamera.event.Ats_Vacuum_LimitsConfigurationEvent.class);

        Mapping mapping = Mapping.defaultMapping();
        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

    @Override
    String getConfigurationEvents() {
        return classMap.values().stream().map(c -> c.getSimpleName()).map(name -> name.replaceAll("Event$", "")).map(name -> SALClassDescriptionMaker.uncapitalize(name)).collect(Collectors.joining(","));
    }
}
