/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.services;

import org.lsst.ccs.command.Dictionary;
import org.lsst.ccs.command.DictionaryCommand;

public class AgentDictionaryCommand {
    private final String destination;
    private final DictionaryCommand command;
    private final Dictionary dictionary;
    private final String agentName;

    AgentDictionaryCommand(String destination, DictionaryCommand command, Dictionary dictionary) {
        this.destination = destination;
        this.command = command;
        this.dictionary = dictionary;
        this.agentName = destination.contains("/") ? destination.substring(0, destination.indexOf("/")) : destination;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getFullCommand() {
        return this.destination + "/" + this.command.getCommandName();
    }

    public DictionaryCommand getDictionaryCommand() {
        return this.command;
    }

    public Dictionary getDictionary() {
        return this.dictionary;
    }

    public String getAgentName() {
        return this.agentName;
    }

    public boolean isVisible() {
        return this.dictionary.isDictionaryCommandVisible(this.command);
    }
}

