package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/**
 *
 * @author farrukh
 */
public class ProcessedInfo {

    private final String salClassParameterName;
    private final String originalPathName;
    private final String patternReplacement;
    private final String matchedPattern;
    private final String associatedClassName;
    private final String salClassParameterType;
    private final String salClassParameterDescription;
    private final String salClassParameterUnits;
    private final String category;
    private List<String> originalPathArrayNames = new ArrayList<>();
    private String locationString;
    private List<String> locationsValueList = new ArrayList<>();
    private boolean isLocation;
    private boolean isArray;
    private int counts; // think about moving this to constructor
   
    
    ProcessedInfo(String originalPathName, String salClassParameterName, String patternReplacement, String matchedPattern, String associatedClassName, String salClassParameterType, String salClassParameterUnits, String salClassParameterDescription, String category) {
        this.originalPathArrayNames = new ArrayList<String>();
        this.salClassParameterName = salClassParameterName;
        this.originalPathName = originalPathName;
        this.patternReplacement = patternReplacement;
        this.matchedPattern = matchedPattern;
        this.associatedClassName = associatedClassName;
        this.salClassParameterType = this.cleanUpType(salClassParameterType);
        this.salClassParameterUnits = salClassParameterUnits;
        this.category = category;
        this.isArray = false;
        this.isLocation = false;
        if (salClassParameterDescription == null) {
            this.salClassParameterDescription = null;
        } else {
            // Some CCS descriptions contain \\, to indicate a header applying to all subsequent channels. For now we ignore it.
            int backSlashIndex = salClassParameterDescription.lastIndexOf('\\');
            this.salClassParameterDescription = backSlashIndex < 0 ? salClassParameterDescription : salClassParameterDescription.substring(backSlashIndex+1);
        }
    }

   
    public String getOriginalPathName() {
        return this.originalPathName;
    }

    public String getSALClassParameterName() {
       return this.salClassParameterName;
    }
    
    public String getPatternReplacement() {
       return this.patternReplacement;
    }
   
    public String getMatchedPattern() {
        return this.matchedPattern;
    }
    
    public String getAssociatedClassName() {         
       return this.associatedClassName;    
    }
    
    public String getSALClassParameterType() {
        return this.salClassParameterType;
    }

    public String getSALClassParameterDescription() {
        return this.salClassParameterDescription;
    }

    public String getSALClassParameterUnits() {
        return this.salClassParameterUnits;
    }

    public List<String> getOriginalPathsCorrespondingToArray(){        
        return this.originalPathArrayNames;
      }
    
    // location list is the only value that is stored here 
    public List<String> getLocationList(){
     return this.locationsValueList;
    }

    // once again the only value of a salclass parameter that is stored here 
    public String getLocationListSALFormat() {
    
        String concatString = "";
        
        if(!locationsValueList.isEmpty()){
        for(int i=0; i< locationsValueList.size(); i++){
        
            if(i<locationsValueList.size()-1){
             concatString += locationsValueList.get(i)+":";
            }
            else {
             concatString += locationsValueList.get(i);       
            }            
        }
        }
        // in case only one location appeared
        if(concatString.isEmpty()){concatString=this.locationString;}
        return concatString;
    }
    
    public String getLocationString(){
     return this.locationString;
    }
    
    void setOriginalPathsCorrespondingToArray(List<String> oldPathArray){
      this.originalPathArrayNames = oldPathArray;
    }
    
    public boolean isArray() {
     return isArray;
    }
    
    
    boolean isLocation() {
     return isLocation;
    }
    
     void setLocationList(List<String> locationsValueList){
      this.locationsValueList = locationsValueList;
    }
    void setIsArray(boolean isAnArray) {
     this.isArray = isAnArray;
    }
 
    void setLocationString(String locationString){
    
      this.locationString = locationString;
    }
    
    void setIsLocation(boolean isLocation){
        this.isLocation = isLocation;
    }
            
    // temporary set function
    void setCounts(int counts) {
        this.counts = counts;
    }

    public int getCounts() {
        return this.counts;
    }

    public String getCategory() {
    return category;
    }


 final String cleanUpType(String type) {
        String whatWeGot = type.replace("class", "");
        whatWeGot = whatWeGot.replace("Class", "");
        if (whatWeGot.toLowerCase().contains("java.lang.string")) {
            whatWeGot = "string";
        }
        whatWeGot = whatWeGot.trim();
        return whatWeGot;
    }
    
    @Override
    public String toString() {
        return " Variable name : " + getOriginalPathName() + " Parameter type : " + getSALClassParameterType() + "   Parameter Units : " + getSALClassParameterUnits() + " Parameter description : " + getSALClassParameterDescription()
                + " Category " + getCategory();
    }

    static void sortProcessedInfo(List<ProcessedInfo> processedInfo) {

        Collections.sort(processedInfo, (ProcessedInfo p1, ProcessedInfo p2) -> p1.getOriginalPathName().compareToIgnoreCase(p2.getOriginalPathName()));
    }

}
