/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SALClassDescription {
    private final String className;
    private final Map<String, SALVariable> variables = new TreeMap<String, SALVariable>();
    private final int level;
    private final String category;

    SALClassDescription(String className, int level, String category) {
        this.className = className;
        this.level = level;
        this.category = category;
    }

    SALVariable getVariable(String variableName) {
        return this.variables.get(variableName);
    }

    void add(SALVariable var) {
        this.variables.put(var.getVariableName(), var);
    }

    public String getClassName() {
        return this.className;
    }

    public List<SALVariable> getVariables() {
        return new ArrayList<SALVariable>(this.variables.values());
    }

    public int getLevel() {
        return this.level;
    }

    public String getCategory() {
        return this.category;
    }

    public String toString() {
        return "SALClassDescription{className=" + this.className + ", level=" + this.level + ", category=" + this.category + this.getVariables().stream().map(v -> v.toString()).collect(Collectors.joining("\n\t", "\n\t", "\n")) + '}';
    }

    void renameVariable(SALVariable variable, String newName) {
        String oldName = variable.getVariableName();
        this.variables.remove(oldName);
        variable.setName(newName);
        this.variables.put(newName, variable);
    }

    int getSharedLocationCount(SALVariable var) {
        SALVariable sv = this.variables.get(var.getVariableName());
        int count = 0;
        if (sv instanceof PatternMatchedSALVariable) {
            ArrayList<PatternMatchedSALVariable> pmsvList = new ArrayList<PatternMatchedSALVariable>();
            PatternMatchedSALVariable pmv = (PatternMatchedSALVariable)sv;
            String location = pmv.getLocationVariable().getVariableName();
            pmsvList.add(pmv);
            for (Map.Entry<String, SALVariable> entry : this.variables.entrySet()) {
                if (entry.getValue() instanceof PatternMatchedSALVariable && !pmv.equals(entry.getValue()) && location.equals(((PatternMatchedSALVariable)entry.getValue()).getLocationVariable().getVariableName())) {
                    pmsvList.add((PatternMatchedSALVariable)entry.getValue());
                }
                count = (Integer)Collections.max(pmsvList.stream().map(eachpmv -> eachpmv.getCount()).collect(Collectors.toList()));
            }
        } else {
            count = 1;
        }
        return count;
    }

    public static class BusVariable {
        private final String pathAndNameOnBuses;

        public BusVariable(String pathAndNameOnBuses) {
            this.pathAndNameOnBuses = pathAndNameOnBuses;
        }

        public String getPathAndNameOnBuses() {
            return this.pathAndNameOnBuses;
        }

        public String toString() {
            return "BusVariable{pathAndNameOnBuses=" + this.pathAndNameOnBuses + '}';
        }
    }

    public static class PatternMatchedSALVariable
    extends SALVariable {
        private final String patternName;
        private final String pattern;
        private final List<BusVariable> busVariables = new ArrayList<BusVariable>();
        private final LocationVariable locationVariable;

        public PatternMatchedSALVariable(String patternName, String pattern, LocationVariable location, String variableName, String type, String units, String description) {
            super(variableName, type, units, description);
            this.patternName = patternName;
            this.pattern = pattern;
            this.locationVariable = location;
        }

        void addBusVariable(BusVariable var) {
            this.busVariables.add(var);
        }

        public String getPatternName() {
            return this.patternName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public List<BusVariable> getBusVariables() {
            return this.busVariables;
        }

        public LocationVariable getLocationVariable() {
            return this.locationVariable;
        }

        @Override
        public int getCount() {
            return this.busVariables.size();
        }

        @Override
        public String toString() {
            return "PatternMatchedSALVariable{" + super.toString() + " patternName=" + this.patternName + ", pattern=" + this.pattern + ", locationVariable=" + this.locationVariable + this.busVariables.stream().map(v -> v.toString()).collect(Collectors.joining("\n\t\t", "\n\t\t", "\n\t")) + '}';
        }
    }

    public static class LocationVariable
    extends SALVariable {
        public LocationVariable(String variableName, String description) {
            super(variableName, "String", "unitless", description);
        }

        @Override
        public String toString() {
            return "LocationVariable{" + super.toString() + '}';
        }
    }

    public static class SimpleSALVariable
    extends SALVariable {
        private final BusVariable busVariable;

        public SimpleSALVariable(String variableName, String type, String units, String description, BusVariable busVariable) {
            super(variableName, type, units, description);
            this.busVariable = busVariable;
        }

        public BusVariable getBusVariable() {
            return this.busVariable;
        }

        @Override
        public String toString() {
            return "SimpleSALVariable{" + super.toString() + " busVariable=" + this.busVariable + '}';
        }
    }

    public static abstract class SALVariable {
        private String variableName;
        private final String type;
        private final String units;
        private final String description;

        public SALVariable(String variableName, String type, String units, String description) {
            this.variableName = variableName;
            this.type = type;
            this.units = units;
            this.description = description;
        }

        public String getVariableName() {
            return this.variableName;
        }

        public String getType() {
            return this.type;
        }

        public String getUnits() {
            return this.units;
        }

        public String getDescription() {
            return this.description;
        }

        public int getCount() {
            return 1;
        }

        public String toString() {
            return "variableName=" + this.variableName + ", type=" + this.type + ", units=" + this.units + ", description=\"" + this.description + "\"";
        }

        private void setName(String newName) {
            this.variableName = newName;
        }
    }
}

