/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericConverter {
    private final Map<String, String> nameChangeTelemetry;
    private final Map<String, String> nameChangeSettingsApplied;
    private final List<String> mia = new ArrayList<String>();
    private final Map<Class, List<String>> alreadyWarned = new HashMap<Class, List<String>>();
    private final Map<String, Class> classMap;
    private final List<String> subsystemToConvert;
    private final Mapping mapping;
    private static final boolean DEBUG_PRINT_TRENDING = false;
    private static final boolean DEBUG_PRINT_SETTINGS = false;
    private static final boolean DEBUG_PRINT_REFLECTION = false;
    private static final boolean DEBUG_PRINT_BADVALUES = false;
    boolean badBValue = false;
    double badDValue = Double.NaN;
    int badIValue = -111111;
    float badFValue = Float.NaN;
    String badStringValue = "NOTFOUND";
    long badLValue = -1111111L;

    public GenericConverter(List<String> subsystemsToConvert, Map<String, Class> classMap, Mapping mapping, Map<String, String> nameChangeTelemetry, Map<String, String> nameChangeSettingsApplied) {
        this.subsystemToConvert = subsystemsToConvert;
        this.classMap = classMap;
        this.nameChangeTelemetry = nameChangeTelemetry;
        this.nameChangeSettingsApplied = nameChangeSettingsApplied;
        this.mapping = mapping;
    }

    public List<CameraTelemetry> telemetryConverter(Map<String, SALClassDescription> givenSalClassMapInfo, StatusSubsystemData data) throws ReflectiveOperationException {
        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<CameraTelemetry>();
        Map<String, SALClassDescription> salClassMapInfo = givenSalClassMapInfo;
        String subsystemName = data.getOriginAgentInfo().getName();
        KeyValueData subsystemData = data.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        HashMap<String, Object> dataNamesAndValues = new HashMap<String, Object>();
        for (KeyValueData kvd : values) {
            String pathFromBus = kvd.getKey();
            if (pathFromBus.contains("/state")) continue;
            dataNamesAndValues.put(pathFromBus, kvd.getValue());
        }
        for (String subsystem : this.subsystemToConvert) {
            for (Map.Entry<String, SALClassDescription> scd : givenSalClassMapInfo.entrySet()) {
                int numGetMethods;
                Parameter[] parameters;
                CameraTelemetry ct;
                int[] check;
                int numMissingValues;
                String scdSALClassName = scd.getKey();
                Class realSALClass = this.classMap.get(scdSALClassName);
                if (realSALClass == null) {
                    // empty if block
                }
                if (!subsystemName.equals(subsystem) || realSALClass == null || (numMissingValues = (check = this.checkClassCompleteness(ct = (CameraTelemetry)this.reflectedClass(realSALClass, dataNamesAndValues, parameters = realSALClass.getConstructors()[0].getParameters(), scd.getValue())))[0]) == (numGetMethods = check[1])) continue;
                salTelemetry.add(ct);
            }
        }
        return salTelemetry;
    }

    public List<CameraEvent> settingsAppliedEventConverter(Map<String, SALClassDescription> givenSalClassMapInfo, StatusConfigurationInfo sdata) throws ReflectiveOperationException {
        ConfigurationInfo data = sdata.getConfigurationInfo();
        String subsystemFromStatusConfiguration = sdata.getOriginAgentInfo().getName();
        Map<String, SALClassDescription> salClassMapInfo = givenSalClassMapInfo;
        ArrayList<CameraEvent> salSettings = new ArrayList<CameraEvent>();
        List cpinfo = data.getAllParameterInfo();
        HashMap categoryIndexedData = new HashMap();
        boolean legitSubsystem = false;
        if (this.subsystemToConvert.contains(sdata.getOriginAgentInfo().getName())) {
            legitSubsystem = true;
        }
        ArrayList categoriesFromReceivedClassNames = new ArrayList();
        for (String category : data.getCategorySet()) {
            HashMap<String, Object> thisCategoriesData = new HashMap<String, Object>();
            for (ConfigurationParameterInfo cp : cpinfo) {
                if (!category.equals(cp.getCategoryName()) || category == null) continue;
                thisCategoriesData.put(cp.getPathName(), cp.getConfiguredValueObject());
            }
            if (category == null || category.isEmpty() || thisCategoriesData.isEmpty()) continue;
            categoryIndexedData.put(category, thisCategoriesData);
        }
        Map<String, Object> localSettingsData = new HashMap();
        for (Map.Entry<String, SALClassDescription> scd : givenSalClassMapInfo.entrySet()) {
            String salClassDescriptionName = scd.getKey();
            System.out.println(" ");
            System.out.println("**** GenericConverter3:settingsAppliedConverter - Class Name from SALClass Description  ****");
            System.out.println(" SAL description class name " + salClassDescriptionName);
            Class realSALClass = this.classMap.get(salClassDescriptionName);
            if (realSALClass == null) continue;
            System.out.println(" ");
            System.out.println("**** GenericConverter3:settingsAppliedConverter - changed class name  ****");
            System.out.println(" real class name " + realSALClass.getName());
            String categoryFromSALClassDescription = scd.getValue().getCategory();
            localSettingsData = (Map)categoryIndexedData.get(categoryFromSALClassDescription);
            System.out.println(" ");
            System.out.println("**** GenericConverter3:settingsAppliedConverter - Local settings data from category " + scd.getValue().getCategory() + " ****");
            for (Map.Entry key : localSettingsData.entrySet()) {
                System.out.println(" Local Settings Data Name " + (String)key.getKey() + " local Settings data type " + key.getValue().getClass().getTypeName() + " local settings data value " + key.getValue());
            }
            System.out.println("*****************");
            Parameter[] parameters = realSALClass.getConstructors()[0].getParameters();
            CameraEvent ce = (CameraEvent)this.reflectedClass(realSALClass, localSettingsData, parameters, scd.getValue());
            int[] check = this.checkClassCompleteness(ce);
            int numMissingValues = check[0];
            int numGetMethods = check[1];
            if (numMissingValues != numGetMethods) {
                salSettings.add(ce);
            }
            if (numMissingValues != numGetMethods) continue;
        }
        return salSettings;
    }

    public Object reflectedClass(Class cls, Map<String, Object> dataNamesAndValues, Parameter[] parameters, SALClassDescription salClassDescriptionList) throws ReflectiveOperationException {
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        HashMap<String, List<SALClassDescription.BusVariable>> locationBusVariableCorrespondence = new HashMap<String, List<SALClassDescription.BusVariable>>();
        for (SALClassDescription.SALVariable sALVariable : salClassDescriptionList.getVariables()) {
            SALClassDescription.PatternMatchedSALVariable pv;
            if (!(sALVariable instanceof SALClassDescription.PatternMatchedSALVariable) || (pv = (SALClassDescription.PatternMatchedSALVariable)sALVariable).getBusVariables().isEmpty()) continue;
            locationBusVariableCorrespondence.put(pv.getLocationVariable().getVariableName(), pv.getBusVariables());
        }
        boolean found = false;
        for (Parameter parameter : parameters) {
            found = false;
            if (parameter.getName().trim().equals("priority")) {
                constructorArgs.add(1);
                found = true;
            }
            if (parameter.getName().trim().equals("version")) {
                constructorArgs.add(1);
                found = true;
            }
            if (!found) {
                for (SALClassDescription.SALVariable sv : salClassDescriptionList.getVariables()) {
                    String parameterType = parameter.getType().toString();
                    boolean parameterIsArray = parameter.getType().isArray();
                    boolean isAnArrayList = parameterType.contains("List") || parameterType.contains("List");
                    boolean isAnArray = !isAnArrayList && parameterType.contains("[");
                    boolean isAString = parameterType.contains("String") || parameterType.contains("String");
                    boolean isAMap = parameterType.contains("Map");
                    boolean involvesPatternMatching = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                    if (involvesPatternMatching) {
                        // empty if block
                    }
                    String svVariableName = "";
                    if (sv instanceof SALClassDescription.LocationVariable) {
                        svVariableName = ((SALClassDescription.LocationVariable)sv).getVariableName();
                    }
                    if (!sv.getVariableName().toLowerCase().trim().equals(parameter.getName().toLowerCase().trim())) continue;
                    if (parameterIsArray && involvesPatternMatching && !parameter.getName().trim().toLowerCase().contains("location")) {
                        Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), ((SALClassDescription.PatternMatchedSALVariable)sv).getCount());
                        for (int i = 0; i < ((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables().size(); ++i) {
                            SALClassDescription.BusVariable busVarName = ((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables().get(i);
                            if (null != this.returnBusData(busVarName.getPathAndNameOnBuses(), dataNamesAndValues)) {
                                Object returnedData = this.returnBusData(busVarName.getPathAndNameOnBuses(), dataNamesAndValues);
                                if (returnedData.getClass().isArray()) {
                                    arrayArg = returnedData;
                                    continue;
                                }
                                Array.set(arrayArg, i, returnedData);
                                continue;
                            }
                            Array.set(arrayArg, i, -111111);
                        }
                        constructorArgs.add(arrayArg);
                        found = true;
                    }
                    if (!parameterIsArray && parameter.getName().trim().toLowerCase().contains("location")) {
                        ArrayList<String> locationVals = new ArrayList<String>();
                        if (locationBusVariableCorrespondence.get(sv.getVariableName()) == null) {
                            // empty if block
                        }
                        for (SALClassDescription.BusVariable bv : (List)locationBusVariableCorrespondence.get(sv.getVariableName())) {
                            locationVals.add(this.getLocationValue(bv.getPathAndNameOnBuses()).replace("/", ""));
                        }
                        constructorArgs.add(GenericConverter.convertStringList(locationVals));
                        found = true;
                    }
                    if (parameterIsArray && !involvesPatternMatching) {
                        boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                        String busVariableName = ((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses();
                        constructorArgs.add(this.returnBusData(busVariableName, dataNamesAndValues));
                        found = true;
                    }
                    if (involvesPatternMatching && !parameterIsArray && !parameter.getName().toLowerCase().contains("location")) {
                        boolean matched = sv instanceof SALClassDescription.PatternMatchedSALVariable;
                        constructorArgs.add(this.returnBusData(((SALClassDescription.PatternMatchedSALVariable)sv).getBusVariables().get(0).getPathAndNameOnBuses(), dataNamesAndValues));
                        found = true;
                    }
                    if (involvesPatternMatching || parameterIsArray || parameter.getName().toLowerCase().contains("location")) continue;
                    boolean notmatched = sv instanceof SALClassDescription.SimpleSALVariable;
                    constructorArgs.add(this.returnBusData(((SALClassDescription.SimpleSALVariable)sv).getBusVariable().getPathAndNameOnBuses(), dataNamesAndValues));
                    found = true;
                }
            }
            if (found) continue;
            this.mia.add(parameter.getName());
            this.alreadyWarned.put(cls, this.mia);
            int jj = Collections.frequency((Collection)this.alreadyWarned.get(cls), parameter.getName());
            if (parameter.getType().isArray()) {
                constructorArgs.add(new double[0]);
                continue;
            }
            if (parameter.getType().equals(String.class)) {
                constructorArgs.add("NOTFOUND");
                continue;
            }
            if (parameter.getType().getName().toLowerCase().contains("boolean")) {
                constructorArgs.add(this.badBValue);
                continue;
            }
            if (parameter.getType().getName().toLowerCase().contains("double")) {
                constructorArgs.add(this.badDValue);
                continue;
            }
            if (parameter.getType().getName().toLowerCase().contains("float")) {
                constructorArgs.add(Float.valueOf(this.badFValue));
                continue;
            }
            constructorArgs.add(-111111);
        }
        return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
    }

    String getLocationValue(String busPathName) {
        Mapping.Match match = this.mapping.match(busPathName);
        if (match != null) {
            return match.getLocation();
        }
        return "NOTFOUND";
    }

    Object returnBusData(String pathName, Map<String, Object> dataNamesAndValues) {
        Object returnValue = null;
        for (String tospath : dataNamesAndValues.keySet()) {
            String key = tospath;
            if (key.contains("/state") || !pathName.toLowerCase().trim().equals(tospath.toLowerCase().trim())) continue;
            returnValue = dataNamesAndValues.get(tospath);
            if (returnValue instanceof Double) {
                returnValue = Float.valueOf(((Double)returnValue).floatValue());
            }
            if (returnValue instanceof HashMap) {
                returnValue = ((HashMap)returnValue).toString();
                System.out.println(" Hash Map printout " + returnValue + " " + returnValue.getClass().getTypeName());
                if (returnValue.getClass().getTypeName().contains("[")) {
                    System.out.println(" Is a string array/list " + returnValue);
                }
            }
            if (returnValue.getClass().getTypeName().toLowerCase().contains("string") && returnValue instanceof String[]) {
                returnValue = GenericConverter.convertStringArray((String[])returnValue);
            }
            if (!returnValue.getClass().getTypeName().toLowerCase().contains("string") || !(returnValue instanceof List)) continue;
            returnValue = GenericConverter.convertStringList((List)returnValue);
        }
        if (returnValue == null) {
            returnValue = this.badDValue;
        }
        return returnValue;
    }

    String cleanupXMLClassName(String xmlClassName) {
        xmlClassName = xmlClassName.replace("comcam-", "");
        String[] blahs = xmlClassName.split("_");
        String cleanedName = "";
        for (int j = 1; j < blahs.length; ++j) {
            cleanedName = cleanedName + blahs[j] + "_";
        }
        int lastIndex = cleanedName.lastIndexOf("_");
        cleanedName = cleanedName.substring(0, lastIndex);
        return cleanedName.trim();
    }

    String cleanupSALClassName(String salClassName) {
        String cleanedName = salClassName.split("\\.")[salClassName.split("\\.").length - 1];
        cleanedName = cleanedName.replace("ATCamera", "").trim();
        cleanedName = cleanedName.replace("MTCamera", "").trim();
        cleanedName = cleanedName.replace("CCCamera", "").trim();
        cleanedName = cleanedName.replace("Telemetry", "").trim();
        if ((cleanedName = cleanedName.replace("SettingsAppliedEvent", "").trim()).startsWith("_")) {
            cleanedName = cleanedName.replaceFirst("[_]", "").trim();
        }
        return cleanedName.trim();
    }

    boolean badValueOrValues(Object invokedValue, Object badValue, String className, String methodName) {
        int i;
        boolean bad = true;
        boolean isanArray = invokedValue.getClass().isArray();
        String type = invokedValue.getClass().getTypeName();
        boolean isDouble = false;
        boolean isString = false;
        boolean isInt = false;
        boolean isFloat = false;
        boolean isLong = false;
        boolean isBool = false;
        if (type.toLowerCase().contains("double")) {
            isDouble = true;
            badValue = this.badDValue;
        } else if (type.toLowerCase().contains("string")) {
            isString = true;
            badValue = this.badStringValue;
        } else if (type.toLowerCase().contains("int")) {
            isInt = true;
            badValue = this.badIValue;
        } else if (type.toLowerCase().contains("float")) {
            isFloat = true;
            badValue = Float.valueOf(this.badFValue);
        } else if (type.toLowerCase().contains("long")) {
            isLong = true;
            badValue = this.badLValue;
        }
        if (isanArray && isDouble) {
            double[] doubleArray = (double[])invokedValue;
            for (i = 0; i < doubleArray.length; ++i) {
                if (Double.isNaN(doubleArray[i])) continue;
                bad = false;
            }
        }
        if (isanArray && isInt) {
            int[] intArray = (int[])invokedValue;
            for (i = 0; i < intArray.length; ++i) {
                if (intArray[i] == (Integer)badValue) continue;
                bad = false;
            }
        }
        if (isanArray && isFloat) {
            float[] floatArray = (float[])invokedValue;
            for (i = 0; i < floatArray.length; ++i) {
                if (Float.isNaN(floatArray[i])) continue;
                bad = false;
            }
        }
        if (!isanArray && !invokedValue.equals(badValue)) {
            bad = false;
        }
        return bad;
    }

    Map<String, Object> copyStringObjectMap(Map<String, Object> inMap) {
        HashMap<String, Object> copy = new HashMap<String, Object>();
        copy.putAll(inMap);
        return copy;
    }

    private static String betterToString(Constructor constructor, List<Object> data) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            result.add(constructor.getParameters()[i].getName() + "=" + (data.get(i).getClass().isArray() ? GenericConverter.arrayToString(data.get(i)) : data.get(i).toString()));
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private static String convertStringList(List<String> stringList) {
        String[] localArray = new String[stringList.size()];
        stringList.toArray(localArray);
        return GenericConverter.manipulateStringArray(localArray);
    }

    private static String convertStringArray(String[] stringArray) {
        Object localArray = null;
        return GenericConverter.manipulateStringArray(stringArray);
    }

    private static String manipulateStringArray(String[] inputArray) {
        String returnStringI = "";
        String returnStringF = "";
        int lengthOfStringArray = inputArray.length;
        if (lengthOfStringArray <= 0) {
            System.out.println("Warning from GenericConverter3:manipulateStringArray : Length of string Array is 0 !");
            returnStringF = "NOTFOUND";
        } else {
            for (int i = 0; i < lengthOfStringArray; ++i) {
                returnStringI = returnStringI + inputArray[i] + ":";
                if (i != lengthOfStringArray - 1) continue;
                int target = returnStringI.lastIndexOf(":");
                returnStringF = target == -1 ? returnStringI : returnStringI.substring(0, target);
            }
        }
        return returnStringF;
    }

    private static String arrayToString(Object array) {
        ArrayList<String> result = new ArrayList<String>();
        int l = Array.getLength(array);
        for (int i = 0; i < l; ++i) {
            result.add(Array.get(array, i).toString());
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    int[] checkClassCompleteness(Object cls) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Parameter[] thisClassParameters = cls.getClass().getConstructors()[0].getParameters();
        Method[] methods = cls.getClass().getDeclaredMethods();
        ArrayList<Method> getMethods = new ArrayList<Method>();
        int numMissingValues = 0;
        int numGetMethods = 0;
        int[] returnValues = new int[2];
        for (int i = 0; i < methods.length; ++i) {
            String methodName = methods[i].getName();
            String[] parts = methodName.split("\\s");
            if (parts[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
            getMethods.add(methods[i]);
            ++numGetMethods;
        }
        boolean checkbadvalue = false;
        for (Method method : getMethods) {
            if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("double")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badDValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("string")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badStringValue, cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("float")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), Float.valueOf(this.badFValue), cls.getClass().getName(), method.getName());
            } else if (method.invoke(cls, new Object[0]).getClass().getTypeName().toLowerCase().contains("int")) {
                checkbadvalue = this.badValueOrValues(method.invoke(cls, new Object[0]), this.badIValue, cls.getClass().getName(), method.getName());
            }
            if (checkbadvalue) {
                ++numMissingValues;
            }
            if (checkbadvalue || !method.getName().toLowerCase().contains("location")) continue;
            ++numMissingValues;
        }
        returnValues[0] = numMissingValues;
        returnValues[1] = numGetMethods;
        return returnValues;
    }
}

