/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.imagenaming.Controller;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.imagenaming.Source;
import org.lsst.ccs.imagenaming.service.ImageNameService;
import org.lsst.ccs.subsystem.focalplane.data.ImageMetaDataEvent;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.CCSExecutor;
import org.lsst.ccs.subsystem.ocsbridge.DictionaryProvider;
import org.lsst.ccs.subsystem.ocsbridge.GUIDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.MCMLayer;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSCommandExecutor;
import org.lsst.ccs.subsystem.ocsbridge.SALHeartbeatGenerator;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.ToyOCSGUI;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMDirectLayer;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.DelimitedStringSplitJoin;
import org.lsst.ccs.subsystem.ocsbridge.util.FocalPlaneHardwareIdConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSCommandConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateChangeToEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateEventConverter;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.subsystem.ocsbridge.util.SummaryInfoConverter;
import org.lsst.ccs.utilities.location.Location;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;
import org.lsst.sal.atcamera.event.ImageReadoutParametersEvent;
import org.lsst.sal.atcamera.event.ShutterMotionProfileEvent;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.command.DisableCommand;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.StandbyCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndOfImageTelemetryEvent;
import org.lsst.sal.camera.event.EndReadoutEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.ImageReadoutParametersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartIntegrationEvent;
import org.lsst.sal.camera.event.StartReadoutEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSBridge {
    private static final Logger LOG = Logger.getLogger(OCSBridge.class.getName());
    private static final DelimitedStringSplitJoin DELIMITED_STRING_SPLIT_JOIN = new DelimitedStringSplitJoin();
    private final CCS ccs;
    private final State lse209State;
    private final State offlineState;
    private OCSCommandExecutor ocsCommandExecutor;
    private CCSCommandExecutor ccsCommandExecutor;
    private final MCMLayer mcm;
    static final int DEFAULT_EVENT_PRIORITY = 1;
    private BlockingQueue<MCM.CCSImageNameEvent> imageNameTransfer = new ArrayBlockingQueue<MCM.CCSImageNameEvent>(1);
    private MCM.CCSImageNameEvent imageNameEvent;
    private EndOfImageTelemetryEvent endOfImageTelemetryEvent;
    private final OCSBridgeConfig config;
    private final State commandState;
    private final OCSCommandConverter ocsCcsCommandConverter = new OCSCommandConverter();
    private final OCSStateEventConverter ocsCcsStateEventConverter = new OCSStateEventConverter();
    private final OCSStateChangeToEventConverter ocsStateChangeToEventConverter = new OCSStateChangeToEventConverter();
    private CCSTimeStamp openTime;
    private final TelemetrySender sender;
    private final DictionaryProvider dictionaryProvider;

    OCSBridge(OCSBridgeConfig config, CCS ccs, MCMLayer mcm, DictionaryProvider dictionaryProvider) {
        this.config = config;
        this.dictionaryProvider = dictionaryProvider;
        this.ccs = ccs;
        this.mcm = mcm;
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.lse209State = new State<SummaryStateEvent.SummaryState>(SummaryStateEvent.SummaryState.OFFLINE);
        ccs.getAggregateStatus().add(now, this.lse209State);
        this.offlineState = new State<OfflineDetailedStateEvent.OfflineState>(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        ccs.getAggregateStatus().add(now, this.offlineState);
        this.commandState = new State<CCSCommandStateEvent.CCSCommandState>(CCSCommandStateEvent.CCSCommandState.IDLE);
        ccs.getAggregateStatus().add(now, this.commandState);
        this.ocsCommandExecutor = new OCSCommandExecutor(this);
        this.ccsCommandExecutor = new CCSCommandExecutor();
        this.sender = TelemetrySender.create(config.getDevice(), this.ocsCommandExecutor, ccs.getScheduler());
        SALHeartbeatGenerator shg = new SALHeartbeatGenerator(this);
        shg.start();
        mcm.addStateChangeListener((when, state, oldState) -> {
            CameraEvent converted;
            ImageName imageName;
            if ((oldState == FocalPlane.RaftsState.CLEARING || oldState == FocalPlane.RaftsState.QUIESCENT) && state == FocalPlane.RaftsState.INTEGRATING) {
                ccs.runInBackground(() -> {
                    try {
                        long start = System.currentTimeMillis();
                        this.imageNameEvent = this.imageNameTransfer.poll(2L, TimeUnit.SECONDS);
                        long waitTime = System.currentTimeMillis() - start;
                        if (this.imageNameEvent == null) {
                            throw new RuntimeException("Image name could not be retrieved");
                        }
                        if (waitTime > 500L) {
                            LOG.log(Level.WARNING, "Waited {0} for imageNameEvent", waitTime);
                        }
                        ImageName imageName = this.imageNameEvent.getImageName();
                        StartIntegrationEvent sie = StartIntegrationEvent.builder().priority(1).additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).build();
                        this.ocsCommandExecutor.sendEvent((CameraEvent)sie);
                    }
                    catch (InterruptedException | RuntimeException ex) {
                        LOG.log(Level.SEVERE, "Error sending StartIntegrationEvent", ex);
                    }
                });
            }
            if (oldState == FocalPlane.RaftsState.INTEGRATING && state == FocalPlane.RaftsState.READING_OUT) {
                imageName = this.imageNameEvent.getImageName();
                StartReadoutEvent sre = StartReadoutEvent.builder().priority(1).additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampStartOfReadout(when.getTAIDouble()).exposureTime(this.imageNameEvent.getExposureTime()).build();
                this.ocsCommandExecutor.sendEvent((CameraEvent)sre);
            }
            if (oldState == FocalPlane.RaftsState.READING_OUT) {
                imageName = this.imageNameEvent.getImageName();
                EndReadoutEvent ere = EndReadoutEvent.builder().priority(1).additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(imageName.toString()).imageNumber(imageName.getNumber()).imageSource(imageName.getSource().getCode()).imageController(imageName.getController().getCode()).imageDate(imageName.getDateString()).timestampAcquisitionStart(this.imageNameEvent.getIntegrationStartTime().getTAIDouble()).timestampEndOfReadout(when.getTAIDouble()).requestedExposureTime(this.imageNameEvent.getExposureTime()).build();
                this.ocsCommandExecutor.sendEvent((CameraEvent)ere);
                EndOfImageTelemetryEvent endOfImageTelemetryEventAtEndReadout = this.endOfImageTelemetryEvent;
                ccs.schedule(Duration.ofMillis(300L), () -> {
                    if (endOfImageTelemetryEventAtEndReadout != null) {
                        this.ocsCommandExecutor.sendEvent((CameraEvent)endOfImageTelemetryEventAtEndReadout);
                    }
                });
            }
            if ((converted = this.ocsStateChangeToEventConverter.convert(when, oldState, state, 1)) != null) {
                this.ocsCommandExecutor.sendEvent(converted);
            }
            if (state == Shutter.ShutterState.OPEN) {
                this.openTime = when;
            }
            if ((oldState == Shutter.ShutterState.CLOSING || oldState == Shutter.ShutterState.OPEN) && state == Shutter.ShutterState.CLOSED) {
                CCSTimeStamp closeTime = when;
                this.ocsCommandExecutor.sendEvent((CameraEvent)new ShutterMotionProfileEvent(1, (closeTime.getTAIDouble() - this.openTime.getTAIDouble()) / 1000.0));
            }
        });
        mcm.addEventListener(event -> {
            if (event instanceof FilterChanger.CCSAvailableFiltersEvent) {
                List<String> filters = ((FilterChanger.CCSAvailableFiltersEvent)event).getAvailableFilters();
                this.ocsCommandExecutor.sendEvent((CameraEvent)new AvailableFiltersEvent(1, DELIMITED_STRING_SPLIT_JOIN.join(filters)));
            } else if (event instanceof MCM.CCSImageNameEvent) {
                LOG.log(Level.INFO, "CCSImageNameEvent event {0}", event);
                this.imageNameTransfer.add((MCM.CCSImageNameEvent)event);
            } else if (event instanceof MCM.CCSSetFilterEvent) {
                MCM.CCSSetFilterEvent setFilter = (MCM.CCSSetFilterEvent)event;
                if (setFilter.isStart()) {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new StartSetFilterEvent(1, setFilter.getFilterName(), setFilter.getFilterType()));
                } else {
                    this.ocsCommandExecutor.sendEvent((CameraEvent)new EndSetFilterEvent(1, setFilter.getFilterName(), setFilter.getFilterType(), setFilter.getSlot(), setFilter.getPosition()));
                }
            } else if (event instanceof MCM.CCSSettingsAppliedEvent) {
                String otherSettingsEvents = "FocalPlaneHardwareIdSettingsApplied";
                this.ocsCommandExecutor.sendEvent((CameraEvent)new SettingsAppliedEvent(1, ((MCM.CCSSettingsAppliedEvent)event).getSettings(), otherSettingsEvents));
            }
        });
        mcm.addStatusMessageListener(msg -> {
            if (msg instanceof StatusConfigurationInfo) {
                StatusConfigurationInfo sci = (StatusConfigurationInfo)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                ConfigurationInfo info = sci.getConfigurationInfo();
                if (originAgentInfo != null && "FOCAL_PLANE".equals(originAgentInfo.getAgentProperty("agentCategory"))) {
                    SummaryInfoConverter converter = new SummaryInfoConverter(config.getDevice());
                    this.ocsCommandExecutor.sendEvent(converter.convert(info));
                    FocalPlaneHardwareIdConverter converter2 = new FocalPlaneHardwareIdConverter(config.getDevice());
                    this.ocsCommandExecutor.sendEvent(converter2.convert(info));
                } else {
                    LOG.log(Level.WARNING, "Got unhandled config from {0}", subsystemName);
                }
            } else if (msg instanceof StatusSubsystemData) {
                StatusSubsystemData ssd = (StatusSubsystemData)msg;
                AgentInfo originAgentInfo = msg.getOriginAgentInfo();
                String subsystemName = originAgentInfo == null ? "unknown" : originAgentInfo.getName();
                LOG.log(Level.FINE, "Received from {0} {1}", new Object[]{subsystemName, ssd.getDataKey()});
                LOG.log(Level.FINE, "Data {0}", new Object[]{ssd.getSubsystemData().getValue().toString()});
                if (ssd.getSubsystemData().getValue() instanceof org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent) {
                    org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent data = (org.lsst.ccs.subsystem.focalplane.data.ImageReadoutParametersEvent)ssd.getSubsystemData().getValue();
                    ArrayList<String> ccdNames = new ArrayList<String>();
                    ArrayList<ImageReadoutParametersEvent.CcdType> ccdTypes = new ArrayList<ImageReadoutParametersEvent.CcdType>();
                    ArrayList<Integer> overCols = new ArrayList<Integer>();
                    ArrayList<Integer> overRows = new ArrayList<Integer>();
                    ArrayList<Integer> postCols = new ArrayList<Integer>();
                    ArrayList<Integer> postRows = new ArrayList<Integer>();
                    ArrayList<Integer> preCols = new ArrayList<Integer>();
                    ArrayList<Integer> preRows = new ArrayList<Integer>();
                    ArrayList<Integer> readCols = new ArrayList<Integer>();
                    ArrayList<Integer> readCols2 = new ArrayList<Integer>();
                    ArrayList<Integer> readRows = new ArrayList<Integer>();
                    ArrayList<Integer> underCols = new ArrayList<Integer>();
                    int index = 0;
                    for (Location location : data.getLocations()) {
                        int nSensors = location.type().getCCDCount();
                        for (int i2 = 0; i2 < nSensors; ++i2) {
                            ccdNames.add(location.getRaftName() + (config.getDevice() == OCSBridgeConfig.Device.AUXTEL ? "S00" : location.getSensorName(i2)));
                            ccdTypes.add(ImageReadoutParametersEvent.CcdType.valueOf((String)data.getCcdType()[index].toUpperCase()));
                            overCols.add(data.getOverCols()[index]);
                            overRows.add(data.getOverRows()[index]);
                            postCols.add(data.getPostCols()[index]);
                            postRows.add(data.getPostRows()[index]);
                            preCols.add(data.getPreCols()[index]);
                            preRows.add(data.getPreRows()[index]);
                            readCols.add(data.getReadCols()[index]);
                            readCols2.add(data.getReadCols2()[index]);
                            readRows.add(data.getReadRows()[index]);
                            underCols.add(data.getUnderCols()[index]);
                        }
                        ++index;
                    }
                    Object irpe = config.getDevice() == OCSBridgeConfig.Device.AUXTEL ? ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join(ccdNames)).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType(ImageReadoutParametersEvent.CcdType.ITL).overRows(((Integer)overRows.get(0)).intValue()).overCols(((Integer)overCols.get(0)).intValue()).readRows(((Integer)readRows.get(0)).intValue()).readCols(((Integer)readCols.get(0)).intValue()).readCols2(((Integer)readCols2.get(0)).intValue()).preCols(((Integer)preCols.get(0)).intValue()).preRows(((Integer)preRows.get(0)).intValue()).postCols(((Integer)postCols.get(0)).intValue()).underCols(((Integer)underCols.get(0)).intValue()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build() : org.lsst.sal.camera.event.ImageReadoutParametersEvent.builder().imageName(data.getImageName().toString()).ccdLocation(DELIMITED_STRING_SPLIT_JOIN.join(ccdNames)).raftBay(ccdNames.stream().map(name -> name.substring(0, 3)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdSlot(ccdNames.stream().map(name -> name.substring(3, 6)).collect(DELIMITED_STRING_SPLIT_JOIN.joining())).ccdType((ImageReadoutParametersEvent.CcdType[])ccdTypes.stream().toArray(ImageReadoutParametersEvent.CcdType[]::new)).overRows(overRows.stream().mapToInt(i -> i).toArray()).overCols(overCols.stream().mapToInt(i -> i).toArray()).readRows(readRows.stream().mapToInt(i -> i).toArray()).readCols(readCols.stream().mapToInt(i -> i).toArray()).readCols2(readCols2.stream().mapToInt(i -> i).toArray()).preCols(preCols.stream().mapToInt(i -> i).toArray()).preRows(preRows.stream().mapToInt(i -> i).toArray()).postCols(postCols.stream().mapToInt(i -> i).toArray()).underCols(underCols.stream().mapToInt(i -> i).toArray()).daqFolder(data.getDaqFolder()).daqAnnotation(data.getAnnotation()).build();
                    this.ocsCommandExecutor.sendEvent((CameraEvent)irpe);
                } else if (ssd.getSubsystemData().getValue() instanceof ImageMetaDataEvent) {
                    ImageMetaDataEvent data = (ImageMetaDataEvent)ssd.getSubsystemData().getValue();
                    this.endOfImageTelemetryEvent = EndOfImageTelemetryEvent.builder().priority(1).additionalKeys(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().keySet())).additionalValues(DELIMITED_STRING_SPLIT_JOIN.join(this.imageNameEvent.getKeyValueData().values())).imagesInSequence(this.imageNameEvent.getImagesInSequence()).imageIndex(this.imageNameEvent.getSequenceNumber() + 1).imageName(data.getImageName().toString()).imageSource(data.getImageName().getSource().getCode()).imageController(data.getImageName().getController().getCode()).imageDate(data.getImageName().getDateString()).imageNumber(data.getImageName().getNumber()).timestampAcquisitionStart(data.getLastClearTime().getTAIDouble()).timestampDateEnd(data.getIntegrationEndTime().getTAIDouble()).timestampDateObs(data.getIntegrationStartTime().getTAIDouble()).darkTime(data.getDarkTime()).imageTag(data.getDaqTag()).exposureTime(this.imageNameEvent.getExposureTime()).measuredShutterOpenTime(this.imageNameEvent.getExposureTime()).emulatedImage(data.getEmulatedImageName() == null ? "" : data.getEmulatedImageName()).build();
                } else if (ssd.getSubsystemData().getValue() instanceof List) {
                    if (dictionaryProvider != null) {
                        this.sender.send(dictionaryProvider.getStatusClassDescriptions(), ssd);
                    }
                } else {
                    LOG.log(Level.WARNING, "Got unhandled telemetry from {0}", subsystemName);
                }
            }
        });
        ccs.addStateChangeListener((when, currentState, oldState) -> {
            int priority = 1;
            CameraStateChangeEvent converted = this.ocsCcsStateEventConverter.convert(when, currentState, priority);
            if (converted == null) {
                LOG.log(Level.WARNING, "Enum {0} of class {1} could not be converted to equivalent OCS state", new Object[]{currentState, currentState.getClass()});
            } else {
                this.ocsCommandExecutor.sendEvent((CameraEvent)converted);
            }
        });
    }

    State<CCSCommandStateEvent.CCSCommandState> getCommandState() {
        return this.commandState;
    }

    public OCSBridgeConfig getConfig() {
        return this.config;
    }

    void setOCSCommandExecutor(OCSCommandExecutor ocs) {
        this.ocsCommandExecutor = ocs;
        this.sender.setSender(ocs);
        CCSTimeStamp now = CCSTimeStamp.currentTime();
        this.ccs.getAggregateStatus().getStates().stream().map(s -> this.ocsCcsStateEventConverter.convert(now, (Enum)s.getState(), 1)).filter(Objects::nonNull).forEach(converted -> this.ocsCommandExecutor.sendEvent((CameraEvent)converted));
    }

    public OCSCommandExecutor getOcsCommandExecutor() {
        return this.ocsCommandExecutor;
    }

    void setCCSCommandExecutor(CCSCommandExecutor ccs) {
        this.ccsCommandExecutor = ccs;
    }

    public static void main(String[] args) {
        OCSBridge ocs = OCSBridge.createOCSBridge();
        ToyOCSGUI gui = new ToyOCSGUI(new GUIDirectLayer(ocs), ocs.getConfig().getDevice());
        gui.setVisible(true);
    }

    static OCSBridge createOCSBridge() {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = MCMConfig.createDefaultConfig();
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)Source.MainCamera, (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(MCMConfig.Camera camera) {
        OCSBridgeConfig ocsConfig = OCSBridgeConfig.createDefaultConfig();
        MCMConfig mcmConfig = new MCMConfig(camera);
        ImageNameService ins = ImageNameService.testInstance((String)"jdbc:h2:mem:test;MODE=MYSQL", (Controller)Controller.OCS, (Source)(camera == MCMConfig.Camera.AUXTEL ? Source.AuxTel : Source.MainCamera), (String)"UTC", (Duration)Duration.ofHours(12L), (Instant)Instant.parse("2022-01-01T00:00:00.00Z"));
        return OCSBridge.createOCSBridge(ocsConfig, mcmConfig, ins);
    }

    static OCSBridge createOCSBridge(OCSBridgeConfig config, MCMConfig mcmConfig, ImageNameService imageNamingService) {
        CCS ccs = new CCS();
        MCMDirectLayer mcm = new MCMDirectLayer(new MCM(ccs, mcmConfig, imageNamingService));
        return new OCSBridge(config, ccs, mcm, null);
    }

    State getLse209State() {
        return this.lse209State;
    }

    State getOfflineState() {
        return this.offlineState;
    }

    void execute(CameraCommand cmd) {
        if (cmd instanceof DisableCommand) {
            this.execute((DisableCommand)cmd);
        } else if (cmd instanceof EnableCommand) {
            this.execute((EnableCommand)cmd);
        } else if (cmd instanceof ExitControlCommand) {
            this.execute((ExitControlCommand)cmd);
        } else if (cmd instanceof EnterControlCommand) {
            this.execute((EnterControlCommand)cmd);
        } else if (cmd instanceof TakeImagesCommand) {
            this.execute((TakeImagesCommand)cmd);
        } else if (cmd instanceof StartCommand) {
            this.execute((StartCommand)cmd);
        } else if (cmd instanceof StartImageCommand) {
            this.execute((StartImageCommand)cmd);
        } else if (cmd instanceof StandbyCommand) {
            this.execute((StandbyCommand)cmd);
        } else {
            ForwardToMCMExecutor fcm = new ForwardToMCMExecutor(cmd);
            this.ocsCommandExecutor.executeCommand(fcm);
        }
    }

    void execute(TakeImagesCommand command) {
        TakeImagesExecutor takeImages = new TakeImagesExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeImages);
    }

    void execute(StartImageCommand command) {
        StartImageExecutor startImage = new StartImageExecutor(command);
        this.ocsCommandExecutor.executeCommand(startImage);
    }

    void execute(EnterControlCommand command) {
        EnterControlExecutor takeControl = new EnterControlExecutor(command);
        this.ocsCommandExecutor.executeCommand(takeControl);
    }

    void execute(ExitControlCommand command) {
        ExitExecutor exit = new ExitExecutor(command);
        this.ocsCommandExecutor.executeCommand(exit);
    }

    void execute(StartCommand command) {
        StartExecutor start = new StartExecutor(command);
        this.ocsCommandExecutor.executeCommand(start);
    }

    void execute(StandbyCommand command) {
        StandbyExecutor standby = new StandbyExecutor(command);
        this.ocsCommandExecutor.executeCommand(standby);
    }

    void execute(EnableCommand command) {
        EnableExecutor enable = new EnableExecutor(command);
        this.ocsCommandExecutor.executeCommand(enable);
    }

    void execute(DisableCommand command) {
        DisableExecutor disable = new DisableExecutor(command);
        this.ocsCommandExecutor.executeCommand(disable);
    }

    void execute(CCSCommand command) {
        if (command instanceof CCSCommand.CCSSetAvailableCommand) {
            this.execute((CCSCommand.CCSSetAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSRevokeAvailableCommand) {
            this.execute((CCSCommand.CCSRevokeAvailableCommand)command);
        } else if (command instanceof CCSCommand.CCSSimulateFaultCommand) {
            this.execute((CCSCommand.CCSSimulateFaultCommand)command);
        } else if (command instanceof CCSCommand.CCSClearFaultCommand) {
            this.execute((CCSCommand.CCSClearFaultCommand)command);
        } else {
            throw new RuntimeException("Unknown command type: " + command);
        }
    }

    void execute(CCSCommand.CCSSetAvailableCommand command) {
        SetAvailableExecutor setAvailable = new SetAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(setAvailable));
    }

    void execute(CCSCommand.CCSRevokeAvailableCommand command) {
        RevokeAvailableExecutor revokeAvailable = new RevokeAvailableExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(revokeAvailable));
    }

    void execute(CCSCommand.CCSSimulateFaultCommand command) {
        SimulateFaultExecutor simulateFault = new SimulateFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(simulateFault));
    }

    void execute(CCSCommand.CCSClearFaultCommand command) {
        ClearFaultExecutor clearFault = new ClearFaultExecutor(command);
        this.ccsCommandExecutor.executeCommand(new CCSCommand.CCSCommandResponse(clearFault));
    }

    public Future<Void> waitForState(Enum state) {
        return this.ccs.waitForStatus(state);
    }

    CCS getCCS() {
        return this.ccs;
    }

    class ClearFaultExecutor
    extends CCSExecutor {
        private ClearFaultExecutor(CCSCommand.CCSClearFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.FAULT)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SimulateFaultExecutor
    extends CCSExecutor {
        private SimulateFaultExecutor(CCSCommand.CCSSimulateFaultCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.FAULT);
        }
    }

    class RevokeAvailableExecutor
    extends CCSExecutor {
        private RevokeAvailableExecutor(CCSCommand.CCSRevokeAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class SetAvailableExecutor
    extends CCSExecutor {
        private SetAvailableExecutor(CCSCommand.CCSSetAvailableCommand command) {
        }

        @Override
        protected Duration testPreconditions() throws CCSCommand.CCSPreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY)) {
                throw new CCSCommand.CCSPreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        protected void execute() throws Exception {
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE);
        }
    }

    class DisableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public DisableExecutor(DisableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.ENABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class EnableExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnableExecutor(EnableCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.ENABLED);
        }
    }

    class StandbyExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public StandbyExecutor(StandbyCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.DISABLED)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)new SettingVersionsEvent(1, "Normal", "", ""));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartExecutor
    extends ForwardToMCMExecutor {
        public StartExecutor(StartCommand command) {
            super((CameraCommand)command, SummaryStateEvent.SummaryState.STANDBY);
        }

        @Override
        void execute() throws Exception {
            super.execute();
            OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)new AppliedSettingsMatchStartEvent(1, true));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.DISABLED);
        }
    }

    class ExitExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public ExitExecutor(ExitControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.STANDBY)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.OFFLINE);
            OCSBridge.this.offlineState.setState(OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY);
        }
    }

    class EnterControlExecutor
    extends OCSCommandExecutor.OCSExecutor {
        public EnterControlExecutor(EnterControlCommand command) {
            super((CameraCommand)command);
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(SummaryStateEvent.SummaryState.OFFLINE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.lse209State);
            }
            if (!OCSBridge.this.offlineState.isInState(OfflineDetailedStateEvent.OfflineState.OFFLINE_AVAILABLE)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in " + OCSBridge.this.offlineState);
            }
            return Duration.ZERO;
        }

        @Override
        void execute() throws Exception {
            OCSBridge.this.ocsCommandExecutor.sendEvent((CameraEvent)new SettingVersionsEvent(1, "1", "Normal", "ccs:///configuration-service"));
            OCSBridge.this.lse209State.setState(SummaryStateEvent.SummaryState.STANDBY);
        }
    }

    class StartImageExecutor
    extends ForwardToMCMExecutor {
        public StartImageExecutor(StartImageCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            OCSBridge.this.imageNameTransfer.clear();
            return super.forwardCommand();
        }
    }

    class TakeImagesExecutor
    extends ForwardToMCMExecutor {
        public TakeImagesExecutor(TakeImagesCommand command) {
            super((CameraCommand)command);
        }

        @Override
        protected CCSCommand.CCSAckOrNack forwardCommand() {
            OCSBridge.this.imageNameTransfer.clear();
            return super.forwardCommand();
        }
    }

    class ForwardToMCMExecutor
    extends OCSCommandExecutor.OCSExecutor {
        private CCSCommand.CCSCommandResponse response;
        private final SummaryStateEvent.SummaryState initialState;
        private final CameraCommand command;
        private CCSCommand ccsCommand;

        ForwardToMCMExecutor(CameraCommand command) {
            this(command, SummaryStateEvent.SummaryState.ENABLED);
        }

        ForwardToMCMExecutor(CameraCommand command, SummaryStateEvent.SummaryState initialState) {
            super(command);
            this.command = command;
            this.initialState = initialState;
        }

        @Override
        Duration testPreconditions() throws OCSCommandExecutor.PreconditionsNotMet {
            if (!OCSBridge.this.lse209State.isInState(this.initialState)) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command not accepted in: " + OCSBridge.this.lse209State);
            }
            try {
                this.ccsCommand = OCSBridge.this.ocsCcsCommandConverter.convert(this.command);
                CCSCommand.CCSAckOrNack can = this.forwardCommand();
                if (can.isNack()) {
                    throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + can.getReason());
                }
                return can.getDuration();
            }
            catch (OCSCommandConverter.CommandConversionException x) {
                throw new OCSCommandExecutor.PreconditionsNotMet("Command rejected: " + x.getMessage());
            }
        }

        protected CCSCommand.CCSAckOrNack forwardCommand() {
            this.response = OCSBridge.this.mcm.execute(this.ccsCommand);
            return this.response.waitForAckOrNack();
        }

        @Override
        void execute() throws Exception {
            this.response.waitForCompletion();
        }
    }
}

