/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridge;
import org.lsst.ccs.subsystem.ocsbridge.util.AggregateStatus;
import org.lsst.sal.camera.command.EnableCommand;
import org.lsst.sal.camera.command.EnterControlCommand;
import org.lsst.sal.camera.command.ExitControlCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class GoToEnable {
    public void goToEnable(OCSBridge ocsBridge) {
        AggregateStatus aggregateStatus = ocsBridge.getCCS().getAggregateStatus();
        if (!aggregateStatus.hasState(new Enum[]{SummaryStateEvent.SummaryState.ENABLED})) {
            if (aggregateStatus.hasState(new Enum[]{SummaryStateEvent.SummaryState.DISABLED})) {
                ocsBridge.execute(new EnableCommand());
            } else if (aggregateStatus.hasState(new Enum[]{SummaryStateEvent.SummaryState.OFFLINE})) {
                if (aggregateStatus.hasState(new Enum[]{OfflineDetailedStateEvent.OfflineState.OFFLINE_PUBLISH_ONLY})) {
                    ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
                }
                ocsBridge.execute(new EnterControlCommand());
                ocsBridge.execute(new StartCommand("Normal"));
                ocsBridge.execute(new EnableCommand());
            } else if (aggregateStatus.hasState(new Enum[]{SummaryStateEvent.SummaryState.STANDBY})) {
                ocsBridge.execute(new ExitControlCommand());
                ocsBridge.execute(new CCSCommand.CCSSetAvailableCommand());
                ocsBridge.execute(new EnterControlCommand());
                ocsBridge.execute(new StartCommand("Normal"));
                ocsBridge.execute(new EnableCommand());
            }
        }
    }
}

