package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.cccamera.telemetry.FcsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

/**
 *
 * @author tonyj
 */
public class ComCamTelemetrySender extends TelemetrySender {

    private final GenericConverter converter;

    public ComCamTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        // Map is what appears on the bus as key, on the right we have the argument 
        Map<String, String> nameChange = new HashMap<>();
        nameChange.put("ionpumpsvoltage", "ionpumpvoltage");
        nameChange.put("ionpumpscurrent", "ionpumpcurrent");
        nameChange.put("turborpm", "rpm");
        nameChange.put("pdu5votm3bi", "otm0bi");
        nameChange.put("pdu5votm3bv", "otm0bv");
        nameChange.put("pdu5votm3ai", "otm0ai");
        nameChange.put("pdu5votm3av", "otm0av");
        nameChange.put("steppermotor_motortemperature", "motorTemperature");
        nameChange.put("steppermotor_motorencoder", "motorEncoder");
        nameChange.put("linearencoder_linearposition", "linearPosition");

        List<String> subSystems = new ArrayList<>();
        subSystems.add("comcam-vacuum");
        subSystems.add("comcam-rebpower");
        subSystems.add("comcam-quadbox");
        subSystems.add("comcam-daq-monitor");
        subSystems.add("comcam-fp");
        subSystems.add("comcam-fcs");

        Map<String, Class> classMap = new HashMap<>();
        classMap.put("CCCamera_comcam-daq-monitor_Store", Daq_monitor_StoreTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Reb", org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Ccd", org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Segment", org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry.class);
        classMap.put("CCCamera_comcam-fp_RebTotalPower", org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Turbo", Vacuum_TurboTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold1", Vacuum_Cold1Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold2", Vacuum_Cold2Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cryo", Vacuum_CryoTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_VQMonitor", Vacuum_VQMonitorTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_IonPumps", Vacuum_IonPumpsTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Rtds", Vacuum_RtdsTelemetry.class);
        classMap.put("CCCamera_comcam-fcs", FcsTelemetry.class);


//        subSystemClasses.put(Rebpower_RebTelemetry.class, "comcam-rebpower");
//        subSystemClasses.put(Rebpower_RebpsTelemetry.class, "comcam-rebpower");
//        subSystemClasses.put(Quadbox_BFRTelemetry.class, "comcam-quadbox");
//        subSystemClasses.put(Quadbox_PDU_24VCTelemetry.class, "comcam-quadbox");
//        subSystemClasses.put(Quadbox_PDU_24VDTelemetry.class, "comcam-quadbox");
//        subSystemClasses.put(Quadbox_PDU_48VTelemetry.class, "comcam-quadbox");
//        subSystemClasses.put(Quadbox_PDU_5VTelemetry.class, "comcam-quadbox");
//        
        Mapping mapping = Mapping.defaultMapping();

        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }

    @Override
    GenericConverter getConverter() {
        return converter;
    }

}
