/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.sal.atcamera.telemetry.PowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry;
import org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry;
import org.lsst.sal.cccamera.telemetry.Focal_plane_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class GenericConverterTest {
    @Test
    public void ComCamDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-daq-monitor", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("comcam-daq-monitor-trending.ser");
        Assert.assertEquals((Object)"comcam-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-daq-monitor");
        HashMap<String, Class<Daq_monitor_StoreTelemetry>> classMap = new HashMap<String, Class<Daq_monitor_StoreTelemetry>>();
        classMap.put("CCCamera_comcam-daq-monitor_Store", Daq_monitor_StoreTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        assert (telemetry instanceof Daq_monitor_StoreTelemetry);
        Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
        Assert.assertEquals((double)966.367614746093, (double)dst.getCapacity(), (double)1.0E-5);
        Assert.assertEquals((double)778.7973022460938, (double)dst.getFreeSpace(), (double)1.0E-5);
        Assert.assertEquals((double)0.8059016986519337, (double)dst.getFreeFraction(), (double)1.0E-5);
    }

    @Test
    public void ComCamFocalPlaneTest2() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        String[] rebs = new String[]{"Reb0", "Reb1", "Reb2"};
        String[] groups = new String[]{"", "_aspicTemp", "_biasVolt", "_boardPower", "_ccdCurrent", "_rebTemp"};
        String fileName = "comcam-fp-default-trending.ser";
        StatusSubsystemData combinedData = GenericConverterTest.readData(fileName);
        Assert.assertEquals((Object)"comcam-fp", (Object)combinedData.getOriginAgentInfo().getName());
        for (String reb : rebs) {
            for (String group : groups) {
                fileName = String.format("comcam-fp-default_R22_%s%s-trending.ser", reb, group);
                StatusSubsystemData data = GenericConverterTest.readData(fileName);
                Assert.assertEquals((Object)"comcam-fp", (Object)data.getOriginAgentInfo().getName());
                GenericConverterTest.combineTelemetry(combinedData, data);
            }
        }
        Assert.assertEquals((long)638L, (long)((KeyValueDataList)combinedData.getSubsystemData()).getListOfKeyValueData().size());
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("CCCamera_comcam-fp_Reb", Focal_plane_RebTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Ccd", org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry.class);
        classMap.put("CCCamera_comcam-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Segment", Focal_plane_SegmentTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, combinedData);
        System.out.println(converted.size());
        Assert.assertEquals((long)4L, (long)converted.size());
        for (CameraTelemetry t : converted) {
            int length;
            if (t instanceof org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry) {
                org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry fpCCD = (org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry)t;
                length = fpCCD.getLocation().split(":").length;
                Assert.assertEquals((long)9L, (long)length);
                Assert.assertEquals((long)9L, (long)fpCCD.getGDV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getODV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getOGV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getRDV().length);
                Assert.assertEquals((long)9L, (long)fpCCD.getTemp().length);
                continue;
            }
            if (t instanceof Focal_plane_RebTelemetry) {
                Focal_plane_RebTelemetry fpREB = (Focal_plane_RebTelemetry)t;
                length = fpREB.getLocation().split(":").length;
                Assert.assertEquals((long)3L, (long)length);
                Assert.assertEquals((long)3L, (long)fpREB.getAnaI().length);
                Assert.assertEquals((long)3L, (long)fpREB.getAnaV().length);
                Assert.assertEquals((long)3L, (long)fpREB.getDigI().length);
                Assert.assertEquals((long)3L, (long)fpREB.getDigV().length);
                continue;
            }
            if (!(t instanceof Focal_plane_SegmentTelemetry)) continue;
            Focal_plane_SegmentTelemetry fpSeg = (Focal_plane_SegmentTelemetry)t;
            length = fpSeg.getLocation().split(":").length;
            Assert.assertEquals((long)144L, (long)length);
            Assert.assertEquals((long)144L, (long)fpSeg.getI().length);
        }
    }

    @Test
    public void AuxTelDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "daq_monitor", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("ats-daq-monitor-trending.ser");
        Assert.assertEquals((Object)"ats-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-daq-monitor");
        HashMap<String, Class<Daq_monitor_StoreTelemetry>> classMap = new HashMap<String, Class<Daq_monitor_StoreTelemetry>>();
        classMap.put("ATCamera_daq_monitor_Store", Daq_monitor_StoreTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        Assert.assertTrue((boolean)(telemetry instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
        Assert.assertEquals((double)322.12255859375, (double)dst.getCapacity(), (double)1.0E-5);
        Assert.assertEquals((double)314.9219665527344, (double)dst.getFreeSpace(), (double)1.0E-5);
        Assert.assertEquals((double)0.9776464210626838, (double)dst.getFreeFraction(), (double)1.0E-5);
    }

    @Test
    public void ComCamVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-vacuum-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-vacuum", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("comcam-vacuum-trending.ser");
        Assert.assertEquals((Object)"comcam-vacuum", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-vacuum");
        HashMap<String, Class<Vacuum_RtdsTelemetry>> classMap = new HashMap<String, Class<Vacuum_RtdsTelemetry>>();
        classMap.put("CCCamera_comcam-vacuum_Turbo", Vacuum_TurboTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold1", Vacuum_Cold1Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cold2", Vacuum_Cold2Telemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Cryo", Vacuum_CryoTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_VQMonitor", Vacuum_VQMonitorTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_IonPumps", Vacuum_IonPumpsTelemetry.class);
        classMap.put("CCCamera_comcam-vacuum_Rtds", Vacuum_RtdsTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)7L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            if (telemetry instanceof Vacuum_VQMonitorTelemetry) {
                Vacuum_VQMonitorTelemetry vqm = (Vacuum_VQMonitorTelemetry)telemetry;
                Assert.assertEquals((double)8.46E-8, (double)vqm.getVqmpressure(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_TurboTelemetry) {
                Vacuum_TurboTelemetry turbo = (Vacuum_TurboTelemetry)telemetry;
                Assert.assertEquals((double)12.0, (double)turbo.getPumpTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold1Telemetry) {
                Vacuum_Cold1Telemetry cold1 = (Vacuum_Cold1Telemetry)telemetry;
                Assert.assertEquals((double)-98.03, (double)cold1.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold2Telemetry) {
                Vacuum_Cold2Telemetry cold2 = (Vacuum_Cold2Telemetry)telemetry;
                Assert.assertEquals((double)-67.51, (double)cold2.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_CryoTelemetry) {
                Vacuum_CryoTelemetry cryo = (Vacuum_CryoTelemetry)telemetry;
                Assert.assertEquals((double)-150.31, (double)cryo.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_RtdsTelemetry) {
                Vacuum_RtdsTelemetry rtds = (Vacuum_RtdsTelemetry)telemetry;
                Assert.assertEquals((double)-58.86454f, (double)rtds.getTemperatureCold1(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_IonPumpsTelemetry) {
                Vacuum_IonPumpsTelemetry ionpumps = (Vacuum_IonPumpsTelemetry)telemetry;
                Assert.assertEquals((double)5008.63623, (double)ionpumps.getVoltage(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats", 0, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("ats-trending.ser");
        Assert.assertEquals((Object)"ats", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<VacuumTelemetry>, String> subSystemClasses = new HashMap<Class<VacuumTelemetry>, String>();
        subSystemClasses.put(VacuumTelemetry.class, "ats");
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats");
        HashMap<String, Class<VacuumTelemetry>> classMap = new HashMap<String, Class<VacuumTelemetry>>();
        classMap.put("ATCamera_ats", VacuumTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Assert.assertTrue((boolean)(converted.get(0) instanceof VacuumTelemetry));
        VacuumTelemetry vt = (VacuumTelemetry)converted.get(0);
        Assert.assertEquals((double)-94.1477, (double)vt.getTempCCD(), (double)1.0E-5);
        Assert.assertEquals((double)-114.7494, (double)vt.getTempColdPlate(), (double)1.0E-5);
        Assert.assertEquals((double)-140.4627, (double)vt.getTempCryoHead(), (double)1.0E-5);
        Assert.assertEquals((double)3.6E-6, (double)vt.getVacuum(), (double)1.0E-5);
        Assert.assertEquals((double)-94.15, (double)vt.getTempCCDSetPoint(), (double)1.0E-5);
    }

    @Test
    public void AuxTelPowerTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-power-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-power", 0, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("ats-power-trending.ser");
        Assert.assertEquals((Object)"ats-power", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-power");
        HashMap<String, Class<PowerTelemetry>> classMap = new HashMap<String, Class<PowerTelemetry>>();
        classMap.put("ATCamera_ats-power", PowerTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Assert.assertTrue((boolean)(converted.get(0) instanceof PowerTelemetry));
        PowerTelemetry pt = (PowerTelemetry)converted.get(0);
        Assert.assertEquals((double)5.25, (double)pt.getDigital_V(), (double)1.0E-5);
        Assert.assertEquals((double)665.5, (double)pt.getDigital_I(), (double)1.0E-5);
        Assert.assertEquals((double)7.2, (double)pt.getAnalog_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getClkhigh_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getClklow_V(), (double)1.0E-5);
        Assert.assertEquals((double)32.05, (double)pt.getOd_V(), (double)1.0E-5);
        Assert.assertEquals((double)10.0, (double)pt.getDphi_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getFan_V(), (double)1.0E-5);
    }

    @Test
    public void AuxTelFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-fp", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data1 = GenericConverterTest.readData("ats-fp-default_R00_RebW-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data1.getOriginAgentInfo().getName());
        StatusSubsystemData data2 = GenericConverterTest.readData("ats-fp-default_R00_RebW_rebTemp-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data2.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data2);
        StatusSubsystemData data3 = GenericConverterTest.readData("ats-fp-default_R00_RebW_aspicTemp-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data3.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data3);
        StatusSubsystemData data4 = GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data4.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data4);
        StatusSubsystemData data5 = GenericConverterTest.readData("ats-fp-default_R00_RebW_crVolt-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data5.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data5);
        StatusSubsystemData data6 = GenericConverterTest.readData("ats-fp-default-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data6.getOriginAgentInfo().getName());
        GenericConverterTest.combineTelemetry(data1, data6);
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        HashMap<String, Class<Focal_plane_RebTotalPowerTelemetry>> classMap = new HashMap<String, Class<Focal_plane_RebTotalPowerTelemetry>>();
        classMap.put("ATCamera_ats-fp_Ccd", Focal_plane_CcdTelemetry.class);
        classMap.put("ATCamera_ats-fp_Reb", org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry.class);
        classMap.put("ATCamera_ats-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data1);
        Assert.assertEquals((long)3L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry fpt;
            if (telemetry instanceof org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry) {
                fpt = (org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry)telemetry;
                Assert.assertEquals((double)362.0116882324219, (double)fpt.getRTDTemp()[0], (double)1.0E-5);
                Assert.assertEquals((double)28.5, (double)fpt.getTemp1()[0], (double)1.0E-5);
                Assert.assertEquals((double)29.5625, (double)fpt.getTemp2()[0], (double)1.0E-5);
                Assert.assertEquals((double)28.4375, (double)fpt.getTemp3()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.6875, (double)fpt.getTemp4()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.25, (double)fpt.getTemp5()[0], (double)1.0E-5);
                Assert.assertEquals((double)27.0625, (double)fpt.getTemp6()[0], (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicu_Temp0()[0], (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicl_Temp0()[0], (double)1.0E-5);
                Assert.assertEquals((double)5.275, (double)fpt.getDigV()[0], (double)1.0E-5);
                Assert.assertEquals((double)697.0, (double)fpt.getDigI()[0], (double)1.0E-5);
                Assert.assertEquals((double)7.2, (double)fpt.getAnaV()[0], (double)1.0E-5);
                Assert.assertEquals((double)345.0, (double)fpt.getAnaI()[0], (double)1.0E-5);
                Assert.assertEquals((double)12.025, (double)fpt.getClkHV()[0], (double)1.0E-5);
                Assert.assertEquals((double)31.25, (double)fpt.getClkHI()[0], (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV()[0], (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI()[0], (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV()[0], (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI()[0], (double)1.0E-5);
                Assert.assertEquals((double)7.49795625, (double)fpt.getPower()[0], (double)1.0E-5);
                Assert.assertEquals((Object)"R00RebW", (Object)fpt.getLocation());
                Assert.assertEquals((double)-11.97925537109375, (double)fpt.getClkLV()[0], (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Focal_plane_RebTotalPowerTelemetry) {
                fpt = (Focal_plane_RebTotalPowerTelemetry)telemetry;
                Assert.assertEquals((double)7.4979563, (double)fpt.getRebTotalPower(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Focal_plane_CcdTelemetry) {
                fpt = (Focal_plane_CcdTelemetry)telemetry;
                Assert.assertEquals((double)25.03779052734375, (double)fpt.getODV()[0], (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelFocalPlaneTest2() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-fp", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data1 = GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data1.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("ats-fp");
        HashMap<String, Class<Focal_plane_RebTotalPowerTelemetry>> classMap = new HashMap<String, Class<Focal_plane_RebTotalPowerTelemetry>>();
        classMap.put("ATCamera_ats-fp_Ccd", Focal_plane_CcdTelemetry.class);
        classMap.put("ATCamera_ats-fp_Reb", org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry.class);
        classMap.put("ATCamera_ats-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data1);
        Assert.assertEquals((long)1L, (long)converted.size());
    }

    @Test
    public void ComCamFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusSubsystemData data = GenericConverterTest.readData("comcam-fp-trending.ser");
        Assert.assertEquals((Object)"comcam-fp", (Object)data.getOriginAgentInfo().getName());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap<String, Class<Focal_plane_RebTelemetry>> classMap = new HashMap<String, Class<Focal_plane_RebTelemetry>>();
        classMap.put("CCCamera_comcam-fp_Reb", Focal_plane_RebTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Focal_plane_RebTelemetry fpTelemetry = (Focal_plane_RebTelemetry)converted.get(0);
        Assert.assertEquals((long)3L, (long)fpTelemetry.getHVBiasSwitch().length);
        Assert.assertEquals((long)3L, (long)fpTelemetry.getTemp1().length);
        Assert.assertEquals((long)3L, (long)fpTelemetry.getODI().length);
    }

    @Test
    public void ComCamFocalPlaneTest3() throws IOException, ClassNotFoundException, ReflectiveOperationException, ParserConfigurationException, TransformerException {
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("comcam-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "CCCamera", "comcam-fp", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        String fileName = "comcam-fp-default-trending.ser";
        StatusSubsystemData combinedData = GenericConverterTest.readData(fileName);
        Assert.assertEquals((Object)"comcam-fp", (Object)combinedData.getOriginAgentInfo().getName());
        Assert.assertEquals((long)2L, (long)((KeyValueDataList)combinedData.getSubsystemData()).getListOfKeyValueData().size());
        ArrayList<String> subSystems = new ArrayList<String>();
        subSystems.add("comcam-fp");
        HashMap<String, Class> classMap = new HashMap<String, Class>();
        classMap.put("CCCamera_comcam-fp_Reb", Focal_plane_RebTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Ccd", org.lsst.sal.cccamera.telemetry.Focal_plane_CcdTelemetry.class);
        classMap.put("CCCamera_comcam-fp_RebTotalPower", Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("CCCamera_comcam-fp_Segment", Focal_plane_SegmentTelemetry.class);
        GenericConverter converter = new GenericConverter(subSystems, classMap, mapping, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(salClassDescriptions, combinedData);
        Assert.assertEquals((long)1L, (long)converted.size());
    }

    public static StatusDataProviderDictionary readStatusDictionary(String fileName) throws ClassNotFoundException, IOException {
        Object readObject;
        try (InputStream in = GenericConverterTest.class.getResourceAsStream(fileName);
             ObjectInputStream ois = new ObjectInputStream(in);){
            readObject = ois.readObject();
        }
        Assert.assertTrue((boolean)(readObject instanceof StatusDataProviderDictionary));
        StatusDataProviderDictionary dictionary = (StatusDataProviderDictionary)readObject;
        return dictionary;
    }

    /*
     * Exception decompiling
     */
    public static StatusSubsystemData readData(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void combineTelemetry(StatusSubsystemData data1, StatusSubsystemData data2) {
        KeyValueDataList kvdl = (KeyValueDataList)data1.getSubsystemData();
        KeyValueDataList kvdl2 = (KeyValueDataList)data2.getSubsystemData();
        for (KeyValueData kvd : kvdl2.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
    }
}

