/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.messages.StatusConfigurationInfo;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.SummaryInfoConverter;
import org.lsst.sal.atcamera.event.FocalPlaneSummaryInfoEvent;

public class FocalPlaneConfigConverterTest {
    @Test
    public void comcamConfigConverterTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = FocalPlaneConfigConverterTest.class.getResourceAsStream("comcam-fp-config-info.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusConfigurationInfo));
            StatusConfigurationInfo sci = (StatusConfigurationInfo)readObject;
            Assert.assertEquals((Object)"FOCAL_PLANE", (Object)sci.getOriginAgentInfo().getAgentProperty("agentCategory"));
            Assert.assertEquals((Object)"comcam-fp", (Object)sci.getOriginAgentInfo().getName());
            ConfigurationInfo info = sci.getConfigurationInfo();
            SummaryInfoConverter converter = new SummaryInfoConverter(OCSBridgeConfig.Device.COMCAM);
            org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent convert = (org.lsst.sal.camera.event.FocalPlaneSummaryInfoEvent)converter.convert(info);
            Assert.assertEquals((Object)"R22:R22:R22:R22:R22:R22:R22:R22:R22", (Object)convert.getRaftBay());
            Assert.assertEquals((Object)"S00:S01:S02:S10:S11:S12:S20:S21:S22", (Object)convert.getCcdSlot());
            Assert.assertEquals((Object)"R22S00:R22S01:R22S02:R22S10:R22S11:R22S12:R22S20:R22S21:R22S22", (Object)convert.getCcdLocation());
        }
    }

    @Test
    public void auxtelConfigConverterTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = FocalPlaneConfigConverterTest.class.getResourceAsStream("ats-fp-config-info.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusConfigurationInfo));
            StatusConfigurationInfo sci = (StatusConfigurationInfo)readObject;
            Assert.assertEquals((Object)"FOCAL_PLANE", (Object)sci.getOriginAgentInfo().getAgentProperty("agentCategory"));
            Assert.assertEquals((Object)"ats-fp", (Object)sci.getOriginAgentInfo().getName());
            ConfigurationInfo info = sci.getConfigurationInfo();
            SummaryInfoConverter converter = new SummaryInfoConverter(OCSBridgeConfig.Device.AUXTEL);
            FocalPlaneSummaryInfoEvent convert = (FocalPlaneSummaryInfoEvent)converter.convert(info);
            Assert.assertEquals((Object)"R00", (Object)convert.getRaftBay());
            Assert.assertEquals((Object)"S00", (Object)convert.getCcdSlot());
            Assert.assertEquals((Object)"R00S00", (Object)convert.getCcdLocation());
        }
    }
}

