/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.EndLoadFilterEvent;
import org.lsst.sal.camera.event.EndRotateCarouselEvent;
import org.lsst.sal.camera.event.EndSetFilterEvent;
import org.lsst.sal.camera.event.EndUnloadFilterEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.event.StartLoadFilterEvent;
import org.lsst.sal.camera.event.StartRotateCarouselEvent;
import org.lsst.sal.camera.event.StartSetFilterEvent;
import org.lsst.sal.camera.event.StartUnloadFilterEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class FilterChangeTest
extends BridgeTest {
    @Test
    public void failTest() {
        try {
            this.ocsBridge.execute((CameraCommand)new SetFilterCommand("g-9"));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void filterChange() {
        this.enabler.goToEnable(this.ocsBridge);
        assert (this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new SetFilterCommand("g-9"));
        System.out.println(tl.getFullStateHistory());
        Assert.assertEquals((long)6L, (long)tl.getCalls());
        tl.printFinalStates("FilterChangeTest:filterChange()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{FilterChanger.FilterState.LOADED}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        List<Enum> states = fsh.getStates();
        fsh.printStateHistory("FilterChangeTest:filterChange()");
        Assert.assertEquals((long)fsh.getStates().size(), (long)6L);
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, FilterChanger.FilterState.ROTATING, FilterChanger.FilterState.LOADING, FilterChanger.FilterState.LOADED, CCSCommandStateEvent.CCSCommandState.IDLE}));
        List<CameraEvent> cameraEvents = this.executor.getEventList();
        this.executor.printEventList("FilterChangeTest:filterChange()");
        Assert.assertEquals((long)6L, (long)cameraEvents.size());
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event1 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"g-9", (Object)event1.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event1.getFilterName());
        System.out.println("************************************* ");
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new SetFilterCommand("NONE"));
        List<CameraEvent> eventsForG9ToNONE = this.executor.getEventList();
        this.executor.printEventList("FilterChangeTest:filterChange() G9->NONE");
        Assert.assertEquals((long)eventsForG9ToNONE.size(), (long)4L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event0 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"NONE", (Object)event0.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event0.getFilterName());
        System.out.println("************************************* ");
        System.out.println(" \n");
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new SetFilterCommand("NONE"));
        List<CameraEvent> eventsForNONEToNONE = this.executor.getEventList();
        this.executor.printEventList("FilterChangeTest:filterChange() NONE->NONE");
        Assert.assertEquals((long)eventsForNONEToNONE.size(), (long)2L);
        Assert.assertFalse((boolean)this.executor.containsInOrder(StartRotateCarouselEvent.class));
        Assert.assertFalse((boolean)this.executor.containsInOrder(EndRotateCarouselEvent.class));
        assert (this.executor.containsInOrder(StartSetFilterEvent.class, EndSetFilterEvent.class));
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new SetFilterCommand("r-1"));
        List<CameraEvent> eventsForNONEToR1 = this.executor.getEventList();
        this.executor.printEventList("FilterChangeTest:filterChange() NONE->r-1");
        Assert.assertEquals((long)eventsForNONEToR1.size(), (long)6L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event2 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"r-1", (Object)event2.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event2.getFilterName());
        System.out.println("************************************* ");
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new SetFilterCommand("u-10"));
        List<CameraEvent> eventsForR1ToU10 = this.executor.getEventList();
        this.executor.printEventList("FilterChangeTest:filterChange() r-1->u-10");
        Assert.assertEquals((long)eventsForR1ToU10.size(), (long)8L);
        Assert.assertTrue((boolean)this.executor.containsInOrder(StartSetFilterEvent.class, StartUnloadFilterEvent.class, EndUnloadFilterEvent.class, StartRotateCarouselEvent.class, EndRotateCarouselEvent.class, StartLoadFilterEvent.class, EndLoadFilterEvent.class, EndSetFilterEvent.class));
        System.out.println("************************************* ");
        System.out.println("FilterChangeTest:changeFilter(): List of Filter Names");
        StartSetFilterEvent event3 = this.executor.getEventOfClass(StartSetFilterEvent.class, 0);
        Assert.assertEquals((Object)"u-10", (Object)event3.getFilterName());
        System.out.println("FilterChangeTest:filterChange filter  " + event3.getFilterName());
        System.out.println("************************************* ");
        System.out.println(" \n");
    }
}

