package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import static org.lsst.ccs.subsystem.ocsbridge.sim.Shutter.MOVE_TIME;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

/**
 * Shutter simulation for use with MCM
 * @author tonyj
 */
public class ShutterSimulation implements ShutterInterface {

    private final CCS ccs;
    private final State shutterState;

    ShutterSimulation(CCS ccs, State shutterState) {
        this.ccs = ccs;
        this.shutterState = shutterState;
    }

    @Override
    public void start(String configName) throws ExecutionException {
        // NOOP
    }

    @Override
    public void expose(Duration exposureTime) throws ExecutionException {
        shutterState.checkState(ShutterState.CLOSED);
        shutterState.setState(Shutter.ShutterState.OPENING);
        Duration time = MOVE_TIME;
        // TODO: This does not correctly handle the case when both blades move at once
        ccs.schedule(time, () -> {
            shutterState.setState(Shutter.ShutterState.OPEN);
        });
        time = time.plus(exposureTime);
        ccs.schedule(time, () -> {
            shutterState.setState(Shutter.ShutterState.CLOSING);
        });
        time = time.plus(MOVE_TIME);
        ccs.schedule(time, () -> {
            shutterState.setState(Shutter.ShutterState.CLOSED);
        });
    }

    @Override
    public void open() throws ExecutionException {
        shutterState.setState(Shutter.ShutterState.OPENING);
        ccs.schedule(MOVE_TIME, () -> {
            shutterState.setState(Shutter.ShutterState.OPEN);
        });
    }

    @Override
    public void close() throws ExecutionException {
        shutterState.setState(Shutter.ShutterState.CLOSING);
        ccs.schedule(MOVE_TIME, () -> {
            shutterState.setState(Shutter.ShutterState.CLOSED);
        });
    }

}
