package org.lsst.ccs.subsystem.ocsbridge;

import org.lsst.ccs.subsystem.ocsbridge.util.EventListener;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraStateChangeEvent;

/**
 * This interface represents the information the ToyOCSGIO requires to be able
 * to interact with the OCS bridge (either directly, or via SAL).
 * This will also be used by test suites designed to be able to work over the 
 * OCS buses or locally.
 * 
 * @author tonyj
 */
interface GUILayer {

    public void execute(CameraCommand cmd);
    /**
     * Currently sending CCS commands to the OCS Bridge
     * is not supported when running over SAL. 
     * @return <code>true</code> if sending CCS commands is supported.
     */
    public boolean supportsCCSCommands();
    public void execute(CCSCommand command);
    
    void addEventListener(EventListener<CameraEvent> cel);
    void removeEventListener(EventListener<CameraEvent> cel);
    
    void addStateChangeListener(EventListener<CameraStateChangeEvent> cscl);
    void removeStateChangeListener(EventListener<CameraStateChangeEvent> cscl);

}
