/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.OCSBridgeConfig;
import org.lsst.ccs.subsystem.ocsbridge.OCSTelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.TelemetrySender;
import org.lsst.ccs.subsystem.ocsbridge.sim.GenericConverterTest;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

public class TelemetrySenderTest {
    @Test
    public void auxTelTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((OCSBridgeConfig.Device)OCSBridgeConfig.Device.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-daq-monitor-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats-daq-monitor", 1, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        StatusDataProviderDictionary dictionary2 = GenericConverterTest.readStatusDictionary("ats-fp-status-dictionary.ser");
        SALClassDescriptionMaker maker2 = new SALClassDescriptionMaker(dictionary2.getDataProviderDictionary(), "ATCamera", "ats-fp", 1, mapping, "MONITORING", "trending");
        salClassDescriptions.putAll(maker2.getSALClassDescriptions());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-daq-monitor-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_aspicTemp-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_crVolt-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_rebTemp-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default-trending.ser"));
        Assert.assertEquals((long)4L, (long)callCount.get());
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser"));
        Assert.assertEquals((long)4L, (long)callCount.get());
        Thread.sleep(20000L);
        Assert.assertEquals((long)8L, (long)callCount.get());
    }

    @Test
    public void auxTelVacuumTelemetryTest() throws IOException, ClassNotFoundException, InterruptedException {
        AtomicInteger callCount = new AtomicInteger(0);
        OCSTelemetrySender ocs = t -> callCount.incrementAndGet();
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        TelemetrySender sender = TelemetrySender.create((OCSBridgeConfig.Device)OCSBridgeConfig.Device.AUXTEL, (OCSTelemetrySender)ocs, (ScheduledExecutorService)executor);
        Mapping mapping = Mapping.defaultMapping();
        StatusDataProviderDictionary dictionary = GenericConverterTest.readStatusDictionary("ats-status-dictionary.ser");
        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary.getDataProviderDictionary(), "ATCamera", "ats", 0, mapping, "MONITORING", "trending");
        Map salClassDescriptions = maker.getSALClassDescriptions();
        sender.send(salClassDescriptions, GenericConverterTest.readData("ats-trending.ser"));
        Assert.assertEquals((long)1L, (long)callCount.get());
    }
}

