package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription.LocationVariable;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription.PatternMatchedSALVariable;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/**
 * A version of XMLMaker which uses SALClasDescriptionMaker instead of
 * ProcessedInfoMaker
 *
 * @author farrukh
 */
public class XMLMaker2 {

    private final boolean verbose;
    private final UnitConverter unitConverter = new UnitConverter();
    private final TypeConverter typeConverter = new TypeConverter();

    public enum SALType {
        TELEMETRY("Telemetry"), SETTINGS_APPLIED("Event");

        private final String type;

        SALType(String type) {
            this.type = type;
        }

        String getSchema() {
            return type;
        }

        private String getClassNameAppendage() {
            return this == SETTINGS_APPLIED ? "SettingsApplied" : "";
        }

    }

    XMLMaker2(boolean verbose) {
        this.verbose = verbose;
    }

    Document createDocument(SALType salType) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement("SAL" + salType.getSchema() + "Set");
        rootEle.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance",
                "xsi:noNamespaceSchemaLocation", "https://raw.githubusercontent.com/lsst-ts/ts_xml/develop/schema/SAL" + salType.getSchema() + "Set.xsd");
        dom.appendChild(rootEle);
        return dom;
    }

    void addXMLFromDataProviderDictionary(Document document, StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, "MONITORING", "Telemetry");
        final Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        generateXML(document, subsystemName, componentName, SALType.TELEMETRY, salClassDescriptions, level);
    }

    void addXMLFromConfigDictionary(Document document, StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        final Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        generateXML(document, subsystemName, componentName, SALType.SETTINGS_APPLIED, salClassDescriptions, level);
    }

    Document makeXMLFromDataProviderDictionary(StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALType type = SALType.TELEMETRY;
        Document document = createDocument(type);
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, "MONITORING", "Telemetry");
        final Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        generateXML(document, subsystemName, componentName, type, salClassDescriptions, level);
        return document;
    }

    Document makeXMLFromConfigDictionary(StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        // last argument infoMaker.getPatternSubstitutionRecord()
        SALType type = SALType.SETTINGS_APPLIED;
        Document document = createDocument(type);
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        generateXML(document, subsystemName, componentName, SALType.SETTINGS_APPLIED, infoMaker.getSALClassDescriptions(), level);
        return document;
    }

    // Document generateXML(String subsystemName, String componentName, String salType, Map<String, List<ProcessedInfo>> classesInfo, Set<String> recordPatternSubstitution) throws ParserConfigurationException {
    private void generateXML(Document dom, String subsystemName, String componentName, SALType salType, Map<String, SALClassDescription> salClassDescriptions, int level) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {

        Element rootEle = (Element) dom.getChildNodes().item(0);
        // process salType - this is telemetry or event for now - 
        // 
        String classNameAppendage = salType.getClassNameAppendage();

        // finalReprocessedClassInfo was produced in the loop above.
        if (verbose) {
            for (Map.Entry<String, SALClassDescription> key : salClassDescriptions.entrySet()) {
                System.out.println(" Class Name " + key.getKey());
                System.out.println(key.getValue());
            }
        }

        // ******* So if everything is moved to ProcessedInfoMaker or a similar class - then we need it to return finalReprocessedClassInfo which is directly below ... April 14. 2021 ****
        for (Map.Entry<String, SALClassDescription> entry : salClassDescriptions.entrySet()) {

            //System.out.println("<" + "SAL" + salType + ">");
            // really need subsystem name AND key.getkey() ? I think if you are making the classname you can get rid of one 
            //      System.out.println("<EFDB_Topic>" + key.getKey().trim() + "_" + salType + "</EFDB_Topic>");
            // this is being fixed elsewhere and so following line is redundant 
            if (subsystemName.contains("comcam")) {
                subsystemName = "CCCamera";
            }
            String className = entry.getKey().trim();
            int firstUnderScore = className.indexOf("_");
            char[] charArray = className.toCharArray();
            charArray[firstUnderScore + 1] = Character.toLowerCase(charArray[firstUnderScore + 1]);
            className = String.valueOf(charArray);

            /* TODO: LCOBM-38, remove me when AgentStatusAggregator is removed from all subsystems */
            if (className.contains("StatusAggregator")) {
                continue;
            }

            // to tackle SettingsApplied - currently unfilled unless we have SettingsApplied - but there could be others
            if (className.contains("focalplane")) {
                className = className.replace("focalplane", "focalPlane");
            }
            if (!classNameAppendage.isEmpty()) {
                className = className + classNameAppendage;
            }
            
            className = className.replace("-", "_");
            /*
            if(classNameAppendage.contains("SettingsApplied")){
               className = subsystemName + "_logevent_" + className;}
             */

            String text = "Created by xmlmaker2 for subsystem " + subsystemName + " class " + className + " using level " + level;
            final String category = entry.getValue().getCategory();
            if (category != null && !category.isEmpty()) {
                text = text + " for category " + category;
            }
            Comment comment = dom.createComment(text);
            rootEle.appendChild(comment);
            Comment comment2 = dom.createComment(String.join("", Collections.nCopies(text.length(), "=")));
            rootEle.appendChild(comment2);

            Element salElement = dom.createElement("SAL" + salType.getSchema());
            rootEle.appendChild(salElement);

            Element subsystemElement = dom.createElement("Subsystem");
            subsystemElement.setTextContent(subsystemName);
            salElement.appendChild(subsystemElement);

            //System.out.println("<EFDB_Topic>" + className + "</EFDB_Topic>");
            Element topicElement = dom.createElement("EFDB_Topic");
            topicElement.setTextContent(className);
            salElement.appendChild(topicElement);
            // SAL will add priority 
            //just for SettingsApplied or also for Event ?
            if (classNameAppendage.contains("SettingsApplied")) {
                // add version                
                Element version = dom.createElement("item");
                salElement.appendChild(version);
                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent("version");
                version.appendChild(efdbName);
                Element desc = dom.createElement("Description");
                desc.setTextContent("Version number of these settings");
                version.appendChild(desc);
                Element type = dom.createElement("IDL_Type");
                type.setTextContent("long");
                version.appendChild(type);
                Element units = dom.createElement("Units");
                units.setTextContent("unitless");
                version.appendChild(units);
                Element count = dom.createElement("Count");
                count.setTextContent("1");
                version.appendChild(count);
            }

            // location 
            for (SALClassDescription.SALVariable var : entry.getValue().getVariables()) {
              //  int counts = var.getCount();
                int counts = entry.getValue().getSharedLocationCount(var);
                
                
                // temporary printout - to be removed as soon as we know all is working with the xml-based class generation
                System.out.println(" ***** Begin XMLMaker2 Location Max Array /PLEASE REMOVE PRINTOUT AFTER Testing  ***** ");
                System.out.println(" XMLMaker2 Are we getting the maximum array size for the same location ? ");
                System.out.println( " Variable name " + var.getVariableName() + " Count " + entry.getValue().getSharedLocationCount(var));
                System.out.println(" ***** End XMLMaker2 Location Max Array ***** ");

                String description = var.getDescription() == null ? "MISSING" : var.getDescription();
                int backslash = description.indexOf('\\');
                if (backslash > 0) {
                    description = description.substring(backslash + 1);
                }

                String type = typeConverter.xmlType(var.getType());

                if (var.getUnits() != null) {
                    // TODO: LCOBM-39 -- Remove this
                    if (var.getUnits().equalsIgnoreCase("DAC Counts")) {
                        continue;
                    }
                }

                String variableName = var.getVariableName();
                if (variableName.contains("_")) {

                    String temp = "";
                    String[] splitVariable = variableName.split("_");
                    splitVariable[0] = splitVariable[0].toLowerCase();

                    for (int i = 0; i <= splitVariable.length - 1; i++) {
                        temp += splitVariable[i] + "_";
                    }

                    if (temp.charAt(temp.length() - 1) == '_') {
                        temp = temp.substring(0, temp.length() - 1);
                    }

                    variableName = temp;
                } else if (variableName.length() > 1) {
                    variableName = variableName.substring(0, 1).toLowerCase() + variableName.substring(1);
                } else {
                    variableName = variableName.toLowerCase();
                }

                // TODO: LCOBM-39 More bogus rafts settings
                if ("Rafts".equals(category)) {
                    if (variableName.equals("id") || variableName.equals("useScienceCCD")) {
                        continue;
                    }
                }

                // TODO: LCOBM-40 Temporary special handling of dbandHi, dbandLo
                if (variableName.endsWith("dbandHi")) {
                    variableName = variableName.replace("dbandHi", "warnHi");
                } else if (variableName.endsWith("dbandLo")) {
                    variableName = variableName.replace("dbandLo", "warnLo");
                }

                // Some variables contain illegal character -, change to _
                variableName = variableName.replace('-', '_');
                
                // Variable name cannot begin with digit
                if (Character.isDigit(variableName.charAt(0))) {
                    variableName = "n_"+variableName;
                }

                if (var instanceof PatternMatchedSALVariable) {
                    PatternMatchedSALVariable pmsv = (PatternMatchedSALVariable) var;
                    LocationVariable locationVariable = pmsv.getLocationVariable();
                    Comment locationComment = dom.createComment("CCSMETA: Array "+variableName+" indexed by "+locationVariable.getVariableName());
                    salElement.appendChild(locationComment);
                }               
                Element item = dom.createElement("item");
                salElement.appendChild(item);

                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent(variableName);
                item.appendChild(efdbName);

                if (var.getUnits() != null) {
                    if (var.getUnits().toLowerCase().contains("rpm")) {
                        description = description + " (RPM)";
                    }
                }

                Element desc = dom.createElement("Description");
                desc.setTextContent(description);
                item.appendChild(desc);

                Element idlType = dom.createElement("IDL_Type");
                idlType.setTextContent(type);
                item.appendChild(idlType);
                String ccsUnits = var.getUnits();
                String salUnits = unitConverter.convertCCSUnitToSALUnit(ccsUnits);
                Element unitsElement = dom.createElement("Units");
                unitsElement.setTextContent(salUnits);
                item.appendChild(unitsElement);
                if (var instanceof PatternMatchedSALVariable && counts==1) {
                    Element isJavaArray = dom.createElement("IsJavaArray");
                    isJavaArray.setTextContent("yes");
                    item.appendChild(isJavaArray);                    
                }
                Element countElement = dom.createElement("Count");
                countElement.setTextContent(String.valueOf(counts));
                item.appendChild(countElement);
            }

        }
    }

    private String cleanCapitalize(String inString) {
        String output = inString;
        output = output.toLowerCase();
        output = output.substring(0, 1).toUpperCase() + output.substring(1);
        output = output.trim();
        return output;
    }

    /**
     * Write the XML document to a file
     *
     * @param output The location to write the output
     * @param dom The XML document
     * @throws TransformerConfigurationException
     * @throws TransformerException
     */
    void writeXML(StreamResult output, Document dom) throws TransformerConfigurationException, TransformerException {
        final TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer tr = transformerFactory.newTransformer();
        tr.setOutputProperty(OutputKeys.INDENT, "yes");
        tr.setOutputProperty(OutputKeys.METHOD, "xml");
        tr.setOutputProperty(OutputKeys.ENCODING, "UTF-8");
        // This works with jdk8, but perhaps not later JDK versions?
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        // send DOM to file
        tr.transform(new DOMSource(dom), output);
    }

}
