/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.utilities.scheduler;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class BasicThreadFactory
implements ThreadFactory {
    private static final AtomicInteger FACTORY_NUMBER = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;

    BasicThreadFactory(String name, ThreadGroup group, boolean daemon) {
        SecurityManager s;
        this.group = group == null ? ((s = System.getSecurityManager()) != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup()) : group;
        this.namePrefix = name == null ? "BasicThreadFactory-" + FACTORY_NUMBER.getAndIncrement() + "-" : name + "-";
        this.daemon = false;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon() != this.daemon) {
            t.setDaemon(this.daemon);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

