package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;

/**
 * Interface to be implemented by all shutters, simulated and real
 * @author tonyj
 */
public interface ShutterInterface {
    /**
     * Start and lock the shutter, with the specified configuration
     * @param configName 
     * @throws java.util.concurrent.ExecutionException 
     */
    void start(String configName) throws ExecutionException;
    
    void expose(Duration exposeTime) throws ExecutionException;

    void open() throws ExecutionException;

    void close() throws ExecutionException;
}
