package org.lsst.ccs.subsystem.ocsbridge;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.DataProviderDictionary;
import org.lsst.ccs.commons.annotations.LookupField;
import org.lsst.ccs.framework.HasLifecycle;
import org.lsst.ccs.services.DataProviderDictionaryService;
import org.lsst.ccs.services.DataProviderDictionaryService.DataProviderDictionaryEvent.EventType;
import org.lsst.ccs.services.DataProviderDictionaryService.DataProviderDictionaryListener;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;

/**
 *
 * @author tonyj
 */
public class DictionaryProvider implements HasLifecycle {

    private static final Logger LOG = Logger.getLogger(DictionaryProvider.class.getName());

    @LookupField(strategy = LookupField.Strategy.TREE)
    private DataProviderDictionaryService dpdService;

    private final Listener listener = new Listener();
    private final Map<String, SALClassDescription> salClassDescriptions = new HashMap<>();

    @Override
    public void start() {
        dpdService.addDataProviderDictionaryListener(listener);
    }

    Map<String, SALClassDescription> getStatusClassDescriptions() {
        return salClassDescriptions;
    }

    private class Listener implements DataProviderDictionaryListener {

        Mapping mapping = Mapping.defaultMapping();
        
        @Override
        public void dataProviderDictionaryUpdate(DataProviderDictionaryService.DataProviderDictionaryEvent evt) {
            try {
                if (evt.getEventType() == EventType.ADDED) {
                    AgentInfo.AgentType type = evt.getAgentInfo().getType();
                    if (type == AgentInfo.AgentType.WORKER || type == AgentInfo.AgentType.SERVICE) {
                        String name = evt.getAgentInfo().getName();
                        DataProviderDictionary dictionary = evt.getDictionary();
                        SALClassDescriptionMaker maker = new SALClassDescriptionMaker(dictionary, "CCCamera", name, 1, mapping, "MONITORING", "trending");
                        salClassDescriptions.putAll(maker.getSALClassDescriptions());
                        LOG.log(Level.INFO, "Added dictionary for {0}", name);
                    }
                }
            } catch (Throwable t) {
                LOG.log(Level.SEVERE, "Exception adding dictionary", t);
            }
        }
    }
}

