package org.lsst.ccs.subsystem.ocsbridge;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;

/**
 *
 * @author tonyj
 */
public class AuxTelTelemetrySender extends TelemetrySender {

    private final GenericConverter converter;

    public AuxTelTelemetrySender(OCSTelemetrySender sender, ScheduledExecutorService scheduler) {
        super(sender, scheduler);
        // Map is what appears on the bus as key, on the right we have the argument 
        Map<String, String> nameChange = new HashMap<>();
        
        List<String> subSystems = new ArrayList<>();
        subSystems.add("ats-fp");
        subSystems.add("ats-daq-monitor");
        subSystems.add("ats");
        subSystems.add("ats-power");

        Map<String, Class> classMap = new HashMap<>();
        
        classMap.put("ATCamera_ats-fp_Ccd", org.lsst.sal.camera.telemetry.Focal_plane_CcdTelemetry.class);
        classMap.put("ATCamera_ats-fp_Reb", org.lsst.sal.camera.telemetry.Focal_plane_RebTelemetry.class);
        classMap.put("ATCamera_ats-fp_RebTotalPower", org.lsst.sal.camera.telemetry.Focal_plane_RebTotalPowerTelemetry.class);
        classMap.put("ATCamera_ats-fp_Segment", org.lsst.sal.camera.telemetry.Focal_plane_SegmentTelemetry.class);

        classMap.put("ATCamera_daq_monitor_Store", Daq_monitor_StoreTelemetry.class);
        classMap.put("ATCamera_ats", org.lsst.sal.atcamera.telemetry.VacuumTelemetry.class);
        classMap.put("ATCamera_ats-power", org.lsst.sal.atcamera.telemetry.PowerTelemetry.class);

        Mapping mapping = Mapping.defaultMapping();
        
        converter = new GenericConverter(subSystems, classMap, mapping, nameChange, Collections.EMPTY_MAP);
    }


    @Override
    GenericConverter getConverter() {
        return converter;
    }

}
