/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.xml;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.lsst.ccs.bus.data.DataProviderInfo;
import org.lsst.ccs.bus.messages.StatusDataProviderDictionary;
import org.lsst.ccs.subsystem.ocsbridge.xml.Mapping;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescription;
import org.lsst.ccs.subsystem.ocsbridge.xml.SALClassDescriptionMaker;
import org.lsst.ccs.subsystem.ocsbridge.xml.TypeConverter;
import org.lsst.ccs.subsystem.ocsbridge.xml.UnitConverter;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLMaker2 {
    private final boolean verbose;
    private final UnitConverter unitConverter = new UnitConverter();
    private final TypeConverter typeConverter = new TypeConverter();

    XMLMaker2(boolean verbose) {
        this.verbose = verbose;
    }

    Document createDocument(SALType salType) throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document dom = db.newDocument();
        Element rootEle = dom.createElement("SAL" + salType.getSchema() + "Set");
        rootEle.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:noNamespaceSchemaLocation", "https://raw.githubusercontent.com/lsst-ts/ts_xml/develop/schema/SAL" + salType.getSchema() + "Set.xsd");
        dom.appendChild(rootEle);
        return dom;
    }

    void addXMLFromDataProviderDictionary(Document document, StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, "MONITORING", "Telemetry");
        Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        this.generateXML(document, subsystemName, componentName, SALType.TELEMETRY, salClassDescriptions, level);
    }

    void addXMLFromConfigDictionary(Document document, StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        this.generateXML(document, subsystemName, componentName, SALType.SETTINGS_APPLIED, salClassDescriptions, level);
    }

    Document makeXMLFromDataProviderDictionary(StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws ParserConfigurationException, TransformerException {
        SALType type = SALType.TELEMETRY;
        Document document = this.createDocument(type);
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, "MONITORING", "Telemetry");
        Map<String, SALClassDescription> salClassDescriptions = infoMaker.getSALClassDescriptions();
        this.generateXML(document, subsystemName, componentName, type, salClassDescriptions, level);
        return document;
    }

    Document makeXMLFromConfigDictionary(StatusDataProviderDictionary info, String subsystemName, String componentName, int level, Mapping mapping) throws IOException, ClassNotFoundException, ParserConfigurationException, TransformerException {
        SALType type = SALType.SETTINGS_APPLIED;
        Document document = this.createDocument(type);
        SALClassDescriptionMaker infoMaker = new SALClassDescriptionMaker(info.getDataProviderDictionary(), subsystemName, componentName, level, mapping, DataProviderInfo.Type.CONFIGURATION.name(), "SettingsApplied");
        this.generateXML(document, subsystemName, componentName, SALType.SETTINGS_APPLIED, infoMaker.getSALClassDescriptions(), level);
        return document;
    }

    private void generateXML(Document dom, String subsystemName, String componentName, SALType salType, Map<String, SALClassDescription> salClassDescriptions, int level) throws ParserConfigurationException, TransformerConfigurationException, TransformerException {
        Element rootEle = (Element)dom.getChildNodes().item(0);
        String classNameAppendage = salType.getClassNameAppendage();
        if (this.verbose) {
            for (Map.Entry<String, SALClassDescription> key : salClassDescriptions.entrySet()) {
                System.out.println(" Class Name " + key.getKey());
                System.out.println(key.getValue());
            }
        }
        for (Map.Entry<String, SALClassDescription> entry : salClassDescriptions.entrySet()) {
            if (subsystemName.contains("comcam")) {
                subsystemName = "CCCamera";
            }
            String className = entry.getKey().trim();
            int firstUnderScore = className.indexOf("_");
            char[] charArray = className.toCharArray();
            charArray[firstUnderScore + 1] = Character.toLowerCase(charArray[firstUnderScore + 1]);
            className = String.valueOf(charArray);
            if (className.contains("StatusAggregator")) continue;
            if (className.contains("focalplane")) {
                className = className.replace("focalplane", "focalPlane");
            }
            if (!classNameAppendage.isEmpty()) {
                className = className + classNameAppendage;
            }
            className = className.replace("-", "_");
            String text = "Created by xmlmaker2 for subsystem " + subsystemName + " class " + className + " using level " + level;
            String category = entry.getValue().getCategory();
            if (category != null && !category.isEmpty()) {
                text = text + " for category " + category;
            }
            Comment comment = dom.createComment(text);
            rootEle.appendChild(comment);
            Comment comment2 = dom.createComment(String.join((CharSequence)"", Collections.nCopies(text.length(), "=")));
            rootEle.appendChild(comment2);
            Element salElement = dom.createElement("SAL" + salType.getSchema());
            rootEle.appendChild(salElement);
            Element subsystemElement = dom.createElement("Subsystem");
            subsystemElement.setTextContent(subsystemName);
            salElement.appendChild(subsystemElement);
            Element topicElement = dom.createElement("EFDB_Topic");
            topicElement.setTextContent(className);
            salElement.appendChild(topicElement);
            if (classNameAppendage.contains("SettingsApplied")) {
                Element version = dom.createElement("item");
                salElement.appendChild(version);
                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent("version");
                version.appendChild(efdbName);
                Element desc = dom.createElement("Description");
                desc.setTextContent("Version number of these settings");
                version.appendChild(desc);
                Element type = dom.createElement("IDL_Type");
                type.setTextContent("long");
                version.appendChild(type);
                Element units = dom.createElement("Units");
                units.setTextContent("unitless");
                version.appendChild(units);
                Element count = dom.createElement("Count");
                count.setTextContent("1");
                version.appendChild(count);
            }
            for (SALClassDescription.SALVariable var : entry.getValue().getVariables()) {
                int counts = entry.getValue().getSharedLocationCount(var);
                System.out.println(" ***** Begin XMLMaker2 Location Max Array /PLEASE REMOVE PRINTOUT AFTER Testing  ***** ");
                System.out.println(" XMLMaker2 Are we getting the maximum array size for the same location ? ");
                System.out.println(" Variable name " + var.getVariableName() + " Count " + entry.getValue().getSharedLocationCount(var));
                System.out.println(" ***** End XMLMaker2 Location Max Array ***** ");
                String description = var.getDescription() == null ? "MISSING" : var.getDescription();
                int backslash = description.indexOf(92);
                if (backslash > 0) {
                    description = description.substring(backslash + 1);
                }
                String type = this.typeConverter.xmlType(var.getType());
                if (var.getUnits() != null && var.getUnits().equalsIgnoreCase("DAC Counts")) continue;
                String variableName = var.getVariableName();
                if (variableName.contains("_")) {
                    String temp = "";
                    String[] splitVariable = variableName.split("_");
                    splitVariable[0] = splitVariable[0].toLowerCase();
                    for (int i = 0; i <= splitVariable.length - 1; ++i) {
                        temp = temp + splitVariable[i] + "_";
                    }
                    if (temp.charAt(temp.length() - 1) == '_') {
                        temp = temp.substring(0, temp.length() - 1);
                    }
                    variableName = temp;
                } else {
                    variableName = variableName.length() > 1 ? variableName.substring(0, 1).toLowerCase() + variableName.substring(1) : variableName.toLowerCase();
                }
                if ("Rafts".equals(category) && (variableName.equals("id") || variableName.equals("useScienceCCD"))) continue;
                if (variableName.endsWith("dbandHi")) {
                    variableName = variableName.replace("dbandHi", "warnHi");
                } else if (variableName.endsWith("dbandLo")) {
                    variableName = variableName.replace("dbandLo", "warnLo");
                }
                variableName = variableName.replace('-', '_');
                if (Character.isDigit(variableName.charAt(0))) {
                    variableName = "n_" + variableName;
                }
                if (var instanceof SALClassDescription.PatternMatchedSALVariable) {
                    SALClassDescription.PatternMatchedSALVariable pmsv = (SALClassDescription.PatternMatchedSALVariable)var;
                    SALClassDescription.LocationVariable locationVariable = pmsv.getLocationVariable();
                    Comment locationComment = dom.createComment("CCSMETA: Array " + variableName + " indexed by " + locationVariable.getVariableName());
                    salElement.appendChild(locationComment);
                }
                Element item = dom.createElement("item");
                salElement.appendChild(item);
                Element efdbName = dom.createElement("EFDB_Name");
                efdbName.setTextContent(variableName);
                item.appendChild(efdbName);
                if (var.getUnits() != null && var.getUnits().toLowerCase().contains("rpm")) {
                    description = description + " (RPM)";
                }
                Element desc = dom.createElement("Description");
                desc.setTextContent(description);
                item.appendChild(desc);
                Element idlType = dom.createElement("IDL_Type");
                idlType.setTextContent(type);
                item.appendChild(idlType);
                String ccsUnits = var.getUnits();
                String salUnits = this.unitConverter.convertCCSUnitToSALUnit(ccsUnits);
                Element unitsElement = dom.createElement("Units");
                unitsElement.setTextContent(salUnits);
                item.appendChild(unitsElement);
                if (var instanceof SALClassDescription.PatternMatchedSALVariable && counts == 1) {
                    Element isJavaArray = dom.createElement("IsJavaArray");
                    isJavaArray.setTextContent("yes");
                    item.appendChild(isJavaArray);
                }
                Element countElement = dom.createElement("Count");
                countElement.setTextContent(String.valueOf(counts));
                item.appendChild(countElement);
            }
        }
    }

    private String cleanCapitalize(String inString) {
        String output = inString;
        output = output.toLowerCase();
        output = output.substring(0, 1).toUpperCase() + output.substring(1);
        output = output.trim();
        return output;
    }

    void writeXML(StreamResult output, Document dom) throws TransformerConfigurationException, TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer tr = transformerFactory.newTransformer();
        tr.setOutputProperty("indent", "yes");
        tr.setOutputProperty("method", "xml");
        tr.setOutputProperty("encoding", "UTF-8");
        tr.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
        tr.transform(new DOMSource(dom), output);
    }

    public static enum SALType {
        TELEMETRY("Telemetry"),
        SETTINGS_APPLIED("Event");

        private final String type;

        private SALType(String type) {
            this.type = type;
        }

        String getSchema() {
            return this.type;
        }

        private String getClassNameAppendage() {
            return this == SETTINGS_APPLIED ? "SettingsApplied" : "";
        }
    }
}

