package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
// specific CCSCommands - 
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSClearCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDefinePlaylistCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDisableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSDiscardRowsCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEnableCalibrationCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSEndImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitGuidersCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSInitImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSPlayCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSSetFilterCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSStartImageCommand;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand.CCSTakeImagesCommand;

import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.PlayCommand;
import org.lsst.sal.camera.command.PlaylistCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

/**
 *
 * @author Farrukh Azfar
 */
public class OCSCommandConverter {

    private final Map< Class<? extends CameraCommand>, Class<? extends CCSCommand>> map;
    private final DelimitedStringSplitJoin delimitedStringSplitJoin = new DelimitedStringSplitJoin();

    public OCSCommandConverter() {
        this.map = new HashMap<>();

        map.put(SetFilterCommand.class, CCSSetFilterCommand.class);
        map.put(ClearCommand.class, CCSClearCommand.class);
        map.put(EndImageCommand.class, CCSEndImageCommand.class);
        map.put(InitGuidersCommand.class, CCSInitGuidersCommand.class);
        map.put(StartImageCommand.class, CCSStartImageCommand.class);
        map.put(TakeImagesCommand.class, CCSTakeImagesCommand.class);
        map.put(StartCommand.class, CCSStartCommand.class);
        map.put(DisableCalibrationCommand.class, CCSDisableCalibrationCommand.class);
        map.put(DiscardRowsCommand.class, CCSDiscardRowsCommand.class);
        map.put(InitImageCommand.class, CCSInitImageCommand.class);
        map.put(EnableCalibrationCommand.class, CCSEnableCalibrationCommand.class);
        map.put(PlayCommand.class, CCSPlayCommand.class);
        map.put(PlaylistCommand.class, CCSDefinePlaylistCommand.class);

    }

    public CCSCommand convert(CameraCommand myOCSCommand) {

        // get ocs command 
        // get its instance 
        // make a copy of the same command with fields appropriately made
        // construct a CCS command with the same fields
        // return a Camera command8
        // get the command to issue - 
        Class<? extends CCSCommand> ccsCommandFromMap = map.get(myOCSCommand.getClass());

        try {
            // Doesn't this assume a no-args constructor -- yes, should change to use constuctor
            CCSCommand ccsCommand = ccsCommandFromMap.getDeclaredConstructor().newInstance();

            Field[] ocsCommandFields = myOCSCommand.getClass().getDeclaredFields();
            Field[] ccsCommandFields = ccsCommand.getClass().getDeclaredFields();

            for (Field ocsCommandField : ocsCommandFields) {
                if (ocsCommandField.isSynthetic()) {
                    continue;
                }
                ocsCommandField.setAccessible(true);
                boolean matchFound = false;
                for (Field ccsCommandField : ccsCommandFields) {
                    if (ccsCommandField.isSynthetic()) {
                        continue;
                    }
                    ccsCommandField.setAccessible(true);
                    if (ocsCommandField.getName().equals(ccsCommandField.getName())) {
                        if (!ocsCommandField.getType().equals(ccsCommandField.getType())) {
                            // Special case, for string arguments which represent a list
                            if (ocsCommandField.getType() == String.class && ccsCommandField.getType() == String[].class) {
                                ccsCommandField.set(ccsCommand, delimitedStringSplitJoin.split((String) ocsCommandField.get((myOCSCommand))));
                                matchFound = true;
                                break;
                            } else {
                                throw new RuntimeException("OCSCommandConverter: OCS and CCS Commands contain the same variable names with different types");
                            }
                        } else {
                            ccsCommandField.set(ccsCommand, ocsCommandField.get(myOCSCommand));
                            matchFound = true;
                            break;
                        }
                    }
                }
                if (!matchFound) {
                    throw new RuntimeException("OCSCommandCoverter : no match found between OCS CCS fields, OCSCommand:  "
                            + myOCSCommand.toString() + " CCSCommand : " + ccsCommand.toString() + " for field " + ocsCommandField.getName());
                }
            }
            return ccsCommand;

        } catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Error converting command : ", ex);
        }
    }

}
