/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge;

import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.BridgeTest;
import org.lsst.ccs.subsystem.ocsbridge.FullStateHistory;
import org.lsst.ccs.subsystem.ocsbridge.TestStateChangeListener;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.event.AppliedSettingsMatchStartEvent;
import org.lsst.sal.camera.event.AvailableFiltersEvent;
import org.lsst.sal.camera.event.SettingVersionsEvent;
import org.lsst.sal.camera.event.SettingsAppliedEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;

public class ClearTest
extends BridgeTest {
    @Test
    public void failTest() {
        try {
            this.ocsBridge.execute((CameraCommand)new ClearCommand(5));
            Assert.fail((String)"Should not get here");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void clear() {
        this.enabler.goToEnable(this.ocsBridge);
        Assert.assertTrue((boolean)this.executor.containsInOrder(SettingVersionsEvent.class, AvailableFiltersEvent.class, SettingsAppliedEvent.class, AppliedSettingsMatchStartEvent.class));
        this.ocsBridge.execute((CameraCommand)new EnableCalibrationCommand());
        TestStateChangeListener tl = new TestStateChangeListener();
        this.ocsBridge.getCCS().addStateChangeListener((State.StateChangeListener)tl);
        this.executor.clearEvents();
        this.ocsBridge.execute((CameraCommand)new ClearCommand(5));
        Assert.assertEquals((long)4L, (long)tl.getCalls());
        tl.printFinalStates("ClearTest.clear()");
        assert (tl.getFinalStates().hasState(new Enum[]{CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (tl.getFinalStates().hasState(new Enum[]{FocalPlane.RaftsState.QUIESCENT}));
        this.ocsBridge.getCCS().removeStateChangeListener((State.StateChangeListener)tl);
        FullStateHistory fsh = tl.getFullStateHistory();
        fsh.printStateHistory("ClearTest.clear()");
        assert (fsh.containsInOrder(new Enum[]{CCSCommandStateEvent.CCSCommandState.BUSY, CCSCommandStateEvent.CCSCommandState.IDLE}));
        assert (fsh.containsInOrder(new Enum[]{FocalPlane.RaftsState.CLEARING, FocalPlane.RaftsState.QUIESCENT}));
        this.executor.printEventList("ClearTest.clear()");
        Assert.assertEquals((long)0L, (long)this.executor.getEventCount());
    }
}

