package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter.ShutterState;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

/**
 * An interface for talking to a real bonn-shutter subsystem.
 *
 * @author tonyj
 */
class ShutterSubsystemLayer extends ControlledSubsystem implements ShutterInterface {

    private static final Logger LOG = Logger.getLogger(ShutterSubsystemLayer.class.getName());
    private final State shutterState;

    ShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config,  State shutterState) {
        super(mcm, config.getShutterSubsystemName(), ccs, config);
        this.shutterState = shutterState;
    }
    
    @Override
    public void expose(Duration exposeTime) throws ExecutionException {
        // TODO: We should listen for actual state changes from shutter
        shutterState.setState(ShutterState.OPEN);
        commandSender.sendCommand("takeExposure", exposeTime.toMillis()/1000.);
        commandSender.sendCommand("waitForExposure");
        shutterState.setState(ShutterState.CLOSED);    
    }

    @Override
    public void open() throws ExecutionException {
        commandSender.sendCommand("openShutter");
    }

    @Override
    public void close() throws ExecutionException {
        commandSender.sendCommand("closeShutter");
    }
}
