/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FilterChangerSimulation
implements FilterChangerInterface {
    static final Duration LOAD_TIME = Duration.ofMillis(15000L);
    static final Duration ROTATION_TIME_PER_DEGREE = Duration.ofMillis(100L);
    static final Duration UNLOAD_TIME = Duration.ofMillis(15000L);
    private final Map<String, String> availableFilters = new LinkedHashMap<String, String>();
    private InstalledFilter currentFilter = InstalledFilter.NONE;
    private int currentRotationPosition = 0;
    private final CCS ccs;
    private final State filterState;

    FilterChangerSimulation(CCS ccs) {
        this.ccs = ccs;
        for (InstalledFilter f : InstalledFilter.values()) {
            this.availableFilters.put(f.toString(), f.name().toLowerCase());
        }
        this.filterState = new State<FilterChanger.FilterState>(FilterChanger.FilterState.UNLOADED);
        ccs.getAggregateStatus().add(CCSTimeStamp.currentTime(), this.filterState);
    }

    @Override
    public Map<String, String> getAvailableFilters() {
        return Collections.unmodifiableMap(this.availableFilters);
    }

    @Override
    public List<String> getInstalledFilters() {
        return new ArrayList<String>(this.availableFilters.keySet());
    }

    @Override
    public void start(String configName) {
    }

    @Override
    public String getCurrentFilter() {
        return this.currentFilter.toString();
    }

    @Override
    public void setFilter(String filterName) {
        try {
            int position = this.getInstalledFilters().indexOf(filterName);
            if (position < 0) {
                throw new IllegalArgumentException("Invalid filter: " + filterName);
            }
            InstalledFilter requestedFilter = InstalledFilter.values()[position];
            this.ccs.fireEvent(new MCM.CCSSetFilterEvent(filterName, requestedFilter.name().toLowerCase()));
            int targetRotation = -1;
            if (!requestedFilter.equals((Object)this.currentFilter)) {
                if (requestedFilter == InstalledFilter.NONE) {
                    this.filterState.setState(FilterChanger.FilterState.UNLOADING);
                    Future<Void> waitForUnloaded = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                    this.ccs.schedule(UNLOAD_TIME, () -> {
                        this.filterState.setState(FilterChanger.FilterState.UNLOADED);
                        this.currentFilter = InstalledFilter.NONE;
                    });
                    waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                } else {
                    if (this.currentFilter != InstalledFilter.NONE) {
                        this.filterState.setState(FilterChanger.FilterState.UNLOADING);
                        Future<Void> waitForUnloaded = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                        this.ccs.schedule(UNLOAD_TIME, () -> {
                            this.filterState.setState(FilterChanger.FilterState.UNLOADED);
                            this.currentFilter = InstalledFilter.NONE;
                        });
                        waitForUnloaded.get(UNLOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                    }
                    if (this.currentRotationPosition != (targetRotation = (position - 1) * 360 / 5)) {
                        int degreesToRotate = Math.abs(this.currentRotationPosition - targetRotation) % 360;
                        this.filterState.setState(FilterChanger.FilterState.ROTATING);
                        Future<Void> waitForRotation = this.ccs.waitForStatus(FilterChanger.FilterState.UNLOADED);
                        Duration rotationTime = ROTATION_TIME_PER_DEGREE.multipliedBy(degreesToRotate);
                        this.ccs.schedule(rotationTime, () -> this.filterState.setState(FilterChanger.FilterState.UNLOADED));
                        waitForRotation.get(rotationTime.toMillis() * 2L, TimeUnit.MILLISECONDS);
                        this.currentRotationPosition = targetRotation;
                    }
                    this.filterState.setState(FilterChanger.FilterState.LOADING);
                    Future<Void> waitForLoaded = this.ccs.waitForStatus(FilterChanger.FilterState.LOADED);
                    this.ccs.schedule(LOAD_TIME, () -> {
                        this.filterState.setState(FilterChanger.FilterState.LOADED);
                        this.currentFilter = requestedFilter;
                    });
                    waitForLoaded.get(LOAD_TIME.toMillis() * 2L, TimeUnit.MILLISECONDS);
                }
            }
            this.ccs.fireEvent(new MCM.CCSSetFilterEvent(filterName, requestedFilter.name().toLowerCase(), position, targetRotation));
        }
        catch (InterruptedException | ExecutionException | TimeoutException ex) {
            throw new RuntimeException("Error while changing filter", ex);
        }
    }

    @Override
    public Duration getEstimatedDurationForFilterChange(String filterName) {
        return ROTATION_TIME_PER_DEGREE.multipliedBy(360L).plus(LOAD_TIME).plus(UNLOAD_TIME);
    }

    private static enum InstalledFilter {
        NONE(0),
        U(10),
        G(9),
        R(1),
        I(9),
        X(100);

        private final short serial;

        private InstalledFilter(int serial) {
            this.serial = (short)serial;
        }

        public short getSerial() {
            return this.serial;
        }

        public String toString() {
            if (this == NONE) {
                return super.toString();
            }
            return super.toString().toLowerCase() + "-" + this.serial;
        }
    }
}

