/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.Serializable;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.subsystem.comcam.filterchanger.data.EndSetFilterData;
import org.lsst.ccs.subsystem.comcam.filterchanger.data.SetFilterData;
import org.lsst.ccs.subsystem.comcam.filterchanger.states.ComCamFCState;
import org.lsst.ccs.subsystem.ocsbridge.sim.ControlledSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChangerInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.taitime.CCSTimeStamp;

public class FilterChangerComCamSubsystemLayer
extends ControlledSubsystem
implements FilterChangerInterface {
    private static final Logger LOG = Logger.getLogger(FilterChangerComCamSubsystemLayer.class.getName());
    private static final Map<Enum<ComCamFCState>, Enum<FilterChanger.FilterState>> COMCAM_TO_FILTER_STATE = new HashMap<Enum<ComCamFCState>, Enum<FilterChanger.FilterState>>();

    public FilterChangerComCamSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        super(mcm, config.getFilterChangerSubsystemName(), ccs, config);
    }

    @Override
    public void setFilter(String filter) throws ExecutionException {
        this.commandSender.sendCommand("goToFilter " + filter, new Object[0]);
        this.waitUntilMoveComplete(this.getEstimatedDurationForFilterChange(filter));
    }

    @Override
    public Map<String, String> getAvailableFilters() throws ExecutionException {
        return this.commandSender.sendCommand(Map.class, "getAvailableFilters", new Object[0]);
    }

    @Override
    public List<String> getInstalledFilters() throws ExecutionException {
        return this.commandSender.sendCommand(List.class, "getInstalledFilters", new Object[0]);
    }

    @Override
    public String getCurrentFilter() throws ExecutionException {
        return this.commandSender.sendCommand(String.class, "getFilter", String.class);
    }

    @Override
    public Duration getEstimatedDurationForFilterChange(String filterName) {
        return Duration.ofSeconds(240L);
    }

    @Override
    protected void onConnect(AgentInfo agent, StateBundle initialState) {
        LOG.info("Filter changer connected");
        ComCamFCState state = (ComCamFCState)initialState.getState(ComCamFCState.class);
        this.translateComCamStateToFilterState((Enum)state);
    }

    @Override
    protected void onDisconnect(AgentInfo agent) {
        LOG.info("Filter changer disconnected");
    }

    @Override
    protected void onStateChange(StatusStateChangeNotification statusChange) {
        CCSTimeStamp ts = statusChange.getCCSTimeStamp();
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateComCamStateToFilterState((Enum)value));
    }

    private void waitUntilMoveComplete(Duration estimatedDurationForFilterChange) throws ExecutionException {
        Future<Void> waitForStatus = this.ccs.waitForStatus(FilterChanger.FilterState.LOADED);
        try {
            waitForStatus.get(estimatedDurationForFilterChange.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException ex) {
            throw new ExecutionException("Timeout waiting for filter change to complete", ex);
        }
    }

    private void translateComCamStateToFilterState(Enum value) {
        LOG.log(Level.INFO, "Got filter changer state {0} ", value);
        Enum<FilterChanger.FilterState> converted = COMCAM_TO_FILTER_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(new State<Enum<FilterChanger.FilterState>>(converted));
        }
    }

    @Override
    protected void onEvent(StatusMessage msg) {
        Serializable data = msg.getObject();
        if (data instanceof KeyValueDataList) {
            KeyValueDataList kvdl = (KeyValueDataList)data;
            Serializable dataObject = ((KeyValueData)kvdl.getListOfKeyValueData().get(0)).getValue();
            if (dataObject instanceof EndSetFilterData) {
                EndSetFilterData efd = (EndSetFilterData)dataObject;
                MCM.CCSSetFilterEvent ccsSetFilterEvent = new MCM.CCSSetFilterEvent(efd.getFilterName(), efd.getFilterType(), efd.getFilterSlot(), efd.getFilterPosition());
                this.ccs.fireEvent(ccsSetFilterEvent);
                LOG.log(Level.INFO, "Sent: {0}", ccsSetFilterEvent);
            } else if (dataObject instanceof SetFilterData) {
                SetFilterData sfd = (SetFilterData)dataObject;
                MCM.CCSSetFilterEvent ccsSetFilterEvent = new MCM.CCSSetFilterEvent(sfd.getFilterName(), sfd.getFilterType());
                this.ccs.fireEvent(ccsSetFilterEvent);
                LOG.log(Level.INFO, "Sent: {0}", ccsSetFilterEvent);
            }
        }
    }

    static {
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_MOVING, FilterChanger.FilterState.LOADING);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_FILTER1, FilterChanger.FilterState.LOADED);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_FILTER2, FilterChanger.FilterState.LOADED);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_FILTER3, FilterChanger.FilterState.LOADED);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_LOAD1, FilterChanger.FilterState.UNLOADING);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_LOAD3, FilterChanger.FilterState.UNLOADING);
        COMCAM_TO_FILTER_STATE.put((Enum<ComCamFCState>)ComCamFCState.POSITION_OTHER, FilterChanger.FilterState.UNLOADED);
    }
}

