/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TestConverter5 {
    @Test
    public void configConvertTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        try (InputStream in = TestConverter5.class.getResourceAsStream("comcam-vacuum-trending.ser");
             ObjectInputStream ois = new ObjectInputStream(in);){
            Object readObject = ois.readObject();
            Assert.assertTrue((boolean)(readObject instanceof StatusSubsystemData));
            StatusSubsystemData statusInfo = (StatusSubsystemData)readObject;
            Assert.assertEquals((Object)"comcam-vacuum", (Object)statusInfo.getOriginAgentInfo().getName());
            System.out.println("ClassName " + statusInfo.getClassName());
            Assert.assertEquals((Object)"org.lsst.ccs.bus.data.KeyValueDataList", (Object)statusInfo.getClassName());
            HashMap<Class, String> subSystemClasses = new HashMap<Class, String>();
            subSystemClasses.put(Vacuum_Cold1Telemetry.class, "comcam-vacuum");
            subSystemClasses.put(Vacuum_Cold2Telemetry.class, "comcam-vacuum");
            subSystemClasses.put(Vacuum_CryoTelemetry.class, "comcam-vacuum");
            subSystemClasses.put(Vacuum_TurboTelemetry.class, "comcam-vacuum");
            subSystemClasses.put(Vacuum_VQMonitorTelemetry.class, "comcam-vacuum");
            subSystemClasses.put(Vacuum_IonPumpsTelemetry.class, "comcam-vacuum");
            HashMap<String, String> nameChange = new HashMap<String, String>();
            nameChange.put("ionpumps_voltage", "ionpump_voltage");
            nameChange.put("ionpumps_current", "ionpump_current");
            nameChange.put("turborpm", "rpm");
            nameChange.put("pdu5votm3bi", "otm0bi");
            nameChange.put("pdu5votm3bv", "otm0bv");
            nameChange.put("pdu5votm3ai", "otm0ai");
            nameChange.put("pdu5votm3av", "otm0av");
            HashMap<String, String> nameChangeSettingsApplied = new HashMap<String, String>();
            nameChangeSettingsApplied.put("ccd_name", "ccd_LSSTName");
            nameChangeSettingsApplied.put("raft_name", "raft_LSSTName");
            nameChangeSettingsApplied.put("reb_name", "reb_LSSTName");
            nameChangeSettingsApplied.put("ionpumps_voltage", "ionpump_voltage");
            nameChangeSettingsApplied.put("ionpumps_current", "ionpump_current");
            nameChangeSettingsApplied.put("turborpm", "rpm");
            GenericConverter gc = new GenericConverter(subSystemClasses, nameChange, nameChangeSettingsApplied);
            List telemetry = gc.telemetryConverter(statusInfo);
            System.out.println("**********");
            for (int i = 0; i < telemetry.size(); ++i) {
                System.out.println(((CameraTelemetry)telemetry.get(i)).toString());
            }
            System.out.println("**********");
        }
    }
}

