/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.sim.FilterChanger;
import org.lsst.ccs.subsystem.ocsbridge.sim.FocalPlane;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.states.CCSCommandStateEvent;
import org.lsst.sal.camera.states.CalibrationDetailedStateEvent;
import org.lsst.sal.camera.states.FilterChangerDetailedStateEvent;
import org.lsst.sal.camera.states.ImageReadinessDetailedStateEvent;
import org.lsst.sal.camera.states.OfflineDetailedStateEvent;
import org.lsst.sal.camera.states.RaftsDetailedStateEvent;
import org.lsst.sal.camera.states.ShutterDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSStateEventConverter {
    private final Map<Class<? extends Enum>, Class<? extends Enum>> mapEnums = new HashMap<Class<? extends Enum>, Class<? extends Enum>>();
    private final Map<Class<? extends Enum>, Class<? extends CameraStateChangeEvent>> mapEnumToClass = new HashMap<Class<? extends Enum>, Class<? extends CameraStateChangeEvent>>();

    public OCSStateEventConverter() {
        this.mapEnums.put(SummaryStateEvent.SummaryState.class, SummaryStateEvent.SummaryState.class);
        this.mapEnums.put(Shutter.ShutterState.class, ShutterDetailedStateEvent.ShutterState.class);
        this.mapEnums.put(FilterChanger.FilterState.class, FilterChangerDetailedStateEvent.FilterChangerState.class);
        this.mapEnums.put(CCSCommandStateEvent.CCSCommandState.class, CCSCommandStateEvent.CCSCommandState.class);
        this.mapEnums.put(MCM.TakeImageReadinessState.class, ImageReadinessDetailedStateEvent.ImageReadinessState.class);
        this.mapEnums.put(FocalPlane.RaftsState.class, RaftsDetailedStateEvent.RaftsState.class);
        this.mapEnums.put(MCM.CalibrationState.class, CalibrationDetailedStateEvent.CalibrationState.class);
        this.mapEnums.put(OfflineDetailedStateEvent.OfflineState.class, OfflineDetailedStateEvent.OfflineState.class);
        this.mapEnumToClass.put(SummaryStateEvent.SummaryState.class, SummaryStateEvent.class);
        this.mapEnumToClass.put(Shutter.ShutterState.class, ShutterDetailedStateEvent.class);
        this.mapEnumToClass.put(FilterChanger.FilterState.class, FilterChangerDetailedStateEvent.class);
        this.mapEnumToClass.put(CCSCommandStateEvent.CCSCommandState.class, CCSCommandStateEvent.class);
        this.mapEnumToClass.put(MCM.TakeImageReadinessState.class, ImageReadinessDetailedStateEvent.class);
        this.mapEnumToClass.put(FocalPlane.RaftsState.class, RaftsDetailedStateEvent.class);
        this.mapEnumToClass.put(MCM.CalibrationState.class, CalibrationDetailedStateEvent.class);
        this.mapEnumToClass.put(OfflineDetailedStateEvent.OfflineState.class, OfflineDetailedStateEvent.class);
    }

    private Enum getEnum(Enum ccsStateEvent) {
        Class<? extends Enum> ocsEvent = this.mapEnums.get(ccsStateEvent.getClass());
        if (ocsEvent == null) {
            return null;
        }
        String name = ccsStateEvent.name();
        for (Enum ocsEnum : ocsEvent.getEnumConstants()) {
            if (!ocsEnum.name().equals(name)) continue;
            return ocsEnum;
        }
        throw new RuntimeException("Could not find equivalent Enum for input: " + ccsStateEvent);
    }

    public CameraStateChangeEvent convert(Enum ccsEnum, int priority) throws RuntimeException {
        Enum enumForOCS = this.getEnum(ccsEnum);
        Class<? extends CameraStateChangeEvent> ocsStateChangeEvent = this.mapEnumToClass.get(ccsEnum.getClass());
        if (enumForOCS == null || ocsStateChangeEvent == null) {
            return null;
        }
        try {
            Constructor<? extends CameraStateChangeEvent> constructor = ocsStateChangeEvent.getConstructor(Integer.TYPE, enumForOCS.getClass());
            return constructor.newInstance(priority, enumForOCS);
        }
        catch (ReflectiveOperationException x) {
            throw new RuntimeException("Error constructing CameraStateChangeEvent for ccsEnum " + ccsEnum, x);
        }
    }
}

