/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMSubsystem;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterInterface;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSimulation;
import org.lsst.ccs.subsystem.ocsbridge.sim.ShutterSubsystemLayer;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;

public class Shutter {
    static final Duration PREP_TIME = Duration.ofMillis(150L);
    static final Duration READY_TIME = Duration.ofMillis(4000L);
    static final Duration READY_TIME_FOR_SEVERAL_IMAGES = Duration.ofMillis(10000L);
    static final Duration MOVE_TIME = Duration.ofMillis(980L);
    public boolean imageSequence = false;
    private final MCMConfig config;
    private final State shutterReadinessState;
    private final State shutterState;
    private ScheduledFuture<?> notReadyFuture;
    private ShutterInterface shutter;
    private final CCS ccs;

    Shutter(CCS ccs, MCMConfig config) {
        this.ccs = ccs;
        this.config = config;
        this.shutterReadinessState = new State<ShutterReadinessState>(ShutterReadinessState.NOT_READY);
        ccs.getAggregateStatus().add(this.shutterReadinessState);
        this.shutterState = new State<ShutterState>(ShutterState.CLOSED);
        ccs.getAggregateStatus().add(this.shutterState);
        this.shutterState.addStateChangeListener((state, oldState) -> {
            if (state == ShutterState.CLOSED) {
                this.scheduleNotReady();
            } else {
                this.cancelNotReady();
            }
        });
        this.shutter = new ShutterSimulation(ccs, this.shutterState);
    }

    public void startImageSequence() {
        this.imageSequence = true;
    }

    public void endImageSequence() {
        this.imageSequence = false;
    }

    private void scheduleNotReady() {
        Duration ready_time = this.imageSequence ? READY_TIME_FOR_SEVERAL_IMAGES : READY_TIME;
        this.notReadyFuture = this.ccs.schedule(ready_time, () -> this.shutterReadinessState.setState(ShutterReadinessState.NOT_READY));
    }

    private void cancelNotReady() {
        if (this.notReadyFuture != null) {
            this.notReadyFuture.cancel(false);
        }
    }

    void prepare() {
        this.cancelNotReady();
        this.shutterReadinessState.setState(ShutterReadinessState.GETTING_READY);
        this.ccs.schedule(PREP_TIME, () -> {
            this.shutterReadinessState.setState(ShutterReadinessState.READY);
            this.scheduleNotReady();
        });
    }

    void expose(Duration exposureTime) throws ExecutionException {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutter.expose(exposureTime);
    }

    void start(String configName) throws ExecutionException {
        this.shutter.start(configName);
    }

    void open() throws ExecutionException {
        this.shutterReadinessState.checkState(new Enum[]{ShutterReadinessState.READY});
        this.shutter.open();
    }

    void close() throws ExecutionException {
        if (!this.shutterState.isInState(ShutterState.CLOSED)) {
            this.shutter.close();
        }
    }

    void registerMCMSubsystem(MCMSubsystem mcm) {
        this.shutter = new ShutterSubsystemLayer((Subsystem)mcm, this.ccs, this.config, this.shutterState);
    }

    public static enum ShutterState {
        CLOSED,
        OPENING,
        OPEN,
        CLOSING;

    }

    public static enum ShutterReadinessState {
        NOT_READY,
        READY,
        GETTING_READY;

    }
}

