/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.lsst.ccs.bus.data.ConfigurationInfo;
import org.lsst.ccs.bus.data.ConfigurationParameterInfo;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.sal.camera.CameraEvent;
import org.lsst.sal.camera.CameraTelemetry;

public class GenericConverter {
    private static final Logger LOG = Logger.getLogger(GenericConverter.class.getName());
    private final Map<Class, String> subSystemClasses;
    private final Map<String, String> nameChange;
    private final Map<String, String> nameChangeSettingsApplied;
    private final Map<Class, List<String>> alreadyWarned = new HashMap<Class, List<String>>();
    private final List<String> mia = new ArrayList<String>();
    private static final boolean DEBUG_PRINT_PROCESSORS = false;
    private static final boolean DEBUG_PRINT_STORAGE = false;
    private static final boolean DEBUG_PRINT_CONVERTERS = false;
    private static final boolean DEBUG_PRINT_REFLECT = false;
    Map<Pattern, String> patternReplace = new LinkedHashMap<Pattern, String>();
    Pattern sensorPattern = Pattern.compile("(R..)/(Reb.)/(S..?)/(.+)", 2);
    Pattern rebPattern = Pattern.compile("(R..)/(Reb.)(?:_hardware)?/(.+)", 2);
    Pattern raftPattern = Pattern.compile("(R..)/(.+)", 2);
    Pattern rebpsPattern = Pattern.compile("RebPS/(P\\d\\d)/(.+)", 2);
    Pattern segPattern = Pattern.compile("(R\\d\\d/Reb\\w\\/S\\w\\d/Seg\\d\\d)/(.+)", 2);

    public GenericConverter(Map<Class, String> subSystemClasses, Map<String, String> nameChange, Map<String, String> nameChangeSettingsApplied) {
        this.subSystemClasses = subSystemClasses;
        this.nameChange = nameChange;
        this.nameChangeSettingsApplied = nameChangeSettingsApplied;
    }

    List<processedBusInfoStore> busInfoReprocessor(List<processedBusInfoStore> storage, String salType) {
        ArrayList<processedBusInfoStore> reProcessedBusInfoList = new ArrayList<processedBusInfoStore>();
        ArrayList<Integer> alreadyFound = new ArrayList<Integer>();
        boolean isArray = false;
        for (int i = 0; i < storage.size(); ++i) {
            String name = storage.get(i).getName();
            String type = storage.get(i).getType();
            String replacedWithOuter = storage.get(i).getReplacedWith();
            isArray = false;
            if (alreadyFound.contains(i)) continue;
            ArrayList<Object> myArray = new ArrayList<Object>();
            for (int j = i + 1; j < storage.size(); ++j) {
                String replacedWithInner = storage.get(j).getReplacedWith();
                boolean sameCategory = replacedWithInner.trim().equals(replacedWithOuter.trim());
                if (!storage.get(j).getName().trim().equals(name.trim()) || !storage.get(j).getType().trim().equals(type) || !sameCategory) continue;
                isArray = true;
                if (!alreadyFound.contains(i)) {
                    myArray.add(storage.get(i).getValuesAndType());
                }
                myArray.add(storage.get(j).getValuesAndType());
                alreadyFound.add(i);
                alreadyFound.add(j);
            }
            if (isArray) {
                reProcessedBusInfoList.add(new processedBusInfoStore(storage.get(i).getName(), storage.get(i).getType(), storage.get(i).getOldPathName(), storage.get(i).getNewPathName(), storage.get(i).getIfPatternReplaced(), storage.get(i).getReplacedPattern(), storage.get(i).getReplacedWith(), myArray));
                continue;
            }
            reProcessedBusInfoList.add(new processedBusInfoStore(storage.get(i).getName(), storage.get(i).getType(), storage.get(i).getOldPathName(), storage.get(i).getNewPathName(), storage.get(i).getIfPatternReplaced(), storage.get(i).getReplacedPattern(), storage.get(i).getReplacedWith(), storage.get(i).getValuesAndType()));
        }
        return reProcessedBusInfoList;
    }

    String LevelPatternReplacement(Map<Pattern, String> patternReplace, String className) {
        String pathReplacementString = "";
        className = className.replace("MTCamera", "").trim();
        className = className.replace("CCCamera", "").trim();
        className = className.replace("Telemetry", "").trim();
        if ((className = className.replace("SettingsAppliedEvent", "").trim()).startsWith("_")) {
            className = className.replaceFirst("[_]", "").trim();
        }
        if (!className.contains("_")) {
            pathReplacementString = "";
        } else {
            String[] testPattern;
            for (String test : testPattern = className.split("_")) {
                for (Map.Entry<Pattern, String> patternKey : patternReplace.entrySet()) {
                    if (!test.toLowerCase().contains(patternKey.getValue())) continue;
                    pathReplacementString = patternKey.getValue();
                }
            }
        }
        return pathReplacementString;
    }

    String pureClassName(String classWithPeriods) {
        String pureClassName = classWithPeriods.trim();
        if (classWithPeriods.contains(".")) {
            pureClassName = classWithPeriods.split("\\.")[classWithPeriods.split("\\.").length - 1];
        }
        return pureClassName;
    }

    void initialisePattern() {
        this.patternReplace.put(this.segPattern, "segment");
        this.patternReplace.put(this.sensorPattern, "ccd");
        this.patternReplace.put(this.rebPattern, "reb");
        this.patternReplace.put(this.raftPattern, "raft");
        this.patternReplace.put(this.rebpsPattern, "rebps");
    }

    public List<CameraTelemetry> telemetryConverter(StatusSubsystemData statusInfo) throws ReflectiveOperationException {
        ArrayList<CameraTelemetry> salTelemetry = new ArrayList<CameraTelemetry>();
        List<Object> reProcessedBusInfoList = new ArrayList();
        HashMap receivedInfo = new HashMap();
        String subsystemName = statusInfo.getOriginAgentInfo().getName();
        KeyValueData subsystemData = statusInfo.getSubsystemData();
        List values = (List)((Object)subsystemData.getValue());
        ArrayList<processedBusInfoStore> storage = new ArrayList<processedBusInfoStore>();
        this.initialisePattern();
        for (Map.Entry<Class, String> salEntry : this.subSystemClasses.entrySet()) {
            ArrayList<locationRecordStore> recordedListOfLocations = new ArrayList<locationRecordStore>();
            for (KeyValueData kvd : values) {
                String key = kvd.getKey();
                if (key.contains("/state")) continue;
                Serializable thisValue = kvd.getValue();
                if (thisValue instanceof Double) {
                    thisValue = Float.valueOf(((Double)thisValue).floatValue());
                }
                String pathFromBus = kvd.getKey();
                boolean foundPattern = false;
                boolean foundPatternPrelim = false;
                for (Map.Entry<Pattern, String> patternKey : this.patternReplace.entrySet()) {
                    Matcher m = patternKey.getKey().matcher(pathFromBus);
                    if (!m.matches()) continue;
                    pathFromBus = pathFromBus.replace("/", "_");
                    foundPatternPrelim = true;
                    String oldPathFromBus = pathFromBus;
                    String replacedPattern = patternKey.toString();
                    String classContains = "";
                    String pureClassName = this.pureClassName(salEntry.getKey().toString());
                    classContains = this.LevelPatternReplacement(this.patternReplace, pureClassName);
                    if (classContains.isEmpty()) {
                        pathFromBus = patternKey.getValue() + "_" + m.group(m.groupCount());
                    } else {
                        if (classContains.equals(this.patternReplace.get(patternKey.getKey()))) {
                            // empty if block
                        }
                        pathFromBus = m.group(m.groupCount());
                    }
                    pathFromBus = pathFromBus.replace("/", "_");
                    pathFromBus = pathFromBus.replace("__", "_");
                    if (pathFromBus.contains("/state")) break;
                    foundPattern = true;
                    pathFromBus = pathFromBus.replace("/", "_");
                    pathFromBus = pathFromBus.replace("main", "");
                    pathFromBus = pathFromBus.toLowerCase().trim();
                    for (Map.Entry<String, String> keyNC : this.nameChange.entrySet()) {
                        if (!pathFromBus.toLowerCase().trim().contains(keyNC.getKey().toLowerCase().trim())) continue;
                        pathFromBus = keyNC.getValue();
                    }
                    String locationType = patternKey.getValue().trim().toLowerCase().equals(classContains.trim().toLowerCase()) ? "Location" : patternKey.getValue().trim() + "Location";
                    String locationString = "";
                    if (patternKey.getValue().trim().equals("ccd")) {
                        locationString = m.group(1) + m.group(3);
                    } else if (patternKey.getValue().trim().equals("reb")) {
                        locationString = m.group(1) + m.group(2);
                    } else if (patternKey.getValue().trim().equals("raft")) {
                        locationString = m.group(1);
                    } else if (patternKey.getValue().trim().equals("rebps")) {
                        locationString = m.group(1);
                    } else if (patternKey.getValue().trim().equals("segment")) {
                        locationString = m.group(1);
                    }
                    if (!locationString.isEmpty() && !recordedListOfLocations.contains(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()))) {
                        storage.add(new processedBusInfoStore(locationType, locationString.getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), locationString));
                        recordedListOfLocations.add(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()));
                    }
                    processedBusInfoStore prbpi = new processedBusInfoStore(pathFromBus, kvd.getValue().getClass().getTypeName(), oldPathFromBus, pathFromBus, true, replacedPattern, patternKey.getValue().trim(), thisValue);
                    storage.add(prbpi);
                    break;
                }
                if (foundPattern) continue;
                pathFromBus = pathFromBus.replace("/", "_");
                pathFromBus = pathFromBus.replace("main", "");
                if (this.nameChange.containsKey(pathFromBus = pathFromBus.toLowerCase().trim())) {
                    pathFromBus = this.nameChange.get(pathFromBus);
                }
                storage.add(new processedBusInfoStore(pathFromBus, kvd.getValue().getClass().getTypeName(), pathFromBus, pathFromBus, false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", thisValue));
            }
            reProcessedBusInfoList = this.busInfoReprocessor(storage, "Telemetry");
            if (salEntry.getValue().equals(subsystemName)) {
                Parameter[] parameters = salEntry.getKey().getConstructors()[0].getParameters();
                CameraTelemetry ct = (CameraTelemetry)this.reflectedClass(salEntry.getKey(), parameters, reProcessedBusInfoList);
                Parameter[] thisClassParameters = ct.getClass().getConstructors()[0].getParameters();
                Method[] methods = ct.getClass().getDeclaredMethods();
                ArrayList<Method> getMethods = new ArrayList<Method>();
                int numMissingValues = 0;
                int numGetMethods = 0;
                double badValue = -111111.0;
                String badStringValue = "NOTFOUND";
                for (int i = 0; i < methods.length; ++i) {
                    String methodName = methods[i].getName();
                    String[] parts = methodName.split("\\s");
                    if (parts[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
                    getMethods.add(methods[i]);
                    ++numGetMethods;
                }
                for (Method method : getMethods) {
                    if (!method.invoke((Object)ct, new Object[0]).equals(badValue) && !method.invoke((Object)ct, new Object[0]).equals(badStringValue)) continue;
                    ++numMissingValues;
                }
                if (numMissingValues != numGetMethods) {
                    salTelemetry.add(ct);
                }
            }
            reProcessedBusInfoList.clear();
            storage.clear();
            recordedListOfLocations.clear();
        }
        return salTelemetry;
    }

    /*
     * WARNING - void declaration
     */
    public List<CameraEvent> settingsAppliedEventConverter(ConfigurationInfo info) throws ReflectiveOperationException {
        ArrayList<CameraEvent> salSettingsAppliedEvents = new ArrayList<CameraEvent>();
        ArrayList<processedBusInfoStore> storage = new ArrayList<processedBusInfoStore>();
        ArrayList<processedBusInfoStore> reProcessedBusInfoList = new ArrayList();
        this.initialisePattern();
        List cpinfo = info.getAllParameterInfo();
        for (Map.Entry<Class, String> salEntry : this.subSystemClasses.entrySet()) {
            salEntry.getValue();
            Integer version = info.getConfigVersion(salEntry.getValue());
            ArrayList<locationRecordStore> recordedListOfLocations = new ArrayList<locationRecordStore>();
            for (ConfigurationParameterInfo ci : cpinfo) {
                void var18_20;
                if (ci.getCategoryName().trim().equals(salEntry.getValue())) {
                    String pathFromBus = ci.getPathName();
                    boolean foundPattern = false;
                    for (Map.Entry<Pattern, String> patternKey : this.patternReplace.entrySet()) {
                        Matcher m = patternKey.getKey().matcher(pathFromBus);
                        if (m.matches()) {
                            pathFromBus = pathFromBus.replace("/", "_");
                            String oldPathFromBus = pathFromBus;
                            String string = patternKey.getValue();
                            String classContains = "";
                            String pureClassName = this.pureClassName(salEntry.getKey().toString());
                            classContains = this.LevelPatternReplacement(this.patternReplace, pureClassName);
                            if (classContains.isEmpty()) {
                                pathFromBus = patternKey.getValue() + "_" + m.group(m.groupCount());
                            } else {
                                if (classContains.equals(this.patternReplace.get(patternKey.getKey()))) {
                                    // empty if block
                                }
                                pathFromBus = pathFromBus.replace("/", "_");
                                if ((pathFromBus = pathFromBus.replace("__", "_")).contains("/state")) break;
                                foundPattern = true;
                                pathFromBus = pathFromBus.replace("/", "_");
                                pathFromBus = pathFromBus.replace("main", "");
                                pathFromBus = pathFromBus.toLowerCase().trim();
                                for (Map.Entry<String, String> keyNC : this.nameChangeSettingsApplied.entrySet()) {
                                    if (!pathFromBus.toLowerCase().trim().contains(keyNC.getKey().toLowerCase().trim())) continue;
                                    pathFromBus = keyNC.getValue();
                                }
                                String locationType = "";
                                locationType = patternKey.getValue().trim().toLowerCase().equals(classContains.trim().toLowerCase()) ? "Location" : patternKey.getValue().trim() + "Location";
                                String locationString = "";
                                if (patternKey.getValue().trim().equals("ccd")) {
                                    locationString = m.group(1) + m.group(3);
                                } else if (patternKey.getValue().trim().equals("reb")) {
                                    locationString = m.group(1) + m.group(2);
                                } else if (patternKey.getValue().trim().equals("raft")) {
                                    locationString = m.group(1);
                                } else if (patternKey.getValue().trim().equals("rebps")) {
                                    locationString = m.group(1);
                                } else if (patternKey.getValue().trim().equals("segment")) {
                                    locationString = m.group(1);
                                }
                                if (!locationString.isEmpty() && !recordedListOfLocations.contains(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()))) {
                                    storage.add(new processedBusInfoStore(locationType, locationString.getClass().getTypeName(), oldPathFromBus, pathFromBus, true, string, patternKey.getValue().trim(), locationString));
                                    recordedListOfLocations.add(new locationRecordStore(locationType, locationString, salEntry.getKey().getName()));
                                }
                                storage.add(new processedBusInfoStore(pathFromBus, ci.getConfiguredValueObject().getClass().getTypeName(), oldPathFromBus, pathFromBus, true, string, patternKey.getValue().trim(), ci.getConfiguredValueObject()));
                                break;
                            }
                        }
                        if (foundPattern || pathFromBus.contains("/state")) continue;
                        pathFromBus = pathFromBus.replace("/", "_");
                        pathFromBus = pathFromBus.replace("main", "");
                        pathFromBus = pathFromBus.toLowerCase().trim();
                        for (Map.Entry entry : this.nameChangeSettingsApplied.entrySet()) {
                            if (!pathFromBus.toLowerCase().trim().contains(((String)entry.getKey()).toLowerCase().trim())) continue;
                            pathFromBus = (String)entry.getValue();
                        }
                        storage.add(new processedBusInfoStore(pathFromBus, ci.getConfiguredValueObject().getClass().getTypeName(), pathFromBus, pathFromBus, false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", ci.getConfiguredValueObject()));
                    }
                }
                storage.add(new processedBusInfoStore("version", version.getClass().getTypeName(), "version", "version", false, "NOMATCHEDPATTERN", "NOMATCHEDPATTERN", (int)version));
                reProcessedBusInfoList = this.busInfoReprocessor(storage, "SettingsApplied");
                Parameter[] parameters = salEntry.getKey().getConstructors()[0].getParameters();
                CameraEvent ce = (CameraEvent)this.reflectedClass(salEntry.getKey(), parameters, reProcessedBusInfoList);
                Parameter[] thisClassParameters = ce.getClass().getConstructors()[0].getParameters();
                Method[] methods = ce.getClass().getDeclaredMethods();
                ArrayList<Method> getMethods = new ArrayList<Method>();
                int numMissingValues = 0;
                boolean bl = false;
                double badValue = -111111.0;
                String badStringValue = "NOTFOUND";
                for (int i = 0; i < methods.length; ++i) {
                    String methodName = methods[i].getName();
                    String[] parts = methodName.split("\\s");
                    if (parts[parts.length - 1].contains("toString") || !parts[parts.length - 1].contains("get")) continue;
                    getMethods.add(methods[i]);
                    ++var18_20;
                }
                for (Method method : getMethods) {
                    if (!method.invoke((Object)ce, new Object[0]).equals(badValue) && !method.invoke((Object)ce, new Object[0]).equals(badStringValue)) continue;
                    ++numMissingValues;
                }
                if (numMissingValues != var18_20 - true) {
                    salSettingsAppliedEvents.add(ce);
                }
                reProcessedBusInfoList.clear();
                storage.clear();
                recordedListOfLocations.clear();
            }
        }
        return salSettingsAppliedEvents;
    }

    private Object reflectedClass(Class cls, Parameter[] parameters, List<processedBusInfoStore> reprocessedBusInfo) throws ReflectiveOperationException {
        String cleanedCurrentClassName = cls.getName().split("\\.")[cls.getName().split("\\.").length - 1];
        boolean classNameHasPattern = false;
        this.initialisePattern();
        String classContains = this.LevelPatternReplacement(this.patternReplace, this.pureClassName(cls.toString()));
        String patternInClass = "";
        System.out.println(" class contains from Reflection function " + cls.getName());
        for (Map.Entry<Pattern, String> patternKey : this.patternReplace.entrySet()) {
            if (!classContains.equals(this.patternReplace.get(patternKey.getKey()))) continue;
            patternInClass = patternKey.toString();
        }
        if (cleanedCurrentClassName.contains("Telemetry")) {
            cleanedCurrentClassName = cleanedCurrentClassName.replace("Telemetry", "");
        } else if (cleanedCurrentClassName.contains("Settings")) {
            cleanedCurrentClassName = cleanedCurrentClassName.replace("Settings", "");
        }
        int classNamePieces = cleanedCurrentClassName.split("_").length;
        if (classNamePieces > 1) {
            String tmpClassName = "";
            for (int i = 1; i < classNamePieces; ++i) {
                tmpClassName = tmpClassName + cleanedCurrentClassName.split("_")[i];
            }
            cleanedCurrentClassName = tmpClassName = tmpClassName.trim();
        }
        cleanedCurrentClassName = cleanedCurrentClassName.toLowerCase().trim();
        ArrayList<Object> constructorArgs = new ArrayList<Object>();
        for (Parameter parameter : parameters) {
            if (parameter.getName().trim().equals("priority")) {
                constructorArgs.add(1);
                continue;
            }
            boolean found = false;
            for (processedBusInfoStore pbi : reprocessedBusInfo) {
                String[] arrl;
                String joinedArray;
                String parameterFromClass;
                String keyName;
                String preunderscoreKN = keyName = pbi.getName().toLowerCase().trim();
                keyName = keyName.replace("_", "");
                keyName = keyName.replace(".", "");
                String varType = pbi.getType();
                String preunderscorePFC = parameterFromClass = "";
                if (parameter.toString().length() > 1) {
                    String[] lastBit = parameter.toString().split(" ");
                    preunderscorePFC = parameterFromClass = lastBit[lastBit.length - 1].toLowerCase().trim();
                    parameterFromClass = parameterFromClass.replace("_", "");
                    parameterFromClass = parameterFromClass.trim();
                }
                boolean classVariablePatternCheck = true;
                if (!patternInClass.isEmpty() && !pbi.getReplacedPattern().equals(patternInClass)) {
                    classVariablePatternCheck = false;
                }
                if (!(cleanedCurrentClassName.toLowerCase().trim() + parameterFromClass.toLowerCase().trim()).endsWith(keyName) || !classVariablePatternCheck) continue;
                boolean isAnArrayList = pbi.getValuesAndType().getClass().toString().contains("List") || varType.contains("List");
                boolean isAnArray = !isAnArrayList && pbi.getValuesAndType().getClass().toString().contains("[");
                boolean isAString = varType.contains("String") || pbi.getValuesAndType().getClass().toString().contains("String");
                boolean isAMap = varType.contains("Map");
                if (!isAnArrayList && !isAnArray) {
                    if (!isAMap) {
                        if (parameter.getType().isArray()) {
                            Object arrayArg = Array.newInstance(parameter.getType().getComponentType(), 1);
                            Array.set(arrayArg, 0, pbi.getValuesAndType());
                            constructorArgs.add(arrayArg);
                        } else {
                            constructorArgs.add(pbi.getValuesAndType());
                        }
                    } else {
                        constructorArgs.add(pbi.getValuesAndType().toString());
                    }
                }
                if (!isAnArray && isAnArrayList && !isAString) {
                    int m;
                    ArrayList arr = (ArrayList)pbi.getValuesAndType();
                    if (varType.toLowerCase().contains("double")) {
                        double[] darray = new double[arr.size()];
                        for (m = 0; m < arr.size(); ++m) {
                            float myff = ((Float)arr.get(m)).floatValue();
                            darray[m] = myff;
                        }
                        constructorArgs.add(darray);
                    } else if (varType.toLowerCase().contains("int")) {
                        int[] iarray = new int[arr.size()];
                        for (m = 0; m < arr.size(); ++m) {
                            int myii;
                            iarray[m] = myii = ((Integer)arr.get(m)).intValue();
                        }
                        constructorArgs.add(iarray);
                    } else if (varType.toLowerCase().contains("long")) {
                        long[] larray = new long[arr.size()];
                        for (int m2 = 0; m2 < arr.size(); ++m2) {
                            long myll;
                            larray[m2] = myll = (long)((Integer)arr.get(m2)).intValue();
                        }
                        constructorArgs.add(larray);
                    } else if (varType.toLowerCase().contains("short")) {
                        short[] sharray = new short[arr.size()];
                        for (m = 0; m < arr.size(); ++m) {
                            short myss;
                            sharray[m] = myss = ((Short)arr.get(m)).shortValue();
                        }
                        constructorArgs.add(sharray);
                    } else if (varType.toLowerCase().contains("float")) {
                        float[] farray = new float[arr.size()];
                        for (m = 0; m < arr.size(); ++m) {
                            float myff;
                            farray[m] = myff = (float)((Short)arr.get(m)).shortValue();
                        }
                        constructorArgs.add(farray);
                    }
                }
                if (!isAnArrayList && !isAString && isAnArray) {
                    constructorArgs.add(pbi.getValuesAndType());
                }
                if (isAString && isAnArrayList) {
                    joinedArray = "";
                    arrl = new ArrayList();
                    arrl = (String[])pbi.getValuesAndType();
                    for (int i = 0; i < arrl.size(); ++i) {
                        joinedArray = joinedArray + (String)arrl.get(i) + ":";
                    }
                    joinedArray = joinedArray.substring(0, joinedArray.length() - 1);
                    constructorArgs.add(joinedArray);
                }
                if (isAString && isAnArray && !isAnArrayList) {
                    joinedArray = "";
                    arrl = (String[])pbi.getValuesAndType();
                    for (int i = 0; i < arrl.length; ++i) {
                        joinedArray = joinedArray + arrl[i] + ":";
                    }
                    joinedArray = joinedArray.substring(0, joinedArray.length() - 1);
                    constructorArgs.add(joinedArray);
                }
                found = true;
                break;
            }
            if (found) continue;
            this.mia.add(parameter.getName());
            this.alreadyWarned.put(cls, this.mia);
            int i = Collections.frequency((Collection)this.alreadyWarned.get(cls), parameter.getName());
            if (i > 0 && i <= 1) {
                LOG.log(Level.WARNING, "Class {0} : No value found for parameter {1} in {2}", new Object[]{cls.getName(), parameter.getName(), reprocessedBusInfo});
            }
            if (parameter.getType().isArray()) {
                constructorArgs.add(new double[0]);
                continue;
            }
            if (parameter.getType().equals(String.class)) {
                constructorArgs.add("NOTFOUND");
                continue;
            }
            constructorArgs.add(-111111);
        }
        return cls.getConstructors()[0].newInstance(constructorArgs.toArray());
    }

    private static String betterToString(Constructor constructor, List<Object> data) {
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < data.size(); ++i) {
            result.add(constructor.getParameters()[i].getName() + "=" + (data.get(i).getClass().isArray() ? GenericConverter.arrayToString(data.get(i)) : data.get(i).toString()));
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    private static String arrayToString(Object array) {
        ArrayList<String> result = new ArrayList<String>();
        int l = Array.getLength(array);
        for (int i = 0; i < l; ++i) {
            result.add(Array.get(array, i).toString());
        }
        return "[" + String.join((CharSequence)", ", result) + "]";
    }

    static class locationRecordStore {
        String locationVariableName;
        String locationVariableValue;
        String classInProgressWhenRecorded;

        locationRecordStore(String locationVariableName, String locationVariableValue, String classInProgressWhenRecorded) {
            this.locationVariableName = locationVariableName.trim();
            this.locationVariableValue = locationVariableValue.trim();
            this.classInProgressWhenRecorded = classInProgressWhenRecorded.trim();
        }

        String getLocationVariableName() {
            return this.locationVariableName;
        }

        String getLocationVariableValue() {
            return this.locationVariableValue;
        }

        String getClassInProgressWhenRecorded() {
            return this.classInProgressWhenRecorded;
        }

        public String toString() {
            return " Variable Name: " + this.getLocationVariableName() + ", Value and Type: " + this.getLocationVariableValue() + ", Class in progress when recorded: " + this.getClassInProgressWhenRecorded();
        }

        public int hashCode() {
            int hash = 3;
            hash = 67 * hash + Objects.hashCode(this.locationVariableName);
            hash = 67 * hash + Objects.hashCode(this.locationVariableValue);
            return hash;
        }

        public boolean equals(Object o) {
            boolean returnValue = false;
            if (o == this) {
                returnValue = true;
            } else if (!(o instanceof locationRecordStore)) {
                returnValue = false;
            } else if (((locationRecordStore)o).getLocationVariableName().equals(this.locationVariableName) && ((locationRecordStore)o).getLocationVariableValue().equals(this.locationVariableValue)) {
                returnValue = true;
            }
            return returnValue;
        }
    }

    static class processedBusInfoStore {
        String name;
        String type;
        Object valuesAndType;
        String oldPathName;
        String newPathName;
        String replacedPattern;
        boolean ifPatternReplaced;
        String replacedWith;
        int counts;

        processedBusInfoStore(String name, String type, String oldPathName, String newPathName, boolean ifPatternReplaced, String replacedPattern, String replacedWith, Object valuesAndType) {
            this.name = name;
            this.type = type;
            this.valuesAndType = valuesAndType;
            this.oldPathName = oldPathName;
            this.newPathName = newPathName;
            this.replacedPattern = replacedPattern;
            this.replacedWith = replacedWith;
            this.ifPatternReplaced = ifPatternReplaced;
        }

        String getName() {
            return this.name;
        }

        String getType() {
            return this.type;
        }

        boolean getIfPatternReplaced() {
            return this.ifPatternReplaced;
        }

        String getReplacedWith() {
            return this.replacedWith;
        }

        String getOldPathName() {
            return this.oldPathName;
        }

        String getNewPathName() {
            return this.newPathName;
        }

        String getReplacedPattern() {
            return this.replacedPattern;
        }

        Object getValuesAndType() {
            return this.valuesAndType;
        }

        public String toString() {
            return this.getName();
        }
    }
}

