/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class ShutterSubsystemLayer {
    private static final Logger LOG = Logger.getLogger(ShutterSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private String imageName;

    ShutterSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void expose(Duration exposeTime) {
        this.sendCommand("takeExposure " + (double)exposeTime.toMillis() / 1000.0);
        this.sendCommand("waitForExposure", exposeTime.plus(Duration.ofSeconds(10L)));
    }

    void start(String configName) {
        try {
            AgentLockService agentService = (AgentLockService)this.mcm.getAgentService(AgentLockService.class);
            agentService.setLevelForAgent(this.config.getShutterSubsystemName(), 10);
            this.sendCommand("publishConfigurationInfo");
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new RuntimeException("Faild to lock subsystem " + this.config.getShutterSubsystemName(), x);
        }
    }

    private void sendCommand(String command) {
        CommandRequest request = new CommandRequest(this.config.getShutterSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }

    private void sendCommand(String command, Duration timeout) {
        CommandRequest request = new CommandRequest(this.config.getShutterSubsystemName(), command);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            cmu.sendSynchronousCommand(request, timeout);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
        }
    }
}

