/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;

public class MCMConfig {
    @ConfigurationParameter
    private volatile boolean hasFilterChanger = true;
    @ConfigurationParameter
    private volatile int maxImagesPerSequence = 10;
    @ConfigurationParameter
    private volatile double minExposeTime = 1.0;
    @ConfigurationParameter
    private volatile double maxExposeTime = 30.0;
    @ConfigurationParameter
    private volatile String focalPlaneSubsystemName;
    @ConfigurationParameter
    private volatile String shutterSubsystemName;
    @ConfigurationParameter
    private volatile Camera cameraType = Camera.MAIN_CAMERA;
    @ConfigurationParameter(maxLength=100)
    private volatile Set<String> requiredKeywords = new HashSet<String>(Arrays.asList("imageType", "groupId"));
    @ConfigurationParameter(maxLength=100)
    private volatile Set<String> allowedKeywords = new HashSet<String>(Arrays.asList("testType"));

    MCMConfig() {
    }

    public MCMConfig(Camera cameraType) {
        this.cameraType = cameraType;
    }

    public boolean hasFilterChanger() {
        return this.hasFilterChanger;
    }

    public String getFocalPlaneSubsystemName() {
        return this.focalPlaneSubsystemName;
    }

    boolean hasFocalPlaneSubsystem() {
        return this.getFocalPlaneSubsystemName() != null && !this.getFocalPlaneSubsystemName().trim().isEmpty();
    }

    public String getShutterSubsystemName() {
        return this.shutterSubsystemName;
    }

    public int getMaxImagesPerSequence() {
        return this.maxImagesPerSequence;
    }

    public double getMinExposeTime() {
        return this.minExposeTime;
    }

    public double getMaxExposeTime() {
        return this.maxExposeTime;
    }

    public Camera getCameraType() {
        return this.cameraType;
    }

    Set<String> getRequiredKeys() {
        return this.requiredKeywords;
    }

    Set<String> getAllowedKeys() {
        return new HashSet<String>(){
            {
                this.addAll(MCMConfig.this.requiredKeywords);
                this.addAll(MCMConfig.this.allowedKeywords);
            }
        };
    }

    public static MCMConfig createDefaultConfig() {
        return new MCMConfig();
    }

    public static enum Camera {
        MAIN_CAMERA,
        COMCAM,
        AUXTEL;

    }
}

