package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

/**
 * An interface for talking to a real rafts subsystem.
 * Temporary for DAQ-DM_FILES exercise
 * @author tonyj
 */
class RaftsSubsystemLayer {

    private static final Logger LOG = Logger.getLogger(RaftsSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private ImageName imageName;
    private String imageType;
    private String groupId;
    
    RaftsSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void acquireImage(Duration exposure) {
        sendCommand("setSequencerStart ReadFrame");
        sendCommand("acquireImage "+imageName);
        // TODO: We need to handle timeout here
        sendCommand("waitForImage 60000");
//        if (config.getFitsDir() != null) {
//            // Used to set FITS header
//            sendCommand("setExposureTime "+exposure.toMillis()/1000.);
//            //TODO: These fail if the imageType or groupId have spacees!
//            sendCommand("setPrimaryHeaderKeyword ImageType "+imageType);
//            sendCommand("setPrimaryHeaderKeyword GroupId "+groupId);
//            sendCommand("setFitsFileNamePattern ${imageName}.fits");
//            // TODO: With newer version of Rafts the date string can be part of config.
//            sendCommand("saveFitsImage "+config.getFitsDir()+"/"+imageName.getDateString());
//        }
    }

    void startIntegration(ImageName imageName, String imageType, String groupId) {
        this.imageName = imageName;
        this.imageType = imageType;
        this.groupId = groupId;
        // Currently there is no integration sequencer procedure
        // so nothing to do
    }
    
    void start(String configName) {
//        try {
//            AgentLockService agentService = mcm.getAgentService(AgentLockService.class);
//            agentService.setLevelForAgent(config.getRaftsSubsystemName(), 10);
//            sendCommand("loadSequencer "+config.getSequencerFile());
//            sendCommand("loadConfiguration "+config.getRaftsConfiguration());
//            sendCommand("loadAspics true");
//            sendCommand("loadDacs true");
//            sendCommand("loadBiasDacs true");
//            sendCommand("publishConfigurationInfo");
//        } catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
//            throw new RuntimeException("Failed to lock subsystem "+config.getRaftsSubsystemName(), x);
//        }
    }
    
    void clear(int nClears) {
        sendCommand("setSequencerParameter ClearCount "+nClears);
        sendCommand("setSequencerStart Clear");
        sendCommand("startSequencer");
        // TODO: We need to handle timeout here
        sendCommand("waitSequencerDone 60000", Duration.ofSeconds(60));                
    }

    private void sendCommand(String command) {
//        CommandRequest request = new CommandRequest(config.getRaftsSubsystemName(), command);
//        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(mcm.getMessagingAccess());
//        try {
//            cmu.sendSynchronousCommand(request);
//        } catch (Exception ex) {
//            // TODO: Fix me, we need to do something better here
//            LOG.log(Level.SEVERE, "Error executing command", ex);
//        }
    }

    private void sendCommand(String command, Duration timeout) {
//        CommandRequest request = new CommandRequest(config.getRaftsSubsystemName(), command);
//        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(mcm.getMessagingAccess());
//        try {
//            cmu.sendSynchronousCommand(request, timeout);
//        } catch (Exception ex) {
//            // TODO: Fix me, we need to do something better here
//            LOG.log(Level.SEVERE, "Error executing command", ex);
//        }
    }
}
