/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.lsst.ccs.bus.data.KeyValueData;
import org.lsst.ccs.bus.data.KeyValueDataList;
import org.lsst.ccs.bus.messages.StatusSubsystemData;
import org.lsst.ccs.subsystem.ocsbridge.util.GenericConverter;
import org.lsst.sal.atcamera.telemetry.Fp_CcdTelemetry;
import org.lsst.sal.atcamera.telemetry.Fp_RebTotalPowerTelemetry;
import org.lsst.sal.atcamera.telemetry.VacuumTelemetry;
import org.lsst.sal.atcamera.telemetry.WrebPowerTelemetry;
import org.lsst.sal.camera.CameraTelemetry;
import org.lsst.sal.camera.telemetry.Daq_monitor_StoreTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_CryoVacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_ForelineVacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex1VacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_Hex2VacGaugeTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboPumpTelemetry;
import org.lsst.sal.camera.telemetry.Vacuum_TurboVacGaugeTelemetry;
import org.lsst.sal.cccamera.telemetry.Fp_RebTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold1Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_Cold2Telemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_CryoTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_IonPumpsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_RtdsTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_TurboTelemetry;
import org.lsst.sal.cccamera.telemetry.Vacuum_VQMonitorTelemetry;

public class TelemetryConverterTest {
    @Test
    public void ComCamDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("comcam-daq-monitor-trending.ser");
        Assert.assertEquals((Object)"comcam-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<Daq_monitor_StoreTelemetry>, String> subSystemClasses = new HashMap<Class<Daq_monitor_StoreTelemetry>, String>();
        subSystemClasses.put(Daq_monitor_StoreTelemetry.class, "comcam-daq-monitor");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        Assert.assertTrue((boolean)(telemetry instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
        Assert.assertEquals((double)483.1838073730469, (double)dst.getCapacity(), (double)1.0E-5);
        Assert.assertEquals((double)144.95724487304688, (double)dst.getFreeSpace(), (double)1.0E-5);
        Assert.assertEquals((double)0.3000043516796315, (double)dst.getFreeFraction(), (double)1.0E-5);
    }

    @Test
    public void MainCameraDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("daq-monitor-trending.ser");
        HashMap<Class<Daq_monitor_StoreTelemetry>, String> subSystemClasses = new HashMap<Class<Daq_monitor_StoreTelemetry>, String>();
        subSystemClasses.put(Daq_monitor_StoreTelemetry.class, "daq-monitor");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        Assert.assertTrue((boolean)(telemetry instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
        Assert.assertEquals((double)7730.94091796875, (double)dst.getCapacity(), (double)1.0E-5);
        Assert.assertEquals((double)1875.3760986328125, (double)dst.getFreeSpace(), (double)1.0E-5);
        Assert.assertEquals((double)0.24258057570637265, (double)dst.getFreeFraction(), (double)1.0E-5);
    }

    @Test
    public void AuxTelDaqMonitorTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("ats-daq-monitor-trending.ser");
        Assert.assertEquals((Object)"ats-daq-monitor", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<Daq_monitor_StoreTelemetry>, String> subSystemClasses = new HashMap<Class<Daq_monitor_StoreTelemetry>, String>();
        subSystemClasses.put(Daq_monitor_StoreTelemetry.class, "ats-daq-monitor");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        CameraTelemetry telemetry = (CameraTelemetry)converted.get(0);
        Assert.assertTrue((boolean)(telemetry instanceof Daq_monitor_StoreTelemetry));
        Daq_monitor_StoreTelemetry dst = (Daq_monitor_StoreTelemetry)telemetry;
        Assert.assertEquals((double)322.12255859375, (double)dst.getCapacity(), (double)1.0E-5);
        Assert.assertEquals((double)314.9219665527344, (double)dst.getFreeSpace(), (double)1.0E-5);
        Assert.assertEquals((double)0.9776464210626838, (double)dst.getFreeFraction(), (double)1.0E-5);
    }

    @Test
    public void ComCamVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("comcam-vacuum-trending.ser");
        Assert.assertEquals((Object)"comcam-vacuum", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<Vacuum_RtdsTelemetry>, String> subSystemClasses = new HashMap<Class<Vacuum_RtdsTelemetry>, String>();
        subSystemClasses.put(Vacuum_Cold1Telemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_Cold2Telemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_CryoTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_TurboTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_VQMonitorTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_IonPumpsTelemetry.class, "comcam-vacuum");
        subSystemClasses.put(Vacuum_RtdsTelemetry.class, "comcam-vacuum");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)6L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            if (telemetry instanceof Vacuum_VQMonitorTelemetry) {
                Vacuum_VQMonitorTelemetry vqm = (Vacuum_VQMonitorTelemetry)telemetry;
                Assert.assertEquals((double)8.46E-8, (double)vqm.getVqmpressure(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_TurboTelemetry) {
                Vacuum_TurboTelemetry turbo = (Vacuum_TurboTelemetry)telemetry;
                Assert.assertEquals((double)13.0, (double)turbo.getPumpTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold1Telemetry) {
                Vacuum_Cold1Telemetry cold1 = (Vacuum_Cold1Telemetry)telemetry;
                Assert.assertEquals((double)-91.51, (double)cold1.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Cold2Telemetry) {
                Vacuum_Cold2Telemetry cold2 = (Vacuum_Cold2Telemetry)telemetry;
                Assert.assertEquals((double)-86.39, (double)cold2.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_CryoTelemetry) {
                Vacuum_CryoTelemetry cryo = (Vacuum_CryoTelemetry)telemetry;
                Assert.assertEquals((double)-145.01, (double)cryo.getTemperature(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_RtdsTelemetry) {
                Vacuum_RtdsTelemetry rtds = (Vacuum_RtdsTelemetry)telemetry;
                Assert.assertEquals((double)-58.764938, (double)rtds.getTemperatureCold1(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("ats-trending.ser");
        Assert.assertEquals((Object)"ats", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<VacuumTelemetry>, String> subSystemClasses = new HashMap<Class<VacuumTelemetry>, String>();
        subSystemClasses.put(VacuumTelemetry.class, "ats");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Assert.assertTrue((boolean)(converted.get(0) instanceof VacuumTelemetry));
        VacuumTelemetry vt = (VacuumTelemetry)converted.get(0);
        Assert.assertEquals((double)-94.1477, (double)vt.getTempCCD(), (double)1.0E-5);
        Assert.assertEquals((double)-114.7494, (double)vt.getTempColdPlate(), (double)1.0E-5);
        Assert.assertEquals((double)-140.4627, (double)vt.getTempCryoHead(), (double)1.0E-5);
        Assert.assertEquals((double)3.6E-6, (double)vt.getVacuum(), (double)1.0E-5);
        Assert.assertEquals((double)-94.15, (double)vt.getTempCCDSetPoint(), (double)1.0E-5);
    }

    @Test
    public void AuxTelPowerTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("ats-power-trending.ser");
        Assert.assertEquals((Object)"ats-power", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<WrebPowerTelemetry>, String> subSystemClasses = new HashMap<Class<WrebPowerTelemetry>, String>();
        subSystemClasses.put(WrebPowerTelemetry.class, "ats-power");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Assert.assertTrue((boolean)(converted.get(0) instanceof WrebPowerTelemetry));
        WrebPowerTelemetry pt = (WrebPowerTelemetry)converted.get(0);
        Assert.assertEquals((double)5.25, (double)pt.getDigital_V(), (double)1.0E-5);
        Assert.assertEquals((double)665.5, (double)pt.getDigital_I(), (double)1.0E-5);
        Assert.assertEquals((double)7.2, (double)pt.getAnalog_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getClkHigh_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getClkLow_V(), (double)1.0E-5);
        Assert.assertEquals((double)32.05, (double)pt.getOd_V(), (double)1.0E-5);
        Assert.assertEquals((double)10.0, (double)pt.getDphi_V(), (double)1.0E-5);
        Assert.assertEquals((double)12.0, (double)pt.getFan_V(), (double)1.0E-5);
    }

    @Test
    public void MainCameraVacuumTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("vacuum-trending.ser");
        Assert.assertEquals((Object)"vacuum", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<Vacuum_TurboVacGaugeTelemetry>, String> subSystemClasses = new HashMap<Class<Vacuum_TurboVacGaugeTelemetry>, String>();
        subSystemClasses.put(Vacuum_CryoVacGaugeTelemetry.class, "vacuum");
        subSystemClasses.put(Vacuum_ForelineVacGaugeTelemetry.class, "vacuum");
        subSystemClasses.put(Vacuum_Hex1VacGaugeTelemetry.class, "vacuum");
        subSystemClasses.put(Vacuum_Hex2VacGaugeTelemetry.class, "vacuum");
        subSystemClasses.put(org.lsst.sal.camera.telemetry.Vacuum_IonPumpsTelemetry.class, "vacuum");
        subSystemClasses.put(Vacuum_TurboPumpTelemetry.class, "vacuum");
        subSystemClasses.put(Vacuum_TurboVacGaugeTelemetry.class, "vacuum");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)7L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            Vacuum_TurboVacGaugeTelemetry turbo;
            if (telemetry instanceof Vacuum_CryoVacGaugeTelemetry) {
                Vacuum_CryoVacGaugeTelemetry cryo = (Vacuum_CryoVacGaugeTelemetry)telemetry;
                Assert.assertEquals((double)7.9E-8, (double)cryo.getCryoVac(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Hex1VacGaugeTelemetry) {
                Vacuum_Hex1VacGaugeTelemetry hex1 = (Vacuum_Hex1VacGaugeTelemetry)telemetry;
                Assert.assertEquals((double)7.7E-8, (double)hex1.getHex1Vac(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_Hex2VacGaugeTelemetry) {
                Vacuum_Hex2VacGaugeTelemetry hex2 = (Vacuum_Hex2VacGaugeTelemetry)telemetry;
                Assert.assertEquals((double)9.304E-5, (double)hex2.getHex2Vac(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_TurboVacGaugeTelemetry) {
                turbo = (Vacuum_TurboVacGaugeTelemetry)telemetry;
                Assert.assertEquals((double)1.8E-8, (double)turbo.getTurboVac(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_TurboPumpTelemetry) {
                turbo = (Vacuum_TurboPumpTelemetry)telemetry;
                Assert.assertEquals((double)60600.0, (double)turbo.getTurboSpeed(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof org.lsst.sal.camera.telemetry.Vacuum_IonPumpsTelemetry) {
                org.lsst.sal.camera.telemetry.Vacuum_IonPumpsTelemetry ionPumps = (org.lsst.sal.camera.telemetry.Vacuum_IonPumpsTelemetry)telemetry;
                Assert.assertEquals((double)5993.3462, (double)ionPumps.getCip1_V(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Vacuum_ForelineVacGaugeTelemetry) {
                Vacuum_ForelineVacGaugeTelemetry foreline = (Vacuum_ForelineVacGaugeTelemetry)telemetry;
                Assert.assertEquals((double)0.00219, (double)foreline.getForelineVac(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data1 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data1.getOriginAgentInfo().getName());
        StatusSubsystemData data2 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW_rebTemp-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data2.getOriginAgentInfo().getName());
        KeyValueDataList kvdl = (KeyValueDataList)data1.getSubsystemData();
        KeyValueDataList kvdl2 = (KeyValueDataList)data2.getSubsystemData();
        for (KeyValueData kvd : kvdl2.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
        StatusSubsystemData data3 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW_aspicTemp-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data3.getOriginAgentInfo().getName());
        KeyValueDataList kvdl3 = (KeyValueDataList)data3.getSubsystemData();
        for (KeyValueData kvd : kvdl3.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
        StatusSubsystemData data4 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data4.getOriginAgentInfo().getName());
        KeyValueDataList kvdl4 = (KeyValueDataList)data4.getSubsystemData();
        for (KeyValueData kvd : kvdl4.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
        StatusSubsystemData data5 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW_crVolt-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data5.getOriginAgentInfo().getName());
        KeyValueDataList kvdl5 = (KeyValueDataList)data5.getSubsystemData();
        for (KeyValueData kvd : kvdl5.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
        StatusSubsystemData data6 = TelemetryConverterTest.readData("ats-fp-default-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data6.getOriginAgentInfo().getName());
        KeyValueDataList kvdl6 = (KeyValueDataList)data6.getSubsystemData();
        for (KeyValueData kvd : kvdl6.getListOfKeyValueData()) {
            kvdl.addData(kvd);
        }
        HashMap<Class<Fp_RebTotalPowerTelemetry>, String> subSystemClasses = new HashMap<Class<Fp_RebTotalPowerTelemetry>, String>();
        subSystemClasses.put(Fp_CcdTelemetry.class, "ats-fp");
        subSystemClasses.put(org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry.class, "ats-fp");
        subSystemClasses.put(Fp_RebTotalPowerTelemetry.class, "ats-fp");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data1);
        Assert.assertEquals((long)3L, (long)converted.size());
        for (CameraTelemetry telemetry : converted) {
            org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry fpt;
            if (telemetry instanceof org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry) {
                fpt = (org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry)telemetry;
                Assert.assertEquals((double)362.0116882324219, (double)fpt.getRTDTemp(), (double)1.0E-5);
                Assert.assertEquals((double)28.5, (double)fpt.getTemp1(), (double)1.0E-5);
                Assert.assertEquals((double)29.5625, (double)fpt.getTemp2(), (double)1.0E-5);
                Assert.assertEquals((double)28.4375, (double)fpt.getTemp3(), (double)1.0E-5);
                Assert.assertEquals((double)27.6875, (double)fpt.getTemp4(), (double)1.0E-5);
                Assert.assertEquals((double)27.25, (double)fpt.getTemp5(), (double)1.0E-5);
                Assert.assertEquals((double)27.0625, (double)fpt.getTemp6(), (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicu_Temp0(), (double)1.0E-5);
                Assert.assertEquals((double)18.995535, (double)fpt.getAspicl_Temp0(), (double)1.0E-5);
                Assert.assertEquals((double)5.275, (double)fpt.getDigV(), (double)1.0E-5);
                Assert.assertEquals((double)697.0, (double)fpt.getDigI(), (double)1.0E-5);
                Assert.assertEquals((double)7.2, (double)fpt.getAnaV(), (double)1.0E-5);
                Assert.assertEquals((double)345.0, (double)fpt.getAnaI(), (double)1.0E-5);
                Assert.assertEquals((double)12.025, (double)fpt.getClkHV(), (double)1.0E-5);
                Assert.assertEquals((double)31.25, (double)fpt.getClkHI(), (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV(), (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI(), (double)1.0E-5);
                Assert.assertEquals((double)32.05, (double)fpt.getODV(), (double)1.0E-5);
                Assert.assertEquals((double)30.0, (double)fpt.getODI(), (double)1.0E-5);
                Assert.assertEquals((double)7.49795625, (double)fpt.getPower(), (double)1.0E-5);
                Assert.assertEquals((Object)"R00RebW", (Object)fpt.getLocation());
                Assert.assertEquals((double)-11.97925537109375, (double)fpt.getClkLV(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Fp_RebTotalPowerTelemetry) {
                fpt = (Fp_RebTotalPowerTelemetry)telemetry;
                Assert.assertEquals((double)7.4979563, (double)fpt.getRebTotalPower(), (double)1.0E-5);
                continue;
            }
            if (telemetry instanceof Fp_CcdTelemetry) {
                fpt = (Fp_CcdTelemetry)telemetry;
                Assert.assertEquals((double)25.03779052734375, (double)fpt.getODV(), (double)1.0E-5);
                continue;
            }
            Assert.fail((String)("Unexpected telemetry " + telemetry));
        }
    }

    @Test
    public void AuxTelFocalPlaneTest2() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data1 = TelemetryConverterTest.readData("ats-fp-default_R00_RebW_boardPower-trending.ser");
        Assert.assertEquals((Object)"ats-fp", (Object)data1.getOriginAgentInfo().getName());
        HashMap<Class<Fp_RebTotalPowerTelemetry>, String> subSystemClasses = new HashMap<Class<Fp_RebTotalPowerTelemetry>, String>();
        subSystemClasses.put(Fp_CcdTelemetry.class, "ats-fp");
        subSystemClasses.put(org.lsst.sal.atcamera.telemetry.Fp_RebTelemetry.class, "ats-fp");
        subSystemClasses.put(Fp_RebTotalPowerTelemetry.class, "ats-fp");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data1);
        Assert.assertEquals((long)2L, (long)converted.size());
    }

    @Test
    public void ComCamFocalPlaneTest() throws IOException, ClassNotFoundException, ReflectiveOperationException {
        StatusSubsystemData data = TelemetryConverterTest.readData("comcam-fp-trending.ser");
        Assert.assertEquals((Object)"comcam-fp", (Object)data.getOriginAgentInfo().getName());
        HashMap<Class<Fp_RebTelemetry>, String> subSystemClasses = new HashMap<Class<Fp_RebTelemetry>, String>();
        subSystemClasses.put(Fp_RebTelemetry.class, "comcam-fp");
        GenericConverter converter = new GenericConverter(subSystemClasses, Collections.EMPTY_MAP, Collections.EMPTY_MAP);
        List converted = converter.telemetryConverter(data);
        Assert.assertEquals((long)1L, (long)converted.size());
        Fp_RebTelemetry fpTelemetry = (Fp_RebTelemetry)converted.get(0);
        Assert.assertEquals((long)1L, (long)fpTelemetry.getHVBiasSwitch().length);
        Assert.assertEquals((long)0L, (long)fpTelemetry.getTemp1().length);
        Assert.assertEquals((long)0L, (long)fpTelemetry.getODI().length);
    }

    /*
     * Exception decompiling
     */
    public static StatusSubsystemData readData(String fileName) throws IOException, ClassNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

