package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.Map;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.location.LocationSet;

/**
 * Interface to be implemented by subsystems which can take images
 * @author tonyj
 */
public interface ImageTaking {

    void clear(int nClears);

    void endIntegration(boolean readout, Duration exposure);

    /**
     * Called when the MCM receives a start command.
     * @param configName
     */
    void start(String configName);

    void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation);    
}
