/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.time.Duration;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;

class RaftsSubsystemLayer {
    private static final Logger LOG = Logger.getLogger(RaftsSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private ImageName imageName;
    private String imageType;
    private String groupId;

    RaftsSubsystemLayer(Subsystem mcm, CCS ccs, MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
    }

    void acquireImage(Duration exposure) {
        this.sendCommand("setSequencerStart ReadFrame");
        this.sendCommand("acquireImage " + this.imageName);
        this.sendCommand("waitForImage 60000");
    }

    void startIntegration(ImageName imageName, String imageType, String groupId) {
        this.imageName = imageName;
        this.imageType = imageType;
        this.groupId = groupId;
    }

    void start(String configName) {
    }

    void clear(int nClears) {
        this.sendCommand("setSequencerParameter ClearCount " + nClears);
        this.sendCommand("setSequencerStart Clear");
        this.sendCommand("startSequencer");
        this.sendCommand("waitSequencerDone 60000", Duration.ofSeconds(60L));
    }

    private void sendCommand(String command) {
    }

    private void sendCommand(String command, Duration timeout) {
    }
}

