package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.lsst.ccs.commons.annotations.ConfigurationParameter;

/**
 * Configuration class to hold parameters for the MCM
 *
 * @author Farrukh Azfar
 */
@SuppressWarnings("FieldMayBeFinal")
public class MCMConfig {

    public enum Camera {
        MAIN_CAMERA, COMCAM, AUXTEL
    };

    @ConfigurationParameter
    private volatile boolean hasFilterChanger = true;
    
    @ConfigurationParameter
    private volatile int maxImagesPerSequence = 10;
    
    @ConfigurationParameter
    private volatile double minExposeTime = 1.0;
    
    @ConfigurationParameter
    private volatile double maxExposeTime = 30.0;
    
    @ConfigurationParameter
    private volatile String focalPlaneSubsystemName;

    @ConfigurationParameter
    private volatile String shutterSubsystemName;

    @ConfigurationParameter
    private volatile Camera cameraType = Camera.MAIN_CAMERA;

    @ConfigurationParameter(maxLength = 100)
    private volatile Set<String> requiredKeywords = new HashSet<>(Arrays.asList("imageType", "groupId"));

    @ConfigurationParameter(maxLength = 100)
    private volatile Set<String> allowedKeywords = new HashSet<>(Arrays.asList("testType"));

    MCMConfig() {

    }

    public MCMConfig(Camera cameraType) {
        this.cameraType = cameraType;

    }

    public boolean hasFilterChanger() {
        return hasFilterChanger;
    }

    public String getFocalPlaneSubsystemName() {
        return focalPlaneSubsystemName;
    }

    boolean hasFocalPlaneSubsystem() {
        return getFocalPlaneSubsystemName() != null && !getFocalPlaneSubsystemName().trim().isEmpty();
    }

    public String getShutterSubsystemName() {
        return shutterSubsystemName;
    }

    public int getMaxImagesPerSequence() {
        return maxImagesPerSequence;
    }

    public double getMinExposeTime() {
        return minExposeTime;
    }

    public double getMaxExposeTime() {
        return maxExposeTime;
    }

    public Camera getCameraType() {
        return cameraType;
    }

    Set<String> getRequiredKeys() {
        return requiredKeywords;
    }

    Set<String> getAllowedKeys() {
        return new HashSet<String>() {
            {
                addAll(requiredKeywords);
                addAll(allowedKeywords);
            }
        };
    }

    public static MCMConfig createDefaultConfig() {
        return new MCMConfig();
    }
}
