package org.lsst.ccs.subsystem.ocsbridge.sim;

import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import java.time.Duration;
import java.util.Map;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.utilities.location.LocationSet;

/**

* <ol>
 * <li>If focalPlaneSubsystem is null (the default) it simulates all focalPlane operations within
 * this class</li>
 * <li>If focalPlaneSubsystem is specified, it delegates the operations to the specified subsystem</li> 
 * </ol>
 *
 * @author tonyj
 */
public class FocalPlane implements ImageTaking {

    private final CCS ccs;
    private FocalPlaneSubsystemLayer focalPlaneSubsystem;

    FocalPlane(CCS ccs) {
        this.ccs = ccs;
    }

    @Override
    public void clear(int nClears) {
       focalPlaneSubsystem.clear(nClears);
    }
    
    @Override
    public void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) {
        focalPlaneSubsystem.startIntegration(imageName, parsedKeyValueData, locations, annotation);
    }

    @Override
    public void endIntegration(boolean readout, Duration exposure) {
        focalPlaneSubsystem.endIntegration(readout, exposure);
    }

    /**
     * Called when the MCM receives a start command.
     * @param configName 
     */
    @Override
   public void start(String configName) {        
        focalPlaneSubsystem.start(configName);
    }

    void setFocalPlaneSubsystem(FocalPlaneSubsystemLayer focalPlaneSubsystem) {
        this.focalPlaneSubsystem = focalPlaneSubsystem;
    }
}
