/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.lsst.ccs.subsystem.ocsbridge.CCSCommand;
import org.lsst.sal.camera.CameraCommand;
import org.lsst.sal.camera.command.ClearCommand;
import org.lsst.sal.camera.command.DisableCalibrationCommand;
import org.lsst.sal.camera.command.DiscardRowsCommand;
import org.lsst.sal.camera.command.EnableCalibrationCommand;
import org.lsst.sal.camera.command.EndImageCommand;
import org.lsst.sal.camera.command.InitGuidersCommand;
import org.lsst.sal.camera.command.InitImageCommand;
import org.lsst.sal.camera.command.SetFilterCommand;
import org.lsst.sal.camera.command.StartCommand;
import org.lsst.sal.camera.command.StartImageCommand;
import org.lsst.sal.camera.command.TakeImagesCommand;

public class OCSCommandConverter {
    private final Map<Class<? extends CameraCommand>, Class<? extends CCSCommand>> map = new HashMap<Class<? extends CameraCommand>, Class<? extends CCSCommand>>();

    public OCSCommandConverter() {
        this.map.put(SetFilterCommand.class, CCSCommand.CCSSetFilterCommand.class);
        this.map.put(ClearCommand.class, CCSCommand.CCSClearCommand.class);
        this.map.put(EndImageCommand.class, CCSCommand.CCSEndImageCommand.class);
        this.map.put(InitGuidersCommand.class, CCSCommand.CCSInitGuidersCommand.class);
        this.map.put(StartImageCommand.class, CCSCommand.CCSStartImageCommand.class);
        this.map.put(TakeImagesCommand.class, CCSCommand.CCSTakeImagesCommand.class);
        this.map.put(StartCommand.class, CCSCommand.CCSStartCommand.class);
        this.map.put(DisableCalibrationCommand.class, CCSCommand.CCSDisableCalibrationCommand.class);
        this.map.put(DiscardRowsCommand.class, CCSCommand.CCSDiscardRowsCommand.class);
        this.map.put(InitImageCommand.class, CCSCommand.CCSInitImageCommand.class);
        this.map.put(EnableCalibrationCommand.class, CCSCommand.CCSEnableCalibrationCommand.class);
    }

    public CCSCommand convert(CameraCommand myOCSCommand) {
        Class<? extends CCSCommand> ccsCommandFromMap = this.map.get(((Object)((Object)myOCSCommand)).getClass());
        CCSCommand ccsCommand = null;
        try {
            boolean commanNameDifferentType = false;
            ccsCommand = ccsCommandFromMap.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Field[] ocsCommandFields = ((Object)((Object)myOCSCommand)).getClass().getDeclaredFields();
            Field[] ccsCommandFields = ccsCommand.getClass().getDeclaredFields();
            boolean matchFound = true;
            for (Field ocsCommandField : ocsCommandFields) {
                if (!matchFound) {
                    throw new RuntimeException("OCSCommandCoverter : no match found between OCS CCS fields, OCSCommand:  " + ((Object)((Object)myOCSCommand)).toString() + " CCSCommand : " + ccsCommand.toString());
                }
                matchFound = false;
                for (Field ccsCommandField : ccsCommandFields) {
                    if (ocsCommandField.isSynthetic() || ccsCommandField.isSynthetic()) continue;
                    ccsCommandField.setAccessible(true);
                    ocsCommandField.setAccessible(true);
                    if (ocsCommandField.getName().equals(ccsCommandField.getName()) && !ocsCommandField.getType().equals(ccsCommandField.getType())) {
                        throw new RuntimeException("OCSCommandConverter: OCS and CCS Commands contain the same variable names with different types");
                    }
                    if (!ocsCommandField.getType().equals(ccsCommandField.getType()) || !ocsCommandField.getName().equals(ccsCommandField.getName())) continue;
                    ccsCommandField.set(ccsCommand, ocsCommandField.get((Object)myOCSCommand));
                    matchFound = true;
                }
            }
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Error converting command : ", ex);
        }
        return ccsCommand;
    }
}

