/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.sim;

import java.io.IOException;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lsst.ccs.Subsystem;
import org.lsst.ccs.bus.data.AgentInfo;
import org.lsst.ccs.bus.messages.CommandRequest;
import org.lsst.ccs.bus.messages.StatusMessage;
import org.lsst.ccs.bus.messages.StatusStateChangeNotification;
import org.lsst.ccs.bus.states.StateBundle;
import org.lsst.ccs.imagenaming.ImageName;
import org.lsst.ccs.messaging.AgentPresenceListener;
import org.lsst.ccs.messaging.BusMessageFilterFactory;
import org.lsst.ccs.messaging.ConcurrentMessagingUtils;
import org.lsst.ccs.services.AgentLockService;
import org.lsst.ccs.services.UnauthorizedLevelException;
import org.lsst.ccs.services.UnauthorizedLockException;
import org.lsst.ccs.subsystem.focalplane.states.FocalPlaneState;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCMConfig;
import org.lsst.ccs.subsystem.ocsbridge.sim.Rafts;
import org.lsst.ccs.subsystem.ocsbridge.util.CCS;
import org.lsst.ccs.subsystem.ocsbridge.util.State;
import org.lsst.ccs.utilities.location.LocationSet;

class FocalPlaneSubsystemLayer {
    private static final Logger LOG = Logger.getLogger(FocalPlaneSubsystemLayer.class.getName());
    private final Subsystem mcm;
    private final CCS ccs;
    private final MCMConfig config;
    private static final Map<Enum<FocalPlaneState>, Enum<Rafts.RaftsState>> FOCALPLANE_TO_RAFTS_STATE = new HashMap<Enum<FocalPlaneState>, Enum<Rafts.RaftsState>>();

    FocalPlaneSubsystemLayer(Subsystem mcm, CCS ccs, final MCMConfig config) {
        this.mcm = mcm;
        this.ccs = ccs;
        this.config = config;
        Predicate stateChangeFilter = BusMessageFilterFactory.messageOrigin((String)config.getFocalPlaneSubsystemName()).and(BusMessageFilterFactory.messageClass(StatusStateChangeNotification.class));
        mcm.getMessagingAccess().addStatusMessageListener(msg -> this.handleStatusChangeMessage(msg), stateChangeFilter);
        mcm.getMessagingAccess().getAgentPresenceManager().addAgentPresenceListener(new AgentPresenceListener(){

            public void connected(AgentInfo ... agents) {
                for (AgentInfo agent : agents) {
                    if (!agent.getName().equals(config.getFocalPlaneSubsystemName())) continue;
                    StateBundle result = (StateBundle)FocalPlaneSubsystemLayer.this.sendCommand("getState", new Object[0]);
                    FocalPlaneState state = (FocalPlaneState)result.getState(FocalPlaneState.class);
                    FocalPlaneSubsystemLayer.this.translateFocalPlaneStateToRaftsState((Enum)state);
                }
            }
        });
    }

    void endIntegration(boolean readout, Duration exposure) {
        HashMap<String, Double> meta = new HashMap<String, Double>();
        meta.put("ExposureTime", (double)exposure.toMillis() / 1000.0);
        this.sendCommand("setHeaderKeywords", meta);
        this.sendCommand("endIntegration", new Object[0]);
    }

    void startIntegration(ImageName imageName, Map<String, String> parsedKeyValueData, LocationSet locations, String annotation) {
        String imageType = parsedKeyValueData.get("imageType");
        String testType = parsedKeyValueData.get("testType");
        String groupId = parsedKeyValueData.get("groupId");
        HashMap<String, String> meta = new HashMap<String, String>();
        meta.put("GroupId", groupId);
        meta.put("ImageType", imageType);
        if (testType != null) {
            meta.put("TestType", testType);
        }
        this.sendCommand("setHeaderKeywords", meta);
        this.sendCommand("startNamedIntegration", imageName, annotation, locations);
    }

    void start(String configName) {
        try {
            AgentLockService agentService = (AgentLockService)this.mcm.getAgentService(AgentLockService.class);
            agentService.setLevelForAgent(this.config.getFocalPlaneSubsystemName(), 10);
            this.sendCommand("publishConfigurationInfo", new Object[0]);
        }
        catch (IOException | UnauthorizedLevelException | UnauthorizedLockException x) {
            throw new RuntimeException("Failed to lock subsystem " + this.config.getFocalPlaneSubsystemName(), x);
        }
    }

    void clear(int nClears) {
        this.sendCommand("clear", nClears);
    }

    private Object sendCommand(String command, Object ... args) {
        CommandRequest request = new CommandRequest(this.config.getFocalPlaneSubsystemName(), command, args);
        ConcurrentMessagingUtils cmu = new ConcurrentMessagingUtils(this.mcm.getMessagingAccess());
        try {
            return cmu.sendSynchronousCommand(request);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, "Error executing command", ex);
            return null;
        }
    }

    private void handleStatusChangeMessage(StatusMessage msg) {
        StatusStateChangeNotification statusChange = (StatusStateChangeNotification)msg;
        StateBundle newStates = statusChange.getNewState();
        StateBundle oldStates = statusChange.getOldState();
        StateBundle changedStates = newStates.diffState(oldStates);
        changedStates.getDecodedStates().entrySet().stream().map(changedState -> (Enum)changedState.getValue()).forEachOrdered(value -> this.translateFocalPlaneStateToRaftsState((Enum)value));
    }

    private void translateFocalPlaneStateToRaftsState(Enum value) {
        LOG.log(Level.INFO, "Got focal-plane state {0} ", value);
        Enum<Rafts.RaftsState> converted = FOCALPLANE_TO_RAFTS_STATE.get(value);
        if (converted != null) {
            this.ccs.getAggregateStatus().add(new State<Enum<Rafts.RaftsState>>(converted));
        }
    }

    static {
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.NEEDS_CLEAR, Rafts.RaftsState.NEEDS_CLEAR);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.CLEARING, Rafts.RaftsState.CLEARING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.INTEGRATING, Rafts.RaftsState.INTEGRATING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.READING_OUT, Rafts.RaftsState.READING_OUT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.QUIESCENT, Rafts.RaftsState.QUIESCENT);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.ROW_SHIFT, Rafts.RaftsState.INTEGRATING);
        FOCALPLANE_TO_RAFTS_STATE.put((Enum<FocalPlaneState>)FocalPlaneState.IMAGE_WAIT, Rafts.RaftsState.READING_OUT);
    }
}

