/*
 * Decompiled with CFR 0.152.
 */
package org.lsst.ccs.subsystem.ocsbridge.util;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.lsst.ccs.subsystem.ocsbridge.sim.MCM;
import org.lsst.ccs.subsystem.ocsbridge.sim.Shutter;
import org.lsst.ccs.subsystem.ocsbridge.util.OCSStateEventConverter;
import org.lsst.sal.camera.CameraStateChangeEvent;
import org.lsst.sal.camera.states.ImageReadinessDetailedStateEvent;
import org.lsst.sal.camera.states.ShutterDetailedStateEvent;
import org.lsst.sal.camera.states.SummaryStateEvent;

public class OCSStateEventConverterTest {
    private OCSStateEventConverter converter;

    @Before
    public void setUp() {
        this.converter = new OCSStateEventConverter();
    }

    @Test
    public void testConvert() throws ReflectiveOperationException {
        MCM.TakeImageReadinessState ccsEnum = MCM.TakeImageReadinessState.GETTING_READY;
        CameraStateChangeEvent converted = this.converter.convert((Enum)ccsEnum, 99);
        Assert.assertTrue((boolean)(converted instanceof ImageReadinessDetailedStateEvent));
        Assert.assertEquals((Object)((ImageReadinessDetailedStateEvent)converted).getSubstate(), (Object)ImageReadinessDetailedStateEvent.ImageReadinessState.GETTING_READY);
        SummaryStateEvent.SummaryState lse209disabled = SummaryStateEvent.SummaryState.DISABLED;
        CameraStateChangeEvent convertDisable209 = this.converter.convert((Enum)lse209disabled, 99);
        Assert.assertTrue((boolean)(convertDisable209 instanceof SummaryStateEvent));
        Assert.assertEquals((Object)((SummaryStateEvent)convertDisable209).getSubstate(), (Object)SummaryStateEvent.SummaryState.DISABLED);
        Shutter.ShutterState shutterCCS = Shutter.ShutterState.CLOSED;
        CameraStateChangeEvent convertedClosedShutter = this.converter.convert((Enum)shutterCCS, 99);
        Assert.assertTrue((boolean)(convertedClosedShutter instanceof ShutterDetailedStateEvent));
        Assert.assertEquals((Object)((ShutterDetailedStateEvent)convertedClosedShutter).getSubstate(), (Object)ShutterDetailedStateEvent.ShutterState.CLOSED);
        CameraStateChangeEvent event = this.converter.convert((Enum)Unknown.UNKNOWN, 0);
        Assert.assertNull((Object)event);
    }

    private static enum Unknown {
        UNKNOWN;

    }
}

